<?php 
/**
 * Style Two
 * @package WordPress
 * @subpackage Varn
*/
if ( ! function_exists( 'varn_nav_area2' ) ) {
	function varn_nav_area2() { 
		global $varn_opt;

		// Search and burger menu
		if( isset( $varn_opt['search_placeholder_text'] ) ):
			$burger_menu		= $varn_opt['enable_burger_menu'];
			$search_icon 		= $varn_opt['enable_search_icon'];
			$search_place 		= $varn_opt['search_placeholder_text'];
			$cart_icon 			= $varn_opt['enable_cart_icon'];
		else:
			$burger_menu		= false;
			$search_icon		= false;
			$search_place 		= '';
			$cart_icon 			= false;
		endif;

		// Main site logo
		if(isset($varn_opt['main_logo']['url'])):
			$logo 	= $varn_opt['main_logo']['url'];
		else:
			$logo	= '';	
		endif;
		
		// White site logo
		if(isset($varn_opt['white_logo']['url'])):
			$white_logo 	= $varn_opt['white_logo']['url'];
		else:
			$white_logo	= '';	
		endif;

		// Logo for mobile device
		if(isset($varn_opt['mobile_logo']['url'])):
			$mobile_logo 	= $varn_opt['mobile_logo']['url'];
		else:
			$mobile_logo	= '';	
		endif;

		$varn_cart_icon 			= !empty($varn_opt['cart_icon']) ? $varn_opt['cart_icon'] : '';

		$hide_adminbar = 'hide-adminbar';

		?>
		<div class="navbar-area navbar-area-two <?php if ( is_user_logged_in() ) { echo esc_attr( $hide_adminbar ); } ?>">
			<div class="aronix-responsive-nav">
				<div class="container">
					<div class="aronix-responsive-menu">
						<div class="logo">
							<a href="<?php echo esc_url( home_url( '/' ) );?>">
								<?php if( $mobile_logo != '' ): ?>
									<img src="<?php echo esc_url( $mobile_logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
								<?php elseif( $logo != '' ): ?>
									<img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
								<?php else: ?>
									<h2><?php bloginfo( 'name' ); ?></h2>
								<?php endif; ?>
							</a>
						</div>
					</div>
				</div>
			</div>

			<div class="aronix-nav">
				<div class="container">
					<nav class="navbar navbar-expand-md navbar-light">
						<a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
							<?php if( $logo != '' || $white_logo != '' ): ?>
								<img src="<?php echo esc_url( $logo ); ?>" class="black-logo" alt="<?php bloginfo( 'name' ); ?>">
								<img src="<?php echo esc_url( $white_logo ); ?>" class="white-logo" alt="logo">
							<?php else: ?>
								<h2><?php bloginfo( 'name' ); ?></h2>
							<?php endif; ?>
						</a>

						<div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
							<?php
							$primary_nav_arg = [
								'menu'            => 'primary',
								'theme_location'  => 'primary',
								'container'       => null,
								'menu_class'      => 'navbar-nav ml-auto',
								'depth'           => 3,
								'walker'          => new Varn_Bootstrap_Navwalker(),
								'fallback_cb'     => 'Varn_Bootstrap_Navwalker::fallback',
							];
					
							if(has_nav_menu('primary')){
								wp_nav_menu($primary_nav_arg);
							}
							?>

							<div class="others-options">
								
								<?php if ( class_exists( 'WooCommerce' ) ):?>
									<?php if( $cart_icon == true ): ?>
										<a href="<?php echo esc_url(wc_get_cart_url()) ?>" class="cart-link">
											<i class="<?php echo esc_attr( $varn_cart_icon ); ?>"></i>
											<span class="mini-cart-count"></span>
										</a> 
									<?php endif; ?>
								<?php endif; ?>

								<?php if( $search_icon == true ): ?>
									<div class="option-item"><i class="search-btn flaticon-search"></i>
										<i class="close-btn flaticon-close"></i>
										<div class="search-overlay search-popup">
											<div class='search-box'>
												<form role="search" method="get" id="searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>" class="search-form">
													<input type="search" class="search-input" placeholder="<?php echo esc_attr( $search_place ); ?>" value="<?php echo get_search_query(); ?>" name="s" id="s" required>
													<button class="search-button" type="submit"><i class="fas fa-search"></i></button>
												</form>
											</div>
										</div>
									</div>
								<?php endif; ?>

								<?php if( $burger_menu == true ): ?>
									<div class="burger-menu">
										<span></span>
										<span></span>
										<span></span>
									</div>
								<?php endif; ?>
							</div>
						</div>
					</nav>
				</div>
			</div>
		</div><!-- End Navbar Area -->

		<?php
	}
}