<?php 
/**
 * Style One
 * @package WordPress
 * @subpackage Varn
*/
	if ( ! function_exists( 'varn_nav_area' ) ) {
		function varn_nav_area() { 
			global $varn_opt;

			if( isset( $varn_opt['enable_lazyloader'] ) ):
				$is_lazyloader = $varn_opt['enable_lazyloader'];
			else:
				$is_lazyloader = true;
			endif;

			if( isset( $varn_opt['varn_top_header_location'] ) ):
				$varn_enable_top_header         = $varn_opt['varn_enable_top_header'];
				$varn_enable_top_social         = $varn_opt['varn_enable_top_social'];
				$varn_top_header_location       = $varn_opt['varn_top_header_location'];
				$varn_top_header_phone_title    = $varn_opt['varn_top_header_phone_title'];
				$varn_top_header_phone          = $varn_opt['varn_top_header_phone'];
				$varn_top_header_phone_link     = $varn_opt['varn_top_header_phone_link'];
			else:
				$varn_enable_top_header         = false;
				$varn_enable_top_social         = '';
				$varn_top_header_location       = '';
				$varn_top_header_phone_title    = '';
				$varn_top_header_phone          = '';
				$varn_top_header_phone_link     = '';
			endif;

			// Search and burger menu
			if( isset( $varn_opt['search_placeholder_text'] ) ):
				$burger_menu		= $varn_opt['enable_burger_menu'];
				$search_icon 		= $varn_opt['enable_search_icon'];
				$search_place 		= $varn_opt['search_placeholder_text'];
				$cart_icon 			= $varn_opt['enable_cart_icon'];
			else:
				$burger_menu		= false;
				$search_icon		= false;
				$search_place 		= '';
				$cart_icon 			= false;
			endif;

			// Main site logo
			if(isset($varn_opt['main_logo']['url'])):
				$logo 	= $varn_opt['main_logo']['url'];
			else:
				$logo	= '';	
			endif;

			// Logo for mobile device
			if(isset($varn_opt['mobile_logo']['url'])):
				$mobile_logo 	= $varn_opt['mobile_logo']['url'];
			else:
				$mobile_logo	= '';	
			endif;

			$varn_cart_icon 			= !empty($varn_opt['cart_icon']) ? $varn_opt['cart_icon'] : '';

			$hide_adminbar = 'hide-adminbar';

			?>
			<header class="header-area <?php if ( is_user_logged_in() ) { echo esc_attr( $hide_adminbar ); } ?>">

				<?php if( $varn_enable_top_header == true ): ?>
				<!-- Top Header -->
					<div class="top-header">
						<div class="container">
							<div class="row align-items-center">
								<?php if( $varn_enable_top_social == true ): ?>
									<div class="col-lg-4 col-md-12">
										<ul class="top-header-social">
											<?php varn_social_link(); ?>
										</ul>
									</div>
								<?php endif; ?>

								<div class="col-lg-8 col-md-12">
									<ul class="top-header-contact-info">
										<?php if( $varn_top_header_location != '' ): ?>
											<li><i class='bx bx-map'></i> <?php echo esc_html( $varn_top_header_location ); ?></li>
										<?php endif; ?>
										
										<?php if( $varn_top_header_phone_title != '' || $varn_top_header_phone != '' ): ?>
											<li><i class='bx bx-phone-call'></i> <?php echo esc_html( $varn_top_header_phone_title ); ?> <a href="<?php echo esc_url( $varn_top_header_phone_link ); ?>"><?php echo esc_html( $varn_top_header_phone ); ?></a></li>
										<?php endif; ?>
									</ul>
								</div>
							</div>
						</div>
					</div>
				<!-- End Top Header -->
				<?php endif; ?>

				<div class="navbar-area">
					<div class="aronix-responsive-nav">
						<div class="container">
							<div class="aronix-responsive-menu">
								<div class="logo">
									<a href="<?php echo esc_url( home_url( '/' ) );?>">
										<?php if( $mobile_logo != '' ): ?>
											<?php if( $is_lazyloader == true ): ?>
												<img class="smartify" sm-src="<?php echo esc_url( $mobile_logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
											<?php else: ?>
												<img src="<?php echo esc_url( $mobile_logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
											<?php endif; ?>
										<?php elseif( $logo != '' ): ?>
											<?php if( $is_lazyloader == true ): ?>
												<img class="smartify" sm-src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
											<?php else: ?>
												<img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
											<?php endif; ?>
										<?php else: ?>
											<h2><?php bloginfo( 'name' ); ?></h2>
										<?php endif; ?>
									</a>
								</div>
							</div>
						</div>
					</div>

					<div class="aronix-nav">
						<div class="container">
							<nav class="navbar navbar-expand-md navbar-light">
								<a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
									<?php if( $logo != '' ): ?>
										<?php if( $is_lazyloader == true ): ?>
											<img class="smartify" sm-src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
										<?php else: ?>
											<img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
										<?php endif; ?>
									<?php else: ?>
										<h2><?php bloginfo( 'name' ); ?></h2>
									<?php endif; ?>
								</a>

								<div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
									<?php
									$primary_nav_arg = [
										'menu'            => 'primary',
										'theme_location'  => 'primary',
										'container'       => null,
										'menu_class'      => 'navbar-nav ml-auto',
										'depth'           => 3,
										'walker'          => new Varn_Bootstrap_Navwalker(),
										'fallback_cb'     => 'Varn_Bootstrap_Navwalker::fallback',
									];
							
									if(has_nav_menu('primary')){
										wp_nav_menu($primary_nav_arg);
									}
									?>

									<div class="others-options">
										
										<?php if ( class_exists( 'WooCommerce' ) ):?>
											<?php if( $cart_icon == true ): ?>
												<a href="<?php echo esc_url(wc_get_cart_url()) ?>" class="cart-link">
													<i class="<?php echo esc_attr( $varn_cart_icon ); ?>"></i>
													<span class="mini-cart-count"></span>
												</a> 
											<?php endif; ?>
										<?php endif; ?>

										<?php if( $search_icon == true ): ?>
											<div class="option-item"><i class="search-btn flaticon-search"></i>
												<i class="close-btn flaticon-close"></i>
												<div class="search-overlay search-popup">
													<div class='search-box'>
														<form role="search" method="get" id="searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>" class="search-form">
															<input type="search" class="search-input" placeholder="<?php echo esc_attr( $search_place ); ?>" value="<?php echo get_search_query(); ?>" name="s" id="s" required>
															<button class="search-button" type="submit"><i class="fas fa-search"></i></button>
														</form>
													</div>
												</div>
											</div>
										<?php endif; ?>

										<?php if( $burger_menu == true ): ?>
											<div class="burger-menu">
												<span></span>
												<span></span>
												<span></span>
											</div>
										<?php endif; ?>
									</div>
									
								</div>
							</nav>
						</div>
					</div>
				</div><!-- End Navbar Area -->
			</header>
			<?php
		}
	}