<?php 
/**
 * Varn post content
 */

global $varn_opt;

// Post thumb size
if(isset($varn_opt['varn_blog_sidebar'])) {
   if( $varn_opt['varn_blog_sidebar'] == 'varn_without_sidebar' ):
        $thumb_size = 'full';
   else:
        $thumb_size = 'varn_post_thumb';
   endif;
}else {
    $thumb_size = 'varn_post_thumb';
}

if( isset( $varn_opt['read_more'] ) ):
    $read_more  = $varn_opt['read_more'];
    //$by_text    = $varn_opt['by_text'];
else:
    $read_more  = 'Read More';
    //$by_text    = 'By:';
endif;

if( isset( $varn_opt['enable_lazyloader'] ) ):
	$is_lazyloader = $varn_opt['enable_lazyloader'];
else:
	$is_lazyloader = true;
endif;

// Author info
$get_author_id = get_the_author_meta('ID');

// Blog Column
$varn_blog_grid = !empty($varn_opt['varn_blog_grid']) ? $varn_opt['varn_blog_grid'] : 'col-lg-12 col-md-12';
if ( !empty($_GET['varn_blog_grid']) ) {
    $varn_blog_grid = $_GET['varn_blog_grid'];
}

?>

<div <?php post_class( $varn_blog_grid ); ?>>
    <div class="single-blog-post">
        <?php if(has_post_thumbnail()) { ?>
            <div class="post-image">
                <a href="<?php the_permalink() ?>">
                    <?php if( $is_lazyloader == true ): ?>
                        <img class="smartify" sm-src="<?php the_post_thumbnail_url($thumb_size) ?>" alt="<?php the_title_attribute(); ?>">
                    <?php else: ?>
                        <img src="<?php the_post_thumbnail_url($thumb_size) ?>" alt="<?php the_title_attribute(); ?>">
                    <?php endif; ?>
                </a>
            </div>
        <?php } ?>

        <div class="post-content">
            <?php if( isset( $varn_opt['is_post_meta'] ) && $varn_opt['is_post_meta'] == true ) { ?>
                <div class="post-meta">
                    <ul>
                        <li><?php esc_html_e( 'By:', 'varn' ); ?> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ); ?>"><?php echo esc_html(get_the_author()); ?></a></li>
                        <li><?php echo esc_html(get_the_date()); ?></li>
                    </ul>
                </div> <?php
            } ?>
            
            <?php if( get_the_title() != '' ): ?>
                <h3><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h3>
            <?php endif; ?>
            <?php the_excerpt() ?>

            <?php if( $read_more != '' ): ?>
                <a href="<?php the_permalink() ?>" class="read-more-btn"><?php echo esc_html( $read_more ); ?> <i class="flaticon-right-arrow"></i></a>
            <?php endif; ?>
        </div>
    </div>
</div>