<?php
/**
 * The single template file
 * @package Varn
 */
get_header();

$title = get_the_title();

// Blog sidebar
if(isset($varn_opt['varn_blog_sidebar'])) {
    if( $varn_opt['varn_blog_sidebar'] == 'varn_without_sidebar_center' ):
        $varn_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
    elseif( $varn_opt['varn_blog_sidebar'] == 'varn_without_sidebar' ):
        $varn_sidebar_class = 'col-lg-12 col-md-12';
    else:
        if( is_active_sidebar( 'sidebar-1' ) ):
            $varn_sidebar_class = 'col-lg-8 col-md-12';
        else:
            $varn_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
        endif;
    endif;
    $sidebar_hide = $varn_opt['varn_blog_sidebar'];
} else {
    if( is_active_sidebar( 'sidebar-1' ) ):
        $varn_sidebar_class = 'col-lg-8 col-md-12';
        $sidebar_hide = 'varn_with_sidebar';
    else:
        $varn_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
        $sidebar_hide = 'varn_without_sidebar';
    endif;
} 

// Blog breadcrumb
if( isset($varn_opt['blog_title']) ) {
    $hide_breadcrumb    	= $varn_opt['hide_breadcrumb'];
    $blog_title              = $varn_opt['blog_title'];
    $hide_blog_banner       = $varn_opt['hide_blog_banner'];
} else {
    $hide_breadcrumb    	= 	false;
    $blog_title              = esc_html__('Blog', 'varn');
    $hide_blog_banner       = false;
}

if( function_exists('acf_add_options_page') ) {
	$bg_img = get_field( 'post_banner_background_image' );
}else {
	$bg_img = '';
}

// Blog page link
if ( get_option( 'page_for_posts' ) ) {
	$blog_link = get_permalink( get_option( 'page_for_posts' ));
}else{
	$blog_link = home_url( '/' );
}

if( isset( $varn_opt['enable_lazyloader'] ) ):
	$is_lazyloader = $varn_opt['enable_lazyloader'];
else:
	$is_lazyloader = true;
endif;

$varn_blog_single_layout = !empty($varn_opt['varn_blog_single_layout']) ? $varn_opt['varn_blog_single_layout'] : 'container';
if ( !empty($_GET['varn_blog_single_layout']) ) {
    $varn_blog_single_layout = $_GET['varn_blog_single_layout'];
}

if( isset($varn_opt['page_title_tag']) ):
    $tag = $varn_opt['page_title_tag'];
else:
    $tag = 'h2';
endif;
?>
    <?php if( $hide_blog_banner == false ): ?>
        <?php if( $bg_img != '' ): ?>
            <div class="page-title-area page-title-bg1 page_bg_area" style="background-image:url( <?php echo esc_url( $bg_img ); ?> );">
        <?php else: ?>
            <div class="page-title-area page-title-bg1">
        <?php endif; ?>
			<div class="d-table">
				<div class="d-table-cell">
					<div class="container">
						<div class="page-title-content">
							<?php if($title != ''): ?>
								<<?php echo esc_attr( $tag ); ?>><?php the_title(); ?></<?php echo esc_attr( $tag ); ?>>
							<?php else: ?>
								<<?php echo esc_attr( $tag ); ?>><?php echo esc_html__('No Title', 'varn'); ?></<?php echo esc_attr( $tag ); ?>>
							<?php endif; ?>

							<?php if( $hide_breadcrumb == false ): ?>
								<?php
									if ( function_exists('yoast_breadcrumb') ) {
										yoast_breadcrumb( '<p class="varn-seo-breadcrumbs" id="breadcrumbs">','</p>' );
									} else { ?>
										<ul>
											<?php if ( get_option( 'page_for_posts' ) ) { ?>
												<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'varn' ); ?></a></li>
											<?php }  ?>
											<li><a href="<?php echo esc_url( $blog_link ); ?>"><?php echo esc_html( $blog_title ); ?></a></li>
											<?php if($title != ''): ?>
												<li><?php the_title(); ?></li>
											<?php else: ?>
												<li><?php echo esc_html__('No Title', 'varn'); ?></li>
											<?php endif; ?>
										</ul> <?php
									}
								?>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>

			<?php varn_page_shape_images(); ?>
		</div>
    <?php endif; ?>

	<!-- Start Blog Area -->
	<div class="blog-details-area ptb-100">
		<div class="<?php echo esc_attr( $varn_blog_single_layout ); ?>">
			<div class="row">
				<?php
				while ( have_posts() ) : 
				the_post(); ?>
					<div class="<?php echo esc_attr( $varn_sidebar_class ); ?>">
						<div class="blog-details">
							<?php if(has_post_thumbnail()) { ?>
								<div class="post-image">
									<?php if( $is_lazyloader == true ): ?>
										<img class="smartify" sm-src="<?php the_post_thumbnail_url('full') ?>" alt="<?php the_title_attribute(); ?>">
									<?php else: ?>
										<img src="<?php the_post_thumbnail_url('full') ?>" alt="<?php the_title_attribute(); ?>">
									<?php endif; ?>
								</div>
							<?php } ?> 
	
							<div class="blog-details-content">
								<?php if( isset( $varn_opt['is_post_meta'] ) && $varn_opt['is_post_meta'] == true ) { ?>
									<div class="blog-meta">
										<ul>
											<li><i class="fas fa-user-circle"></i> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ) ?>"> <?php the_author() ?></a></li>
											<li><i class="fas fa-calendar"></i> <?php echo wp_kses_post(get_the_date('F d, Y')) ?></li>
											<li><i class="fas fa-comment"></i> <?php comments_number(); ?></li>
										</ul>
									</div> <?php
								} ?>

								<?php the_content(); 
								
								wp_link_pages( array(
									'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'varn' ),
									'after'  => '</div>',
								) );
								?>

								<?php if ( get_the_tags() ) {  ?>
								<div class="post-tag-media">
									<ul class="tag">
										<li><span><?php echo esc_html_e('Tags:', 'varn') ?></span></li>
										<?php $tags = get_the_tags();
										foreach ($tags as $tag ) {  ?>
												<li><a href="<?php echo esc_url(get_tag_link($tag->term_id)); ?>">
													<?php echo esc_html($tag->name) ?></a>
												</li>
											<?php
										} ?>
									</ul>
								</div>
								<?php } ?>
							</div>
						</div>
					
						<?php
							// If comments are open or we have at least one comment, load up the comment template.
							if ( comments_open() || get_comments_number() ) :
								comments_template();
							endif;
						?>
					</div>
				<?php endwhile; // End of the loop. ?>
				
				<?php if( $sidebar_hide == 'varn_with_sidebar' ): ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>

			</div>
		</div>
	</div>
	<!-- End Blog Area -->

<?php
get_footer();
