<?php
/**
 * Single Services
 */
get_header();

    global $varn_opt;

    $hide_service_banner        =   $varn_opt['hide_service_banner'];
    $hide_services_breadcrumb   =   $varn_opt['hide_services_breadcrumb'];

    if( function_exists('acf_add_options_page') ) {
        $bg_img = get_field( 'service_banner_background_image' );
    }else {
        $bg_img = '';
    }

    if( $hide_service_banner == false ):
        $pt_165   = '';
    else:
        $pt_165   = 'pt-165';
    endif;

    // Page Title 
    if( isset($varn_opt['page_title_tag']) ):
        $tag = $varn_opt['page_title_tag'];
    else:
        $tag = 'h2';
    endif;

?>
    <!-- Start Page Title Area -->
    <?php if( $hide_service_banner == false ): ?>
        <?php if( $bg_img != '' ): ?>
            <div class="page-title-area page-title-bg1 page_bg_area" style="background-image:url( <?php echo esc_url( $bg_img ); ?> );">
        <?php else: ?>
            <div class="page-title-area page-title-bg1">
        <?php endif; ?>
            <div class="d-table">
                <div class="d-table-cell">
                    <div class="container">
                        <div class="page-title-content">
                            <<?php echo esc_attr( $tag ); ?>><?php the_title(); ?></<?php echo esc_attr( $tag ); ?>>

                            <?php if( $hide_services_breadcrumb == false ): ?>
                                <?php
									if ( function_exists('yoast_breadcrumb') ) {
										yoast_breadcrumb( '<p class="varn-seo-breadcrumbs" id="breadcrumbs">','</p>' );
									} else { ?>
                                        <ul>
                                            <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'varn' ); ?></a></li>
                                            <li><?php the_title(); ?></li>
                                        </ul> <?php 
                                    } 
                                endif; ?>
                        </div>
                    </div>
                </div>
            </div>
			<?php varn_page_shape_images(); ?>
        </div>
    <?php endif; ?>
    <!-- End Page Title Area -->

    <section class="services-details-area ptb-100 <?php echo esc_attr( $pt_165 ); ?>">
        <?php while ( have_posts() ) : the_post(); ?>
            <?php the_content(); ?>
        <?php endwhile; ?>
    </section>
<?php get_footer();