<?php
/**
 * Single Projects
 */
    get_header();

    global $varn_opt;

    $hide_project_banner        =   $varn_opt['hide_project_banner'];
    $hide_project_breadcrumb    =   $varn_opt['hide_project_breadcrumb'];

    if( function_exists('acf_add_options_page') ) {
        $bg_img = get_field( 'project_banner_background_image' );
    }else {
        $bg_img = '';
    }

    if( $hide_project_banner == false ):
        $pt_165   = '';
    else:
        $pt_165   = 'pt-165';
    endif;

    if( isset( $varn_opt['enable_lazyloader'] ) ):
        $is_lazyloader = $varn_opt['enable_lazyloader'];
    else:
        $is_lazyloader = true;
    endif;

    // Page Title 
    if( isset($varn_opt['page_title_tag']) ):
        $tag = $varn_opt['page_title_tag'];
    else:
        $tag = 'h2';
    endif;

?>


    <!-- Start Page Title Area -->
    <?php if( $hide_project_banner == false ): ?>
        <?php if( $bg_img != '' ): ?>
            <div class="page-title-area page-title-bg1 page_bg_area" style="background-image:url( <?php echo esc_url( $bg_img ); ?> );">
        <?php else: ?>
            <div class="page-title-area page-title-bg1">
        <?php endif; ?>
            <div class="d-table">
                <div class="d-table-cell">
                    <div class="container">
                        <div class="page-title-content">
                            <<?php echo esc_attr( $tag ); ?>><?php the_title(); ?></<?php echo esc_attr( $tag ); ?>>

                            <?php if( $hide_project_breadcrumb == false ): ?>
                                <?php if ( function_exists('yoast_breadcrumb') ) {
										yoast_breadcrumb( '<p class="varn-seo-breadcrumbs" id="breadcrumbs">','</p>' );
                                } else { ?>
                                    <ul>
                                        <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'varn' ); ?></a></li>
                                        <li><?php the_title(); ?></li>
                                    </ul><?php
                                }
                            endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            
			<?php varn_page_shape_images(); ?>
        </div>
    <?php endif; ?>
    <!-- End Page Title Area -->

    <section class="project-details-area ptb-100 <?php echo esc_attr( $pt_165 ); ?>">
        <?php while ( have_posts() ) : the_post(); ?>
            <div class="container">
                <div class="row">
                <?php if( have_rows('projects_images') ): ?>
                    <?php while( have_rows('projects_images') ): the_row(); 

                        // vars
                        $image              = get_sub_field('image');
                        $select_option      = get_sub_field('select_option');
                        $video_link         = get_sub_field('video_link');

                        ?>
        
                        <div class="col-lg-6 col-md-6">
                            <div class="project-details-image">
                                <?php if( $is_lazyloader == true ): ?>
                                    <img class="smartify" sm-src="<?php echo esc_url( $image ); ?>" alt="<?php the_title(); ?>">
                                <?php else: ?>
                                    <img src="<?php echo esc_url( $image ); ?>" alt="<?php the_title(); ?>">
                                <?php endif; ?>
                                <?php if( $select_option == 'video_link' ): ?>
                                    <a href="<?php echo esc_url( $video_link ); ?>" class="popup-youtube"><i class="flaticon-play-button"></i></a>
                                <?php elseif( $select_option != 'none' ): ?>
                                    <a href="<?php echo esc_url( $image ); ?>" class="popup-btn"><i class="fas fa-plus"></i></a>
                                <?php endif; ?>
                            </div>
                        </div>
	                <?php endwhile; ?>
                <?php endif; ?>    

                    <div class="col-lg-12 col-md-12">
                        <div class="projects-details-desc">
                            <?php the_content(); ?>

                            <div class="project-details-info">
                                <?php
                                    // project info
                                    $name_label                 =   get_field('client_name_label');
                                    $client_name                =   get_field('client_name');
                                    $category_label             =   get_field('category_label');
                                    $project_date_label         =   get_field('project_completed_date_label');
                                    $project_completed_date     =   get_field('project_completed_date');
                                    $location_label             =   get_field('location_label');
                                    $location                   =   get_field('location');
                                    $live_preview_button_text   =   get_field('live_preview_button_text');
                                    $live_preview_link          =   get_field('live_preview_link');

                                if( $name_label || $client_name ): ?>
                                    <div class="single-info-box">
                                        <h4><?php echo esc_html( $name_label ); ?></h4>
                                        <p><?php echo esc_html( $client_name ); ?></p>
                                    </div>
                                <?php endif; ?>

                                <?php
                                $terms = wp_get_post_terms($post->ID, 'project_cat'); 
                                if ($terms) { ?>
                                    <div class="single-info-box">
                                        <h4><?php echo esc_html( $category_label ); ?></h4>
                                        <p><?php $output = array(); foreach ($terms as $term) { $output[] = $term->name; } echo join( ', ', $output );?></p>
                                    </div>
                                    <?php
                                } ?>

                                <?php if( $project_date_label || $project_completed_date  ): ?>
                                    <div class="single-info-box">
                                        <h4><?php echo esc_html( $project_date_label ); ?></h4>
                                        <p><?php echo esc_html( $project_completed_date ); ?></p>
                                    </div>
                                <?php endif; ?>

                                <?php if( $location_label || $location ): ?>
                                    <div class="single-info-box">
                                        <h4><?php echo esc_html( $location_label ); ?></h4>
                                        <p><?php echo esc_html( $location ); ?></p>
                                    </div>
                                <?php endif; ?>

                                <?php if( $live_preview_button_text || $live_preview_link ): ?>
                                    <div class="single-info-box">
                                        <a href="<?php echo esc_url( $live_preview_link ); ?>" class="default-btn"><?php echo esc_html( $live_preview_button_text ); ?> <span></span></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endwhile; ?>
    </section>

<?php get_footer();