<?php
/**
 * Include the TGM_Plugin_Activation class.
 */
$pcs = trim( get_option( 'varn_purchase_code_status' ) );

require_once dirname( __FILE__ ) . '/class-tgm-plugin-activation.php';

if ( $pcs == 'valid' ) {
	add_action( 'tgmpa_register', 'varn_register_required_plugins' );
}

if ( ! function_exists( 'varn_register_required_plugins' ) ) {
	function varn_register_required_plugins() {

		$plugins = array(
			
			array(
				'name'               => esc_html__('Varn Toolkit', 'varn'),
				'slug'               => 'varn-toolkit',
				'source'             => get_stylesheet_directory() . '/lib/plugins/varn-toolkit.zip', 
				'required'           => true,
			),

			// Elemantor Page Builder
			array(
				'name'               => esc_html__('Elementor Page Builder', 'varn'),
				'slug'               => 'elementor',
				'required'           => true,
			),

			// Advanced Custom Fields Pro
			array(
				'name'               => esc_html__('Advanced Custom Fields Pro', 'varn'),
				'slug'               => 'advanced-custom-fields-pro',
				'source'             => get_stylesheet_directory() . '/lib/plugins/advanced-custom-fields-pro.zip', 
				'required'           => true,
			),

			// Varn Plugins

			array(
				'name'      => esc_html__('Advance Custom Field Font Awesome', 'varn'),
				'slug'      => 'advanced-custom-fields-font-awesome',
				'required'  => true,
			),
			array(
				'name'      => esc_html__('WooCommerce', 'varn'),
				'slug'      => 'woocommerce',
				'required'  => false,
			),
			array(
				'name'      => esc_html__('Contact Form 7', 'varn'),
				'slug'      => 'contact-form-7',
				'required'  => false,
			),
			array(
				'name'		 => esc_html__( 'Unyson', 'varn' ),
				'slug'		 => 'unyson',
				'required'	 => true,
			),
		);

		$config = array(
			'id'           => 'tgmpa',
			'default_path' => '',
			'menu'         => 'tgmpa-install-plugins',
			'parent_slug'  => 'themes.php',
			'capability'   => 'edit_theme_options',
			'has_notices'  => true, 
			'dismissable'  => true, 
			'dismiss_msg'  => '',   
			'is_automatic' => false, 
			'message'      => '',                      
		);
		tgmpa( $plugins, $config );
	}
}