    <?php
    /**
     * The main template file
     * @package varn
     */
    get_header();

    // Blog Sidebar
    if(isset($varn_opt['varn_blog_sidebar'])) {
        if( $varn_opt['varn_blog_sidebar'] == 'varn_without_sidebar_center' ):
            $varn_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
        elseif( $varn_opt['varn_blog_sidebar'] == 'varn_without_sidebar' ):
            $varn_sidebar_class = 'col-lg-12 col-md-12';
        else:
            if( is_active_sidebar( 'sidebar-1' ) ):
                $varn_sidebar_class = 'col-lg-8 col-md-12';
            else:
                $varn_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
            endif;
        endif;
        $sidebar_hide = $varn_opt['varn_blog_sidebar'];
    } else {
        if( is_active_sidebar( 'sidebar-1' ) ):
            $varn_sidebar_class = 'col-lg-8 col-md-12';
            $sidebar_hide = 'varn_with_sidebar';
        else:
            $varn_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
            $sidebar_hide = 'varn_without_sidebar';
        endif;
    }

    // Blog title and breadcrumb
    if( isset($varn_opt['blog_title']) ) {
        $title                  = $varn_opt['blog_title'];
        $hide_breadcrumb        = $varn_opt['hide_breadcrumb'];
        $hide_blog_banner       = $varn_opt['hide_blog_banner'];
        $banner_bg              = $varn_opt['blog_banner_bg']['url'];
    } else {
        $title                  = esc_html__('Blog', 'varn');
        $hide_breadcrumb        = false;
        $hide_blog_banner       = false;
        $banner_bg              = '';
    }

    $varn_blog_layout = !empty($varn_opt['varn_blog_layout']) ? $varn_opt['varn_blog_layout'] : 'container';

    if ( !empty($_GET['varn_blog_layout']) ) {
        $varn_blog_layout = $_GET['varn_blog_layout'];
    }

    if( isset($varn_opt['page_title_tag']) ):
        $tag = $varn_opt['page_title_tag'];
    else:
        $tag = 'h2';
    endif;

    ?>

        <!-- Start Page Title Area -->
        <?php if( $hide_blog_banner == false ): ?>
            <?php if( $banner_bg != '' ): ?>
                <div class="page-title-area page-title-bg1 page_bg_area" style="background-image:url( <?php echo esc_url( $banner_bg ); ?> );">
            <?php else: ?>
                <div class="page-title-area page-title-bg1">
            <?php endif; ?>
                <div class="d-table">
                    <div class="d-table-cell">
                        <div class="container">
                            <div class="page-title-content">
                                <<?php echo esc_attr( $tag ); ?>><?php echo esc_html( $title ); ?></<?php echo esc_attr( $tag ); ?>>

                                <?php if( $hide_breadcrumb == false ): ?>
                                    <?php
									if ( function_exists('yoast_breadcrumb') ) {
										yoast_breadcrumb( '<p class="varn-seo-breadcrumbs" id="breadcrumbs">','</p>' );
									} else { ?>
                                        <ul>
                                            <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'varn' ); ?></a></li>
                                            <li><?php echo esc_html( $title ); ?></li>
                                        </ul> <?php 
                                    } 
                                endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                
                <?php varn_page_shape_images(); ?>
            </div>
        <?php endif; ?>
        <!-- End Page Title Area -->

        <!-- Start Blog Area -->
        <div class="blog-area ptb-100">
            <div class="<?php echo esc_attr( $varn_blog_layout ); ?>">
                <div class="row">
                    <!-- Start Blog Content -->
                    <div class="<?php echo esc_attr( $varn_sidebar_class ); ?>">
                        <div class="row">
                            <?php
                            if ( have_posts() ) :
                                while ( have_posts() ) :
                                    the_post();
                                    get_template_part( 'template-parts/content', get_post_format());
                                endwhile;
                            else :
                                get_template_part( 'template-parts/content', 'none' );
                            endif;
                            ?>
                        </div>
                
                        <!-- Stat Pagination -->
                        <div class="pagination-area">
                            <nav aria-label="navigation">
                            <?php echo paginate_links( array(
                                'format' => '?paged=%#%',
                                'prev_text' => '<i class="fas fa-angle-double-left"></i>',
                                'next_text' => '<i class="fas fa-angle-double-right"></i>',
                                    )
                                ) ?>
                            </nav>
                        </div>
                        <!-- End Pagination -->
                    </div>
                    <!-- End Blog Content -->
                    
                    <?php if( $sidebar_hide == 'varn_with_sidebar' ): ?>
                        <?php get_sidebar(); ?>
                    <?php endif; ?>
                </div>   
            </div>
        </div>
        <!-- End Blog Area -->
    <?php
    get_footer();
