<?php
/**
 * Register Theme Widget
 * @package Varn
 */


// Register sidebar
if ( ! function_exists( 'varn_widgets_init' ) ) {
    function varn_widgets_init() {
        register_sidebar( array(
            'name'          => esc_html__( 'Blog Sidebar', 'varn' ),
            'id'            => 'sidebar-1',
            'description'   => esc_html__( 'Add widgets here.', 'varn' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        ) );
        
         // Footer Sidebar
         global $varn_opt;
         $footer_column = !empty($varn_opt['footer_column']) ? $varn_opt['footer_column'] : '4';
         register_sidebar( array( 
             'name'          => esc_html__( 'Footer Widgets', 'varn' ),
             'id'            => 'footer_widgets',
             'description'   => esc_html__( 'Add widgets here.', 'varn' ),
             'before_widget' => '<div class="single-footer-widget col-lg-'.$footer_column.' col-md-'.$footer_column.' %2$s">',
             'after_widget'  => '</div>',
             'before_title'  => '<h3>',
             'after_title'   => '</h3>',
         ) );
    }
}
add_action( 'widgets_init', 'varn_widgets_init' );