<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 * @package Varn
 */

/**
 * Adds custom classes to the array of body classes.
 */
if ( ! function_exists( 'varn_body_classes' ) ) {
	function varn_body_classes( $classes ) {
		// Adds a class of hfeed to non-singular pages.
		if ( ! is_singular() ) {
			$classes[] = 'hfeed';
		}

		// Adds a class of no-sidebar when there is no sidebar present.
		if ( ! is_active_sidebar( 'sidebar-1' ) ) {
			$classes[] = 'no-sidebar';
		}

		return $classes;
	}
}
add_filter( 'body_class', 'varn_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
if ( ! function_exists( 'varn_pingback_header' ) ) {
	function varn_pingback_header() {
		if ( is_singular() && pings_open() ) {
			printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
		}
	}
}
add_action( 'wp_head', 'varn_pingback_header' );

/**
 * Varn Preloader
*/

if ( ! function_exists( 'varn_preloader' ) ) :
	function varn_preloader() { 
		global $varn_opt;

		if( isset( $varn_opt['enable_preloader'] ) ):
			$is_preloader = $varn_opt['enable_preloader'];
		else:
			$is_preloader = true;
		endif;

		//$is_preloader       = !empty($varn_opt['enable_preloader']) ? $varn_opt['enable_preloader'] : '1';
		
        $preloader_style    = !empty($varn_opt['preloader_style']) ? $varn_opt['preloader_style'] : 'circle-spin';

        if( $is_preloader == true ): 
            if ( defined( 'ELEMENTOR_VERSION' ) ) :
                if (\Elementor\Plugin::$instance->preview->is_preview_mode()) :
                    echo '';
                else:
                    if ( $preloader_style == 'text' ) :
                        if (!empty( $varn_opt['loading_text'] ) ) : ?>
                            <div class="preloader">
                                <div class="loader">
                                    <p class="text-center"> <?php echo esc_html( $varn_opt['loading_text'] ) ?> </p>
                                </div>
                            </div>
                        <?php endif;
                    elseif( $preloader_style == 'circle-spin' ) : ?>
                        <div class="preloader">
                            <div class="loader">
								<div class="shadow"></div>
								<div class="box"></div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="preloader preloader-img">
                            <div class="loader">
                            </div>
                        </div>
                    <?php endif;
                endif;
            else:
                if ( $preloader_style == 'text' ) :
                    if (!empty( $varn_opt['loading_text'] ) ) : ?>
                        <div class="preloader">
                            <div class="loader">
                                <p class="text-center"> <?php echo esc_html( $varn_opt['loading_text'] ) ?> </p>
                            </div>
                        </div>
                    <?php endif;
                elseif( $preloader_style == 'circle-spin' ) :
                    ?>
                    <div class="preloader">
                        <div class="loader">
							<div class="shadow"></div>
							<div class="box"></div>
                        </div>
                    </div>
                <?php else : ?>
                    <div class="preloader preloader-img">
                        <div class="loader">
                        </div>
                    </div>
                    <?php 
                endif;
            endif;
        endif;
	}
endif;

/**
 * 
 * Varn Modal
 * 
*/
if ( ! function_exists( 'varn_modal' ) ) {
	function varn_modal() { 
		global $varn_opt;

		if( isset( $varn_opt['enable_lazyloader'] ) ):
			$is_lazyloader = $varn_opt['enable_lazyloader'];
		else:
			$is_lazyloader = true;
		endif;

		// Modal Data
		if( isset( $varn_opt['modal_title'] ) ):
			$enable_burger_menu		= $varn_opt['enable_burger_menu'];
			$modal_title 			= $varn_opt['modal_title'];
			$modal_content 			= $varn_opt['modal_content'];
			$modal_gallery_title 	= $varn_opt['modal_gallery_title'];
			$modal_gallery_images 	= explode(',', $varn_opt['modal_gallery_images']);
			$modal_number_title 	= $varn_opt['modal_number_title'];
			$modal_number_link 		= $varn_opt['modal_number_link'];
			$modal_or_title 		= $varn_opt['modal_or_title'];
			$modal_email_title 		= $varn_opt['modal_email_title'];
			$modal_email_link 		= $varn_opt['modal_email_link'];
		else:
			$enable_burger_menu		= false;
			$modal_title			= '';
			$modal_content 			= '';
			$modal_gallery_title 	= '';
			$modal_gallery_images 	= '';
			$modal_number_title 	= '';
			$modal_number_link 		= '';
			$modal_or_title 		= '';
			$modal_email_title 		= '';
			$modal_email_link 		= '';
		endif;
		?>
		<?php if( $enable_burger_menu == true): ?>
			<div class="sidebar-modal">
				<div class="sidebar-modal-inner">
					<div class="sidebar-about-area">
						<div class="title">
							<h2><?php echo esc_html( $modal_title ); ?></h2>
							<p><?php echo esc_html( $modal_content ); ?></p>
						</div>
					</div>

					<div class="sidebar-instagram-feed">
						<h2><?php echo esc_html( $modal_gallery_title ); ?></h2>

						<?php if( $modal_gallery_images != '' ): ?>
							<ul>
								<?php foreach( $modal_gallery_images as $image ): ?>
									<?php $image_url = wp_get_attachment_image_src( $image ); ?>
									<li>
										<img src="<?php echo esc_url($image_url[0]); ?>" alt="<?php echo esc_attr( $modal_title ); ?>">
									</li>
								<?php endforeach;  ?>
							</ul>
						<?php endif; ?>
					</div>

					<div class="sidebar-contact-area">
						<div class="contact-info">
							<div class="contact-info-content">
								<h2>
									<a href="<?php echo esc_url( $modal_number_link ); ?>"><?php echo esc_html( $modal_number_title ); ?></a>
									<span><?php echo esc_html( $modal_or_title ); ?></span>
									<a href="<?php echo esc_url( $modal_email_link ); ?>"><?php echo esc_html( $modal_email_title ); ?></a>
								</h2>
								<ul class="social">
									<?php varn_social_link(); ?>
								</ul>
							</div>
						</div>
					</div>

					<span class="close-btn sidebar-modal-close-btn"><i class="flaticon-close"></i></span>
				</div>
			</div>
		<?php endif; ?>
		
		<?php
	}
}

/**
 * Varn Page Shape Images
 */
if ( ! function_exists( 'varn_page_shape_images' ) ) {
	function varn_page_shape_images() {
		global $varn_opt;

		if( isset( $varn_opt['enable_lazyloader'] ) ):
			$is_lazyloader = $varn_opt['enable_lazyloader'];
		else:
			$is_lazyloader = true;
		endif;

		if( isset($varn_opt['blog_title'])):
			if( $varn_opt['enable_shape_images'] == true  ):
				?>
					<div class="shape-img2">
						<?php if( $varn_opt['shape_image1']['url'] != ''  ): ?>
							<?php if( $is_lazyloader == true ): ?>
								<img class="smartify" sm-src="<?php echo esc_url( $varn_opt['shape_image1']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php else: ?>
								<img src="<?php echo esc_url( $varn_opt['shape_image1']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php endif; ?>
						<?php else: ?>
							<?php if( $is_lazyloader == true ): ?>
								<img class="smartify" sm-src="<?php echo esc_url( VARN_IMG .'/shape/2.svg' ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php else: ?>
								<img src="<?php echo esc_url( VARN_IMG .'/shape/2.svg' ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php endif; ?>
						<?php endif; ?>
					</div>
					<div class="shape-img3">
						<?php if( $varn_opt['shape_image2']['url'] != ''  ): ?>
							<?php if( $is_lazyloader == true ): ?>
								<img class="smartify" sm-src="<?php echo esc_url( $varn_opt['shape_image2']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php else: ?>
								<img src="<?php echo esc_url( $varn_opt['shape_image2']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php endif; ?>
						<?php else: ?>
							<?php if( $is_lazyloader == true ): ?>
								<img class="smartify" sm-src="<?php echo esc_url( VARN_IMG .'/shape/3.svg' ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php else: ?>
								<img src="<?php echo esc_url( VARN_IMG .'/shape/3.svg' ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php endif; ?>
						<?php endif; ?>
					</div>
					<div class="shape-img4">
						<?php if( $varn_opt['shape_image3']['url'] != ''  ): ?>
							<?php if( $is_lazyloader == true ): ?>
								<img class="smartify" sm-src="<?php echo esc_url( $varn_opt['shape_image3']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php else: ?>
								<img src="<?php echo esc_url( $varn_opt['shape_image3']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php endif; ?>
						<?php else: ?>
							<?php if( $is_lazyloader == true ): ?>
								<img class="smartify" sm-src="<?php echo esc_url( VARN_IMG .'/shape/4.png' ); ?>" alt="<?php echo esc_attr__( ' Shape Image Four', 'varn' ); ?>">
							<?php else: ?>
								<img src="<?php echo esc_url( VARN_IMG .'/shape/4.png' ); ?>" alt="<?php echo esc_attr__( ' Shape Image Four', 'varn' ); ?>">
							<?php endif; ?>
						<?php endif; ?>
					</div>
					<div class="shape-img5">
						<?php if( $varn_opt['shape_image4']['url'] != ''  ): ?>
							<?php if( $is_lazyloader == true ): ?>
								<img class="smartify" sm-src="<?php echo esc_url( $varn_opt['shape_image4']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php else: ?>
								<img src="<?php echo esc_url( $varn_opt['shape_image4']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php endif; ?>
						<?php else: ?>
							<?php if( $is_lazyloader == true ): ?>
								<img class="smartify" sm-src="<?php echo esc_url( VARN_IMG .'/shape/5.png' ); ?>" alt="<?php echo esc_attr__( ' Shape Image Four', 'varn' ); ?>">
							<?php else: ?>
								<img src="<?php echo esc_url( VARN_IMG .'/shape/5.png' ); ?>" alt="<?php echo esc_attr__( ' Shape Image Four', 'varn' ); ?>">
							<?php endif; ?>
						<?php endif; ?>
					</div>
					<div class="shape-img7">
						<?php if( $varn_opt['shape_image5']['url'] != ''  ): ?>
							<?php if( $is_lazyloader == true ): ?>
								<img class="smartify" sm-src="<?php echo esc_url( $varn_opt['shape_image5']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php else: ?>
								<img src="<?php echo esc_url( $varn_opt['shape_image5']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php endif; ?>
						<?php else: ?>
							<?php if( $is_lazyloader == true ): ?>
								<img class="smartify" sm-src="<?php echo esc_url( VARN_IMG .'/shape/7.png' ); ?>" alt="<?php echo esc_attr__( ' Shape Image Four', 'varn' ); ?>">
							<?php else: ?>
								<img src="<?php echo esc_url( VARN_IMG .'/shape/7.png' ); ?>" alt="<?php echo esc_attr__( ' Shape Image Four', 'varn' ); ?>">
							<?php endif; ?>
						<?php endif; ?>
					</div>
					<div class="shape-img8">
						<?php if( $varn_opt['shape_image6']['url'] != ''  ): ?>
							<?php if( $is_lazyloader == true ): ?>
								<img class="smartify" sm-src="<?php echo esc_url( $varn_opt['shape_image6']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php else: ?>
								<img src="<?php echo esc_url( $varn_opt['shape_image6']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php endif; ?>
						<?php else: ?>
							<?php if( $is_lazyloader == true ): ?>
								<img class="smartify" sm-src="<?php echo esc_url( VARN_IMG .'/shape/8.png' ); ?>" alt="<?php echo esc_attr__( ' Shape Image Four', 'varn' ); ?>">
							<?php else: ?>
								<img src="<?php echo esc_url( VARN_IMG .'/shape/8.png' ); ?>" alt="<?php echo esc_attr__( ' Shape Image Four', 'varn' ); ?>">
							<?php endif; ?>
						<?php endif; ?>
					</div>
					<div class="shape-img9">
						<?php if( $varn_opt['shape_image7']['url'] != ''  ): ?>
							<?php if( $is_lazyloader == true ): ?>
								<img class="smartify" sm-src="<?php echo esc_url( $varn_opt['shape_image7']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php else: ?>
								<img src="<?php echo esc_url( $varn_opt['shape_image7']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php endif; ?>
						<?php else: ?>
							<?php if( $is_lazyloader == true ): ?>
								<img class="smartify" sm-src="<?php echo esc_url( VARN_IMG .'/shape/9.png' ); ?>" alt="<?php echo esc_attr__( ' Shape Image Four', 'varn' ); ?>">
							<?php else: ?>
								<img src="<?php echo esc_url( VARN_IMG .'/shape/9.png' ); ?>" alt="<?php echo esc_attr__( ' Shape Image Four', 'varn' ); ?>">
							<?php endif; ?>
						<?php endif; ?>
					</div>
					<div class="shape-img10">
						<?php if( $varn_opt['shape_image8']['url'] != ''  ): ?>
							<?php if( $is_lazyloader == true ): ?>
								<img class="smartify" sm-src="<?php echo esc_url( $varn_opt['shape_image8']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php else: ?>
								<img src="<?php echo esc_url( $varn_opt['shape_image8']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image One', 'varn' ); ?>">
							<?php endif; ?>
						<?php else: ?>
							<?php if( $is_lazyloader == true ): ?>
								<img class="smartify" sm-src="<?php echo esc_url( VARN_IMG .'/shape/10.png' ); ?>" alt="<?php echo esc_attr__( ' Shape Image Four', 'varn' ); ?>">
							<?php else: ?>
								<img src="<?php echo esc_url( VARN_IMG .'/shape/10.png' ); ?>" alt="<?php echo esc_attr__( ' Shape Image Four', 'varn' ); ?>">
							<?php endif; ?>
						<?php endif; ?>
					</div>
				<?php 
				endif;
		endif;
	}
}

/**
 * Varn RTL
 */
if( ! function_exists( 'varn_rtl' ) ):
	function varn_rtl() {
		global $varn_opt;

		if(	isset( $varn_opt['varn_enable_rtl'])  ):
			$varn_rtl_opt = $varn_opt['varn_enable_rtl'];
		else:
			$varn_rtl_opt = 'disable';
		endif;

		if ( isset( $_GET['rtl'] ) ) {
			$varn_rtl_opt = $_GET['rtl'];
		}

		if( $varn_rtl_opt == 'enable' ):
			$varn_rtl = true;
		else:
			$varn_rtl = false;
		endif;
		
		return $varn_rtl;
	}
endif;

function varn_function_pcs() {
	$purchase_code = htmlspecialchars(get_option( 'varn_purchase_code' ));
	$purchase_code = str_replace(' ', '', $purchase_code);
	if( $purchase_code != '' ){
		require get_template_directory().'/inc/verify/class.verify-purchase.php';
		$o = EnvatoApi2::verifyPurchase( $purchase_code );

		if ( is_object($o) && strpos($o->item_name, 'Varn') !== false ) {

			// Check in localhost
			$whitelist = array(
				'127.0.0.1',
				'::1',
				'192.168.1',
				'192.168.0.1',
				'182.168.1.5',
				'192.168.1.4',
				'192.168.1.5',
				'192.168.1.4',
				'192.168',
				'10.0.2.2',
			);

			if(!in_array($_SERVER['REMOTE_ADDR'], $whitelist)){ // In server
				$url 			= 'https://api.envytheme.com/api/v1/license';
				$purchaseKey 	= $purchase_code;
				$itemName 		= $o->item_name;
				$buyer 			= $o->buyer;
				$purchasedAt 	= $o->created_at;
				$supportUntil 	= $o->supported_until;
				$licenseType 	= $o->licence;
				$domain 		= get_site_url();
				$post_url 		= '';

				$post_url .= $url.'?purchaseKey='.$purchaseKey.'&itemName='.$itemName.'&buyer='.$buyer.'&purchasedAt='.$purchasedAt.'&supportUntil='.$supportUntil.'&licenseType='.$licenseType.'&domain='.$domain.'';

				$post_url = str_replace(' ', '%', $post_url);

				$curl = curl_init();

				curl_setopt_array($curl, array(
					CURLOPT_URL 			=> $post_url,
					CURLOPT_RETURNTRANSFER 	=> true,
					CURLOPT_ENCODING 		=> "",
					CURLOPT_MAXREDIRS		=> 10,
					CURLOPT_TIMEOUT 		=> 30,
					CURLOPT_HTTP_VERSION 	=> CURL_HTTP_VERSION_1_1,
					CURLOPT_CUSTOMREQUEST 	=> "POST",
					CURLOPT_HTTPHEADER 		=> array(
						"cache-control: no-cache",
						"content-type: application/x-www-form-urlencoded"
					),
					CURLOPT_SSL_VERIFYPEER => false,
				));

				$response = curl_exec($curl);
				$err = curl_error($curl);
				curl_close($curl);

				if ($err) {
					echo "cURL Error #:" . $err;
				} else {
					$json = json_decode($response);
					$already_registered = $json->message[0]; // Already registered

					$new_response = '';
					$new_response .= 'Congratulations! Updated for this domain '.$domain.'';
					preg_match_all('#https?://[^,\s()<>]+(?:\([\w\d]+\)|([^,[:punct:]\s]|/))#', $already_registered, $match);
					$url 			= $match[0];
					$protocols 		= array('http://', 'http://www.', 'www.', 'https://', 'https://www.');
					$domain_name 	= str_replace( $protocols, '', $url[0] );	
					$site_url 		= str_replace( $protocols, '', get_site_url() );

					if( $already_registered != '' ){
						if( $already_registered == $new_response ):
							update_option('varn_purchase_code_status', 'valid', 'yes');
							update_option('varn_purchase_valid_code',  $purchase_code, 'yes');
							update_option('varn_valid_url',  $domain, 'yes');
							update_option('valid_url', get_site_url(), 'yes');
							?><script>let date = new Date(Date.now() + 604800);	date = date.toUTCString(); document.cookie = "ET_L_Status=<?php echo $purchase_code; ?>; expires=" + date; </script><?php
						elseif( $domain_name == $site_url ):
							/* Deregister  */
								$url 			= 'https://api.envytheme.com/api/v1/license';
								$purchaseKey 	= $purchase_code;
								$status 		= 'disabled';
								$post_url = '';
								$post_url .= $url.'?purchaseKey='.$purchaseKey.'&status='.$status.'';
								$post_url = str_replace(' ', '%', $post_url);
								$curl = curl_init();
								curl_setopt_array($curl, array(
									CURLOPT_URL 			=> $post_url,
									CURLOPT_RETURNTRANSFER 	=> true,
									CURLOPT_ENCODING 		=> "",
									CURLOPT_MAXREDIRS 		=> 10,
									CURLOPT_TIMEOUT 		=> 30,
									CURLOPT_HTTP_VERSION 	=> CURL_HTTP_VERSION_1_1,
									CURLOPT_CUSTOMREQUEST 	=> "PUT",
									CURLOPT_HTTPHEADER 		=> array(
										"cache-control: no-cache",
										"content-type: application/x-www-form-urlencoded"
									),
									CURLOPT_SSL_VERIFYPEER => false,
								));

								$response = curl_exec($curl);
								$err = curl_error($curl);
								curl_close($curl);
							/* Deregister */

							/* Register */
								$url 			= 'https://api.envytheme.com/api/v1/license';
								$purchaseKey 	= $purchase_code;
								$itemName 		= $o->item_name;
								$buyer 			= $o->buyer;
								$purchasedAt 	= $o->created_at;
								$supportUntil 	= $o->supported_until;
								$licenseType 	= $o->licence;
								$domain 		= get_site_url();
								$post_url 		= '';

								$post_url .= $url.'?purchaseKey='.$purchaseKey.'&itemName='.$itemName.'&buyer='.$buyer.'&purchasedAt='.$purchasedAt.'&supportUntil='.$supportUntil.'&licenseType='.$licenseType.'&domain='.$domain.'';
								
								$post_url = str_replace(' ', '%', $post_url);
							
								$curl = curl_init();

								curl_setopt_array($curl, array(
								CURLOPT_URL => $post_url,
								CURLOPT_RETURNTRANSFER => true,
								CURLOPT_ENCODING => "",
								CURLOPT_MAXREDIRS => 10,
								CURLOPT_TIMEOUT => 30,
								CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
								CURLOPT_CUSTOMREQUEST => "POST",
								CURLOPT_HTTPHEADER => array(
									"cache-control: no-cache",
									"content-type: application/x-www-form-urlencoded"
								),
								CURLOPT_SSL_VERIFYPEER => false,
								));

								$response = curl_exec($curl);
								$err = curl_error($curl);
								curl_close($curl);
							/* Register */

							update_option('varn_purchase_code_status', 'valid', 'yes');
							update_option('varn_purchase_valid_code',  $purchase_code, 'yes');
							update_option('varn_valid_url',  $domain, 'yes');
							update_option('valid_url', get_site_url(), 'yes');						
							?><script>let date = new Date(Date.now() + 604800);	date = date.toUTCString(); document.cookie = "ET_L_Status=<?php echo $purchase_code; ?>; expires=" + date; </script><?php
						else:
							$target_site 	= $url[0];
							$src 			= file_get_contents( $target_site );
							preg_match("/\<link rel='stylesheet' id='varn-style-css'.*href='(.*?style\.css.*?)'.*\>/i", $src, $matches );

							if( $matches ) { // if theme found
								update_option('varn_purchase_code_status', 'already_registered', 'yes');
								update_option('varn_already_registered', $already_registered, 'yes');
							}else{
								/* Deregister  */
									$url 			= 'https://api.envytheme.com/api/v1/license';
									$purchaseKey 	= $purchase_code;
									$status 		= 'disabled';
									$post_url = '';
									$post_url .= $url.'?purchaseKey='.$purchaseKey.'&status='.$status.'';
									$post_url = str_replace(' ', '%', $post_url);
									$curl = curl_init();
									curl_setopt_array($curl, array(
										CURLOPT_URL 			=> $post_url,
										CURLOPT_RETURNTRANSFER 	=> true,
										CURLOPT_ENCODING 		=> "",
										CURLOPT_MAXREDIRS 		=> 10,
										CURLOPT_TIMEOUT 		=> 30,
										CURLOPT_HTTP_VERSION 	=> CURL_HTTP_VERSION_1_1,
										CURLOPT_CUSTOMREQUEST 	=> "PUT",
										CURLOPT_HTTPHEADER 		=> array(
											"cache-control: no-cache",
											"content-type: application/x-www-form-urlencoded"
										),
										CURLOPT_SSL_VERIFYPEER => false,
									));

									$response = curl_exec($curl);
									$err = curl_error($curl);
									curl_close($curl);
								/* Deregister */

								/* Register */
									$url 			= 'https://api.envytheme.com/api/v1/license';
									$purchaseKey 	= $purchase_code;
									$itemName 		= $o->item_name;
									$buyer 			= $o->buyer;
									$purchasedAt 	= $o->created_at;
									$supportUntil 	= $o->supported_until;
									$licenseType 	= $o->licence;
									$domain 		= get_site_url();
									$post_url 		= '';

									$post_url .= $url.'?purchaseKey='.$purchaseKey.'&itemName='.$itemName.'&buyer='.$buyer.'&purchasedAt='.$purchasedAt.'&supportUntil='.$supportUntil.'&licenseType='.$licenseType.'&domain='.$domain.'';
									
									$post_url = str_replace(' ', '%', $post_url);
								
									$curl = curl_init();

									curl_setopt_array($curl, array(
									CURLOPT_URL => $post_url,
									CURLOPT_RETURNTRANSFER => true,
									CURLOPT_ENCODING => "",
									CURLOPT_MAXREDIRS => 10,
									CURLOPT_TIMEOUT => 30,
									CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
									CURLOPT_CUSTOMREQUEST => "POST",
									CURLOPT_HTTPHEADER => array(
										"cache-control: no-cache",
										"content-type: application/x-www-form-urlencoded"
									),
									CURLOPT_SSL_VERIFYPEER => false,
									));

									$response = curl_exec($curl);
									$err = curl_error($curl);
									curl_close($curl);
								/* Register */
							}
						endif;
					}else {
						update_option('varn_purchase_code_status', 'valid', 'yes');
						update_option('varn_purchase_valid_code',  $purchase_code, 'yes');
						update_option('varn_valid_url',  $domain, 'yes');
						update_option('valid_url', get_site_url(), 'yes');
						?><script>let date = new Date(Date.now() + 604800);	date = date.toUTCString(); document.cookie = "ET_L_Status=<?php echo $purchase_code; ?>; expires=" + date; </script><?php
					}

				}

			}else{ // In local
				$domain = get_site_url();
				update_option('varn_purchase_code_status', 'valid', 'yes');
				update_option('varn_purchase_valid_code',  $purchase_code, 'yes');
				update_option('varn_valid_url',  $domain, 'yes');
			}
		} elseif( $purchase_code == '' ){
			update_option( 'varn_purchase_code_status', '', 'yes' );
			update_option( 'varn_purchase_code', '', 'yes' );
		}
	}
}

add_action( 'admin_bar_menu', 'varn_header_options', 500 );
function varn_header_options ( WP_Admin_Bar $admin_bar ) {
    global $wp;
	$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

	if ( $actual_link == home_url('/wp-admin/admin.php?page=varn') ){
		return '';
	}else{
		$site_url 	= get_site_url();
		$valid_url 	= get_option( 'valid_url' );
		$purchase_code = get_option( 'varn_purchase_valid_code' );

		if( current_user_can('administrator') ) {
			if(!isset($_COOKIE['ET_L_Status'])) {
				varn_function_pcs();
			}elseif( $site_url !=  $valid_url) {
				varn_function_pcs();
			}else{
				?><script>let date = new Date(Date.now() - 604800);	date = date.toUTCString(); document.cookie = "ET_L_Status=<?php echo $purchase_code; ?>; expires=" + date; </script><?php
			}
		}
	}
}