<?php
/**
 * Register custom style.
 */

if ( ! function_exists( 'varn_custom_style' ) ) {
    function varn_custom_style(){
        
        $custom_style ='';
            global $varn_opt;

            if( isset( $varn_opt['primary_color'] ) ):
                $primary_color              = $varn_opt['primary_color'];
                $secondary_color            = $varn_opt['secondary_color'];
                $footer_bg                  = $varn_opt['footer_bg'];
                $nav_bg_color               = $varn_opt['nav_bg_color'];
                $nav_item_color             = $varn_opt['nav_item_color'];
                $mob_nav_item_color 	    = $varn_opt['mob_nav_item_color'];
                $hide_blog_banner           = $varn_opt['hide_blog_banner'];
            else:   
                $primary_color              = '#0000ff';
                $secondary_color            = '#fa7070';
                $footer_bg                  = '#212529';
                $nav_bg_color               = '#fff';
                $nav_item_color             = '#4a6f8a';
                $mob_nav_item_color         = '#677294';
                $hide_blog_banner           = false;
            endif;

            $custom_style .='
            .sidebar .widget_search form button, .sidebar .widget ul li::before, .sidebar .tagcloud a:hover, .post-tag-media ul li a:hover, .comments-area .comment-respond .form-submit input, .wp-block-button__link, .page-links .current, .page-links .post-page-numbers:hover, .post-password-form input[type="submit"], #comments .comment-list .comment-body .reply a:hover, .comment-navigation .nav-links .nav-previous a:hover, .comment-navigation .nav-links .nav-next a:hover, .default-btn, .sidebar-modal .sidebar-contact-area .contact-info .contact-info-content .social li a:hover, .main-banner-content form button, .banner-content form button, .hero-banner-content form button, .hero-main-banner-content form button, .single-featured-box:hover .default-btn, .about-content .features-list li span::before, .about-content .features-list li span i, .about-text h3::before, .about-text .features-list li:hover i, .single-services-box::before, .overview-box .overview-content .content .features-list li span::before, .overview-box .overview-content .content .features-list li span i, .single-fun-facts:hover, .single-projects-box .plus-icon a, .projects-slides.owl-theme .owl-dots .owl-dot:hover span, .projects-slides.owl-theme .owl-dots .owl-dot.active span, .project-details-image a, .features-list-tab .tabs li.current a, .features-list-tab .tabs li:hover a, .features-list-tab .features-overview .overview-content .content .features-list li span::before, .single-team-box:hover .content, .solution-area, .solution-video .video-btn:hover, .solution-video .video-btn:focus, .feedback-area.bg-color::before, .feedback-slides.owl-theme .owl-dots .owl-dot:hover span, .feedback-slides.owl-theme .owl-dots .owl-dot.active span, .single-pricing-box .pricing-header, .single-pricing-box .get-started-btn::before, .subscribe-inner-area, .subscribe-inner-area::after, .subscribe-content .newsletter-form button, .widget-area .widget_search form button, .widget-area .tagcloud a:hover, .widget-area .tagcloud a:focus, .contact-info-box:hover .icon, .go-top, .no-results form button, .features-list-tab .features-overview .overview-content .content .features-list li span i, .footer-area .widget_search form button, .blog-details .wp-block-search button, .blog-details .wp-block-tag-cloud a:hover, .it-banner .video-btn:hover i, .service-card-one.gray-bg:hover, .team-slider.owl-theme .owl-nav button.owl-prev:hover, .team-slider.owl-theme .owl-nav button.owl-next:hover, .seo-banner-slider.owl-theme .owl-nav button.owl-prev, .seo-banner-slider.owl-theme .owl-nav button.owl-next, .seo-banner .video-btn:hover i, .work-slider.owl-theme .owl-nav button.owl-prev:hover, .work-slider.owl-theme .owl-nav button.owl-next:hover, .default-btn-two span, .saas-banner-two .saas-banner-image .solution-video .video-btn, .service-card-one .icon .number, .machine-learning-slider.owl-theme .owl-nav .owl-prev:hover, .machine-learning-slider.owl-theme .owl-nav .owl-next:hover, .machine-learning-slider.owl-theme .owl-dots .owl-dot.active span, .machine-learning-slider.owl-theme .owl-dots .owl-dot:hover span, .featured-solution-card .read-more::after, .ml-service .read-more::after, .ml-service::before { background-color: '.esc_attr($primary_color).';}

            .preloader::before, .preloader::after, .single-featured-box .default-btn span, .single-services-box .read-more-btn::before, .services-details-overview .services-details-desc .services-details-accordion .accordion .accordion-title i, .fun-facts-area, .pagination-area .page-numbers.current, .pagination-area .page-numbers:hover, .pagination-area .page-numbers:focus, .widget-area .widget .widget-title::before, .widget-area .widget_recent_entries ul li::before, .widget-area .widget_recent_comments ul li::before, .widget-area .widget_archive ul li::before, .widget-area .widget_categories ul li::before, .widget-area .widget_meta ul li::before, .faq-accordion .accordion .accordion-title i, .faq-area .col-lg-6:nth-child(2) .faq-accordion .accordion .accordion-item:nth-child(2) .accordion-title i, .faq-area .col-lg-6:nth-child(2) .faq-accordion .accordion .accordion-item:nth-child(4) .accordion-title i, .faq-area .col-lg-6:nth-child(2) .faq-accordion .accordion .accordion-item:nth-child(6) .accordion-title i, .faq-area .col-lg-6:nth-child(2) .faq-accordion .accordion .accordion-item:nth-child(8) .accordion-title i, .single-blog-post .post-content .read-more-btn::before, .faq-area .col-lg-6:nth-child(2) .faq-accordion .accordion .accordion-item:nth-child(2) .accordion-title i, .faq-area .col-lg-6:nth-child(2) .faq-accordion .accordion .accordion-item:nth-child(4) .accordion-title i, .faq-area .col-lg-6:nth-child(2) .faq-accordion .accordion .accordion-item:nth-child(6) .accordion-title i, .faq-area .col-lg-6:nth-child(2) .faq-accordion .accordion .accordion-item:nth-child(8) .accordion-title i, .faq-area .elementor-col-50:nth-child(2) .faq-accordion .accordion .accordion-item:nth-child(2) .accordion-title i, .faq-area .elementor-col-50:nth-child(2) .faq-accordion .accordion .accordion-item:nth-child(4) .accordion-title i, .faq-area .elementor-col-50:nth-child(2) .faq-accordion .accordion .accordion-item:nth-child(6) .accordion-title i, .faq-area .elementor-col-50:nth-child(2) .faq-accordion .accordion .accordion-item:nth-child(8) .accordion-title i { background: '.esc_attr($primary_color).';}

            .is-style-outline .wp-block-button__link, a:hover, .section-title .sub-title, .aronix-nav .navbar .navbar-nav .nav-item a:hover, .aronix-nav .navbar .navbar-nav .nav-item a:focus, .aronix-nav .navbar .navbar-nav .nav-item a.active, .aronix-nav .navbar .navbar-nav .nav-item:hover a, .aronix-nav .navbar .navbar-nav .nav-item:focus a, .aronix-nav .navbar .navbar-nav .nav-item.active a, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li a:hover, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li a:focus, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li a.active, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li a:hover, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li a:focus, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li a.active, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li a:hover, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li a:focus, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li a.active, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a:hover, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a:focus, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a.active, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a:hover, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a:focus, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a.active, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a:hover, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a:focus, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a.active, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a:hover, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a:focus, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li a.active, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li.active a, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li.active a , .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li .dropdown-menu li.active a, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li .dropdown-menu li.active a, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li .dropdown-menu li.active a, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu li.active a, .aronix-nav .navbar .others-options .option-item .search-btn:hover, .aronix-nav .navbar .others-options .option-item .close-btn:hover, .search-overlay.search-popup .search-form .search-button:hover, .search-overlay.search-popup .search-form .search-button:focus, .sidebar-modal .sidebar-contact-area .contact-info .contact-info-content h2 a, .sidebar-modal .sidebar-contact-area .contact-info .contact-info-content h2 a:not(:first-child):hover,   .aronix-responsive-nav .aronix-responsive-menu.mean-container .mean-nav ul li a.active, .main-banner-content .sub-title, .banner-content .sub-title, .hero-banner-content .sub-title, .hero-main-banner-content .sub-title, .single-featured-box .default-btn, .about-content .sub-title, .single-services-box .read-more-btn, .single-services-box:hover .icon, .services-details-overview .services-details-desc .features-text h4 i, .why-choose-content .sub-title, .why-choose-content .features-text h4 i, .overview-box .overview-content .content .sub-title, .overview-box .overview-content .content .features-text h4 i, .projects-details-desc .project-details-info .single-info-box .social li a:hover, .features-list-tab .tabs li a i, .features-list-tab .features-overview .overview-content .content .sub-title, .single-team-box .image .social a, .single-team-box .content span, .solution-video .video-btn, .single-feedback-item .client-info span, .single-pricing-box .price-features-list li i, .single-pricing-box .get-started-btn, .page-title-content ul li, .widget-area .widget_recent_entries ul li a:hover, .widget-area .widget_recent_comments ul li a:hover, .widget-area .widget_archive ul li a:hover, .widget-area .widget_categories ul li a:hover, .widget-area .widget_meta ul li a:hover, .contact-info-box .icon, .contact-info-box .icon i, .contact-info-box p a:hover, .single-blog-post .post-content .post-meta ul li a, .single-blog-post .post-content .read-more-btn, .blog-details .blog-details-content ul li a, .projects-details-desc .features-text h4 i, .page-title-area .woocommerce-breadcrumb a:hover, .it-banner .video-btn i, .service-card-one .icon i, .it-overview .overview-content .content .features-list li span i, .work-card .content .work-btn, .single-pricing-table .pricing-features li i, .seo-banner .video-btn i, .choose-area-two .choose-text i, .fun-fact-card i, .navbar-area-two.is-sticky .aronix-nav .navbar .navbar-nav .nav-item a:hover, .navbar-area-two.is-sticky .aronix-nav .navbar .others-options .cart-items a:hover, .machine-learning-banner .solution-video .video-btn, .machine-learning-slider.owl-theme .owl-nav .owl-prev, .machine-learning-slider.owl-theme .owl-nav .owl-next, .featured-solution-card i, .featured-solution-card h3 a:hover, .featured-solution-card .read-more, .ml-service h3 a:hover, .ml-service .read-more, .free-trial-area .subscribe-content .sub-title { color: '.esc_attr($primary_color).'; }

            .blog-details .blog-meta ul li a:hover { color: '.esc_attr($primary_color).' !important; }
            .top-header { background-color: '.esc_attr($primary_color).' !important; }

            .sidebar .tagcloud a:hover, .post-tag-media ul li a:hover, .is-style-outline .wp-block-button__link, #comments .comment-list .comment-body .reply a:hover, .comment-navigation .nav-links .nav-previous a:hover, .comment-navigation .nav-links .nav-next a:hover { border-color: '.esc_attr($primary_color).'; } 

            .form-control:focus, .search-overlay.search-popup .search-form .search-input:focus, .sidebar-modal .sidebar-contact-area .contact-info .contact-info-content .social li a:hover, .widget-area .widget_search form .search-field:focus, .widget-area .tagcloud a:hover, .widget-area .tagcloud a:focus, .contact-info-box:hover .icon, .aronix-nav .navbar .navbar-nav .nav-item .dropdown-menu, .single-featured-box .default-btn, .saas-banner-two .saas-banner-image .solution-video .video-btn::after, .saas-banner-two .saas-banner-image .solution-video .video-btn::before { border-color: '.esc_attr($primary_color).'; } 

            .sidebar .widget_search form button:hover, .footer-area .single-footer-widget ul li::before, .footer-area .tagcloud a:hover, .comments-area .comment-respond .form-submit input:hover, .wp-block-button .wp-block-button__link:hover, .post-password-form input[type="submit"]:hover, .single-pricing-box.red .pricing-header, .single-pricing-box.red .get-started-btn::before, .services-details-overview .services-details-desc .services-details-accordion .accordion .accordion-item:nth-child(2) .accordion-title i, .services-details-overview .services-details-desc .services-details-accordion .accordion .accordion-item:nth-child(4) .accordion-title i, .services-details-overview .services-details-desc .services-details-accordion .accordion .accordion-item:nth-child(6) .accordion-title i, .services-details-overview .services-details-desc .services-details-accordion .accordion .accordion-item:nth-child(8) .accordion-title i, .faq-accordion .accordion .accordion-item:nth-child(2) .accordion-title i, .faq-accordion .accordion .accordion-item:nth-child(4) .accordion-title i, .faq-accordion .accordion .accordion-item:nth-child(6) .accordion-title i, .faq-accordion .accordion .accordion-item:nth-child(8) .accordion-title i, .banner-content form button:hover, .no-results form button:hover, .footer-area .widget_search form button:hover, .faq-area .col-lg-6:nth-child(2) .faq-accordion .accordion .accordion-title i, .faq-area .elementor-col-50:nth-child(2) .faq-accordion .accordion .accordion-title i, .lets-work .contact-btn .default-btn span, .default-btn-two, .machine-learning-banner .solution-video .video-btn:hover, .default-btn span, .subscribe-content .newsletter-form button:hover, .hero-main-banner-content form button:hover, .single-projects-box .plus-icon a:hover { background-color: '.esc_attr($secondary_color).'; }

            .footer-area .single-footer-widget ul li a:hover, .footer-area .calendar_wrap table #prev a, .footer-area .calendar_wrap table #next a, .single-featured-box .icon, .single-services-box .icon, .features-list-tab .tabs li a.bg-fa7070 i, .features-list-tab .features-overview .overview-content .content .features-list li span:hover i, .single-team-box .image .social a:hover, .solution-content .sub-title, .page-title-content ul li a:hover, .single-footer-widget .footer-contact-info li i, .single-footer-widget .footer-contact-info li a:hover, .single-footer-widget .footer-contact-info li .social li a:hover i, .single-footer-widget .footer-quick-links li a:hover, .copyright-area p a:hover, .single-pricing-box.red .get-started-btn, .navbar-area-two .aronix-nav .navbar .navbar-nav .nav-item a:hover { color: '.esc_attr($secondary_color).'; }

            .widget_rss ul li a:hover { color: '.esc_attr($secondary_color).' !important; }

            .post-password-form input[type="submit"]:hover, .faq-accordion .accordion .accordion-content, .video-box .video-btn::after, .video-box .video-btn::before, .footer-area .tagcloud a:hover { border-color: '.esc_attr($secondary_color).'; }

            .single-products .sale-btn, .single-products .products-image ul li a:hover, .productsQuickView .modal-dialog .modal-content .products-content form button, .productsQuickView .modal-dialog .modal-content button.close:hover, .productsQuickView .modal-dialog .modal-content button.close:hover, .woocommerce ul.products li.product:hover .add-to-cart-btn, .shop-sidebar .widget_product_search form button, .shop-sidebar a.button, .shop-sidebar .woocommerce-widget-layered-nav-dropdown__submit, .shop-sidebar .woocommerce button.button, .woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .products_details div.product .woocommerce-tabs .panel #respond input#submit, .products_details div.product .product_title::before, .woocommerce #respond input#submit.alt.disabled, .woocommerce #respond input#submit.alt.disabled:hover, .woocommerce #respond input#submit.alt:disabled, .woocommerce #respond input#submit.alt:disabled:hover, .woocommerce #respond input#submit.alt:disabled[disabled], .woocommerce #respond input#submit.alt:disabled[disabled]:hover, .woocommerce a.button.alt.disabled, .woocommerce a.button.alt.disabled:hover, .woocommerce a.button.alt:disabled, .woocommerce a.button.alt:disabled:hover, .woocommerce a.button.alt:disabled[disabled], .woocommerce a.button.alt:disabled[disabled]:hover, .woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .woocommerce button.button.alt:disabled, .woocommerce button.button.alt:disabled:hover, .woocommerce button.button.alt:disabled[disabled], .woocommerce button.button.alt:disabled[disabled]:hover, .woocommerce input.button.alt.disabled, .woocommerce input.button.alt.disabled:hover, .woocommerce input.button.alt:disabled, .woocommerce input.button.alt:disabled:hover, .woocommerce input.button.alt:disabled[disabled], .woocommerce input.button.alt:disabled[disabled]:hover, .btn-primary:hover, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce .woocommerce-MyAccount-navigation ul .is-active a, .woocommerce .woocommerce-MyAccount-navigation ul li a:hover, .products_details div.product span.sale-btn { background-color: '.esc_attr($primary_color).'; }

            .btn-primary, .btn-primary.disabled, .btn-primary:disabled { background-color: '.esc_attr($secondary_color).'; }

            .productsQuickView .modal-dialog .modal-content .products-content .product-meta span a:hover, .woocommerce ul.products li.product h3 a:hover, .woocommerce ul.products li.product .add-to-cart-btn, .woocommerce div.product .woocommerce-tabs ul.tabs li.active a, .products_details div.product .woocommerce-tabs ul.tabs li a:hover, .products_details div.product .woocommerce-tabs ul.tabs li.active, .products_details div.product .woocommerce-tabs ul.tabs li.active a:hover, .products_details div.product .product_meta span.posted_in a:hover, .products_details div.product .product_meta span.tagged_as a:hover, .products_details div.product span.price, .cart-table table tbody tr td.product-name a, .woocommerce-message::before, .woocommerce-info::before { color: '.esc_attr ($primary_color).'; }

            .woocommerce-info, .woocommerce-message { border-top-color: '.esc_attr ($primary_color).'; }

            .shop-sidebar .widget_shopping_cart .cart_list li a:hover, .shop-sidebar ul li a:hover { color: '.esc_attr ($primary_color).' !important; }
            
            .woocommerce ul.products li.product:hover .add-to-cart-btn, .form-control:focus, .woocommerce .form-control:focus { border-color: '.esc_attr ($primary_color).'; } 

            .navbar-area.navbar-style-two, .navbar-area.is-sticky { background: '.esc_attr( $nav_bg_color ).' !important; }

            .aronix-nav .navbar .navbar-nav .nav-item a { color: '.esc_attr( $nav_item_color  ).'; }

            .mean-container .mean-nav ul li a { color: '.esc_attr( $mob_nav_item_color  ).'; }

            .team-slider .single-team-box:hover .content {
                border-bottom: 1px solid '.esc_attr ($primary_color).';
                border-left: 1px solid '.esc_attr ($primary_color).';
                border-right: 1px solid '.esc_attr ($primary_color).';
            }
            
            .footer-area, .blank-footer {
                background-color: '.esc_attr( $footer_bg ).'; 
            }
            .hide-adminbar {
                margin-top: 30px;
            }  ';
           
            // Hide Sticky Header
            if(isset($varn_opt['enable_sticky_header']) && $varn_opt['enable_sticky_header'] == false){ $custom_style .='
                .navbar-area.is-sticky{
                    display:none !important;
                }';
            }

            // Blog hide banner
            if( $hide_blog_banner == true ):
                $custom_style .='
                .blog-area.ptb-100, .blog-details-area.ptb-100 {
                    padding-top: 130px;
                }
                @media only screen and (max-width: 767px) {
                    .blog-area.ptb-100, .blog-details-area.ptb-100 {
                        padding-top: 70px;
                    }
                }';
            endif;

            // Hide 404 Page Header And Footer
            if( is_404() ): $custom_style .='
            .navbar-area, .footer-area, .top-header {display: none;}';
            endif;

            // Custom Css
            if( isset($varn_opt['css_code'] ) && !empty($varn_opt['css_code']) ):
                $custom_style .= $varn_opt['css_code'];
            endif;

            if( is_user_logged_in() ){ 
                $custom_style .=' .comments-area .comment-respond .form-submit {
                    margin-top: 20px;
                }';
            }

            // Image Animation
            if( isset($varn_opt['hide_animation'] ) && !empty($varn_opt['hide_animation']) ):
                if($varn_opt['hide_animation'] == 'hide'):
                    $custom_style .='
                    .cloud-shape, .cloud-icon1, .cloud-icon2, .cloud-icon3, .shape-img1, .shape-img2, .shape-img, .shape-img3, .shape-img4, .shape-img5, .shape-img6, .shape-img7, .shape-img8, .shape-img9, .shape-img10, .saas-banner-two .saas-banner-image.animate-tb {animation:none}                    
                    ';
                endif;
            endif;

            // Pre-loader image
            $is_preloader       = !empty($varn_opt['enable_preloader']) ? $varn_opt['enable_preloader'] : '';
            $preloader_image = isset( $varn_opt['preloader_image']['url'] ) ? $varn_opt['preloader_image']['url'] : VARN_IMG .'/status.gif';
            $preloader_style = !empty( $varn_opt['preloader_style'] ) ? $varn_opt['preloader_style'] : 'text';
            if ( $preloader_style == 'image' && $is_preloader == '1' ) {
                $custom_style .= "
                .preloader:after,  .preloader:before {
                    display: none;
                }
                .preloader {
                    background: #fff;
                }
                .preloader-img {
                    background-image: url(" . esc_url( $preloader_image ) . ");
                    background-repeat: no-repeat;
                    background-position: center;
                }";
            }
            
            wp_add_inline_style('varn-main-style', $custom_style);

            // Custom Js
            $custom_script ='';
            if( isset($varn_opt['js_code'] )){
                $custom_script .= $varn_opt['js_code'];
            }
            
            wp_add_inline_script( 'varn-main', $custom_script );
    }
}
add_action( 'wp_enqueue_scripts', 'varn_custom_style' );