<?php
/**
 * ACF 
 */

if( function_exists('acf_add_local_field_group') ):

    acf_add_local_field_group(array(
        'key' => 'group_5e0c6851b0a0b',
        'title' => 'Page Option',
        'fields' => array(
            array(
                'key' => 'field_5e5797be82ee3',
                'label' => esc_html__('Choose Navigation Style', 'varn'),
                'name' => 'choose_navigation_style',
                'type' => 'radio',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'choices' => array(
                    1 => 'Style One',
                    2 => 'Style Two',
                ),
                'allow_null' => 0,
                'other_choice' => 0,
                'default_value' => '',
                'layout' => 'vertical',
                'return_format' => 'value',
                'save_other_choice' => 0,
            ),
            array(
                'key' => 'field_5e0c685e71de2',
                'label' => esc_html__('Hide Page Banner', 'varn'),
                'name' => 'enable_page_banner',
                'type' => 'true_false',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'message' => '',
                'default_value' => 0,
                'ui' => 0,
                'ui_on_text' => '',
                'ui_off_text' => '',
            ),
            array(
                'key' => 'field_5e0c689071de3',
                'label' => esc_html__('Hide Breadcrumb', 'varn'),
                'name' => 'hide_breadcrumb',
                'type' => 'true_false',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => array(
                    array(
                        array(
                            'field' => 'field_5e0c685e71de2',
                            'operator' => '!=',
                            'value' => '1',
                        ),
                    ),
                ),
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'message' => '',
                'default_value' => 0,
                'ui' => 0,
                'ui_on_text' => '',
                'ui_off_text' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'page_template',
                    'operator' => '==',
                    'value' => 'default',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'side',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));
    
    acf_add_local_field_group(array(
        'key' => 'group_5e19962314d2d',
        'title' => 'Projects Meta',
        'fields' => array(
            array(
                'key' => 'field_5ea00bee5bef8',
                'label' => esc_html__('Project Style', 'varn'),
                'name' => 'project_style',
                'type' => 'select',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'choices' => array(
                    1 => 'Style One',
                    2 => 'Style Two',
                ),
                'default_value' => array(
                ),
                'allow_null' => 0,
                'multiple' => 0,
                'ui' => 0,
                'return_format' => 'value',
                'ajax' => 0,
                'placeholder' => '',
            ),
            array(
                'key' => 'field_5e19963c5cb16',
                'label' => esc_html__('Images', 'varn'),
                'name' => 'projects_images',
                'type' => 'repeater',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'collapsed' => '',
                'min' => 0,
                'max' => 0,
                'layout' => 'table',
                'button_label' => '',
                'sub_fields' => array(
                    array(
                        'key' => 'field_5e1996665cb17',
                        'label' => esc_html__('Image', 'varn'),
                        'name' => 'image',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'url',
                        'preview_size' => 'medium',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                    ),
                    array(
                        'key' => 'field_5e1996755cb18',
                        'label' => esc_html__('Image Link', 'varn'),
                        'name' => 'select_option',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'video_link' =>  esc_html__('Video Link', 'varn'),
                            'default_link' =>  esc_html__('Default Link', 'varn'),
                            'none' => 'None',
                        ),
                        'default_value' => array(
                            0 => 'image_link',
                        ),
                        'allow_null' => 0,
                        'multiple' => 0,
                        'ui' => 0,
                        'return_format' => 'value',
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_5e1996d35cb19',
                        'label' => esc_html__('Video Link', 'varn'),
                        'name' => 'video_link',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_5e1996755cb18',
                                    'operator' => '==contains',
                                    'value' => 'video_link',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 'https://www.youtube.com/watch?v=bk7McNUjWgw',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                        'maxlength' => '',
                    ),
                ),
            ),
            array(
                'key' => 'field_5e19984a08d8a',
                'label' => esc_html__('Client Name Label', 'varn'),
                'name' => 'client_name_label',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => 'Client Name',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),
            array(
                'key' => 'field_5e19989f08d8b',
                'label' => esc_html__('Client Name', 'varn'),
                'name' => 'client_name',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => 'John Doe',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),
            array(
                'key' => 'field_5e1998aa08d8c',
                'label' => esc_html__('Category Label', 'varn'),
                'name' => 'category_label',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => 'Category',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),
            array(
                'key' => 'field_5e1998c208d8d',
                'label' => esc_html__('Project Completed Date Label', 'varn'),
                'name' => 'project_completed_date_label',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => 'Date',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),
            array(
                'key' => 'field_5e1998d608d8e',
                'label' => esc_html__('Project Completed Date', 'varn'),
                'name' => 'project_completed_date',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => 'February 28, 2022',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),
            array(
                'key' => 'field_5e1998ef08d8f',
                'label' => esc_html__('Location Label', 'varn'),
                'name' => 'location_label',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => 'Location',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),
            array(
                'key' => 'field_5e1998fa08d90',
                'label' => esc_html__('Location', 'varn'),
                'name' => 'location',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => '3690 Brownton Road, Mississippi',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),
            array(
                'key' => 'field_5e19990908d91',
                'label' => esc_html__('Live Preview Button Text', 'varn'),
                'name' => 'live_preview_button_text',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => 'Live Preview',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),
            array(
                'key' => 'field_5e19991408d92',
                'label' => esc_html__('Live Preview Link', 'varn'),
                'name' => 'live_preview_link',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => '#',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'project',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'left',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));
    
    acf_add_local_field_group(array(
        'key' => 'group_5e0c8c6603108',
        'title' => 'Services Meta',
        'fields' => array(

            array(
                'key' => 'field_5f16820ed4740',
                'label' => 'Choose Icon Type',
                'name' => 'choose_icon_type',
                'type' => 'select',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'choices' => array(
                    'flaticon'  => 'Flat Icon',
                    'iconclass' => 'Font Awesome',
                    'boxclass'  => 'Box Icon Text',
                ),
                'default_value' => false,
                'allow_null' => 0,
                'multiple' => 0,
                'ui' => 0,
                'return_format' => 'value',
                'ajax' => 0,
                'placeholder' => '',
            ),

            array(
                'key' => 'field_5e9ee053e596c',
                'label' => 'Service Icon for Style 3',
                'name' => 'service_icon_3',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => array(
                    array(
                        array(
                            'field' => 'field_5f16820ed4740',
                            'operator' => '==',
                            'value' => 'boxclass',
                        ),
                    ),
                ),
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'default_value' => '',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),

            array(
                'key' => 'field_5e0c8c7eecd4c',
                'label' => esc_html__('Services Icon', 'varn'),
                'name' => 'service_icon',
                'type' => 'select',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => array(
                    array(
                        array(
                            'field' => 'field_5f16820ed4740',
                            'operator' => '==',
                            'value' => 'flaticon',
                        ),
                    ),
                ),
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'choices' => array(
                    'flaticon-research'          => esc_html__( 'Research', 'varn'),
                    'flaticon-analytics'         => esc_html__( 'Analytics', 'varn'),
                    'flaticon-mail'              => esc_html__( 'Mail', 'varn'),
                    'flaticon-digital-marketing' => esc_html__( 'Digital-marketing', 'varn'),
                    'flaticon-analysis'          => esc_html__( 'Analysis', 'varn'),
                    'flaticon-seo'               => esc_html__( 'Seo', 'varn'),
                    'flaticon-right-arrow'       => esc_html__( 'Right-arrow', 'varn'),
                    'flaticon-tick'              => esc_html__( 'Tick', 'varn'),
                    'flaticon-achievement'       => esc_html__( 'Achievement', 'varn'),
                    'flaticon-architecture'      => esc_html__( 'Architecture', 'varn'),
                    'flaticon-data'              => esc_html__( 'Data', 'varn'),
                    'flaticon-play-button'       => esc_html__( 'Play-button', 'varn'),
                    'flaticon-copyright'         => esc_html__( 'Copyright', 'varn'),
                    'flaticon-phone-call'        => esc_html__( 'Phone-call', 'varn'),
                    'flaticon-email'             => esc_html__( 'Email', 'varn'),
                    'flaticon-social-media'      => esc_html__( 'Social-media', 'varn'),
                    'flaticon-close'             => esc_html__( 'Close', 'varn'),
                    'flaticon-marker'            => esc_html__( 'Marker', 'varn'),
                    'flaticon-shopping-cart'     => esc_html__( 'Shopping-cart', 'varn'),
                    'flaticon-search'            => esc_html__( 'Search', 'varn'),
                    'flaticon-left-chevron'      => esc_html__( 'Left-chevron', 'varn'),
                    'flaticon-right-chevron'     => esc_html__( 'Right-chevron', 'varn'),
                ),
                'default_value' => array(
                ),
                'allow_null' => 0,
                'multiple' => 0,
                'ui' => 0,
                'return_format' => 'value',
                'ajax' => 0,
                'placeholder' => '',
            ),
            array(
                'key' => 'field_5f1682acd4742',
                'label' => esc_html__('Choose Fontawesome', 'varn'),
                'name' => 'choose_fontawesome',
                'type' => 'font-awesome',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => array(
                    array(
                        array(
                            'field' => 'field_5f16820ed4740',
                            'operator' => '==',
                            'value' => 'iconclass',
                        ),
                    ),
                ),
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'icon_sets' => array(
                    0 => 'fab',
                ),
                'custom_icon_set' => '',
                'default_label' => '',
                'default_value' => '',
                'save_format' => 'element',
                'allow_null' => 0,
                'show_preview' => 1,
                'enqueue_fa' => 0,
                'fa_live_preview' => '',
                'choices' => array(
                ),
            ),
            array(
                'key' => 'field_5e0c8caaecd4d',
                'label' => esc_html__('Service Icon Color', 'varn'),
                'name' => 'service_icon_color',
                'type' => 'color_picker',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => '#fa7070',
            ),
            array(
                'key' => 'field_5e0c8cd5ecd4e',
                'label' => esc_html__('Service Icon Background Color', 'varn'),
                'name' => 'service_icon_background_color',
                'type' => 'color_picker',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => '#fef0f0',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'services',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'left',
        'instruction_placement' => 'field',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));

    acf_add_local_field_group(array(
        'key' => 'group_5e89b10a134f4',
        'title' => esc_html__('Single Product', 'varn'),
        'fields' => array(
            array(
                'key' => 'field_5e89b11b50ccf',
                'label' => esc_html__('Banner Background Image', 'varn'),
                'name' => 'product_banner_background_image',
                'type' => 'image',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'return_format' => 'url',
                'preview_size' => 'medium',
                'library' => 'all',
                'min_width' => '',
                'min_height' => '',
                'min_size' => '',
                'max_width' => '',
                'max_height' => '',
                'max_size' => '',
                'mime_types' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'product',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'side',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));

    acf_add_local_field_group(array(
        'key' => 'group_5e89b10ass134f4',
        'title' => esc_html__('Single Post', 'varn'),
        'fields' => array(
            array(
                'key' => 'field_5e89b1ss1b50ccf',
                'label' => esc_html__('Banner Background Image', 'varn'),
                'name' => 'post_banner_background_image',
                'type' => 'image',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'return_format' => 'url',
                'preview_size' => 'medium',
                'library' => 'all',
                'min_width' => '',
                'min_height' => '',
                'min_size' => '',
                'max_width' => '',
                'max_height' => '',
                'max_size' => '',
                'mime_types' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'post',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'side',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));

    acf_add_local_field_group(array(
        'key' => 'group_5e89dsb10ass134f4',
        'title' => esc_html__('Single Service', 'varn'),
        'fields' => array(
            array(
                'key' => 'field_5e89b1ss1b50csscf',
                'label' => esc_html__('Banner Background Image', 'varn'),
                'name' => 'service_banner_background_image',
                'type' => 'image',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'return_format' => 'url',
                'preview_size' => 'medium',
                'library' => 'all',
                'min_width' => '',
                'min_height' => '',
                'min_size' => '',
                'max_width' => '',
                'max_height' => '',
                'max_size' => '',
                'mime_types' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'services',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'side',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));

    acf_add_local_field_group(array(
        'key' => 'group_5e89dsb10ass134fg44',
        'title' => esc_html__('Single Project', 'varn'),
        'fields' => array(
            array(
                'key' => 'field_5e89b1ss1bs50cssc4',
                'label' => esc_html__('Banner Background Image', 'varn'),
                'name' => 'project_banner_background_image',
                'type' => 'image',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'return_format' => 'url',
                'preview_size' => 'medium',
                'library' => 'all',
                'min_width' => '',
                'min_height' => '',
                'min_size' => '',
                'max_width' => '',
                'max_height' => '',
                'max_size' => '',
                'mime_types' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'project',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'side',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));

    acf_add_local_field_group(array(
        'key' => 'group_5ea463adda67f',
        'title' => esc_html__('Post Meta Info', 'varn'),
        'fields' => array(
            array(
                'key' => 'field_5ea463bb57214',
                'label' => esc_html__('Choose Post Style', 'varn'),
                'name' => 'choose_style_type',
                'type' => 'select',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'choices' => array(
                    1 => 'Style One',
                    2 => 'Style Two',
                ),
                'default_value' => array(
                ),
                'allow_null' => 0,
                'multiple' => 0,
                'ui' => 0,
                'return_format' => 'value',
                'ajax' => 0,
                'placeholder' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'post',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'side',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));

    acf_add_local_field_group(array(
        'key' => 'group_5ee06d3c580d8',
        'title' => esc_html__('Custom Posts Custom Link', 'varn'),
        'fields' => array(
            array(
                'key' => 'field_5ee06e1c55813',
                'label' => esc_html__('Choose Link Type', 'varn'),
                'name' => 'choose_link_type',
                'type' => 'select',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'choices' => array(
                    1 => 'Post Details Page',
                    2 => 'External Link',
                ),
                'default_value' => array(
                ),
                'allow_null' => 0,
                'multiple' => 0,
                'ui' => 0,
                'return_format' => 'value',
                'ajax' => 0,
                'placeholder' => '',
            ),
            array(
                'key' => 'field_5ee06ec78bf72',
                'label' => esc_html__('External Link', 'varn'),
                'name' => 'external_link',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => array(
                    array(
                        array(
                            'field' => 'field_5ee06e1c55813',
                            'operator' => '==',
                            'value' => '2',
                        ),
                    ),
                ),
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => '',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'project',
                ),
            ),
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'services',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));
endif;