<?php
/**
 * Varn functions and definitions
 * @package Varn
 */


/**
 * Shorthand contents for theme assets url
 */
define('VARN_VERSION', time());
define('VARN_THEME_URI', get_template_directory_uri());
define('VARN_THEME_DIR', get_template_directory());
define('VARN_IMG',VARN_THEME_URI . '/assets/img');
define('VARN_CSS',VARN_THEME_URI . '/assets/css');
define('VARN_JS',VARN_THEME_URI . '/assets/js');
if( !defined('VARN_FRAMEWORK_VAR') ) define('VARN_FRAMEWORK_VAR', 'varn_opt');

/**
 * Sets up theme defaults and registers support for various WordPress features.
 */
if ( ! function_exists( 'varn_setup' ) ) :

	function varn_setup() {

		// Make theme available for translation.
		load_theme_textdomain( 'varn', VARN_THEME_DIR. '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		// Let WordPress manage the document title.
		add_theme_support( 'title-tag' );

		// Enable support for Post Thumbnails on posts and pages.
		add_theme_support( 'post-thumbnails' );

		add_theme_support( 'yoast-seo-breadcrumbs' );

		// Varn blog post image size for EL
		add_image_size( 'varn_el_post_thumb', 530, 430, true );
		add_image_size( 'varn_project_slider', 800, 800, true );
		add_image_size( 'varn_post_thumb', 730, 400, true );
		add_image_size( 'varn_product_card_thumb', 450, 450, true ); 

		// WooCommerce support
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );

		// Switch default core markup for search form, comment form, and comments
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );
	}
endif;
add_action( 'after_setup_theme', 'varn_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 */
function varn_content_width() {
	// This variable is intended to be overruled from themes.
	$GLOBALS['content_width'] = apply_filters( 'varn_content_width', 640 );
}
add_action( 'after_setup_theme', 'varn_content_width', 0 );

/**
 * Enqueue scripts and styles.
 */
if ( ! function_exists( 'varn_scripts' ) ) :

	function varn_scripts() {		
		global $varn_opt;

		if( isset( $varn_opt['enable_lazyloader'] ) ):
			$is_lazyloader = $varn_opt['enable_lazyloader'];
		else:
			$is_lazyloader = true;
		endif;

		if( isset( $varn_opt['enable_minify_css_js'] ) ):
			$is_minify = $varn_opt['enable_minify_css_js'];
		else:
			$is_minify = true;
		endif;

		wp_enqueue_style( 'varn-style', get_stylesheet_uri() );
		wp_style_add_data( 'varn-style', 'rtl', 'replace' );

		wp_enqueue_style( 'vendors', 			VARN_CSS . '/vendors.min.css', null, VARN_VERSION );
		wp_enqueue_style( 'flaticon', 			VARN_CSS . '/flaticon.css', null, VARN_VERSION );
		wp_enqueue_style( 'all', 				VARN_CSS . '/all.min.css', null, VARN_VERSION );

		// WooCommerce support style
		if ( class_exists( 'WooCommerce' ) ):
			if( $is_minify == true ):
				wp_enqueue_style( 'varn-woocommerce',	VARN_CSS . '/woocommerce.min.css', null, VARN_VERSION );
			else :
				wp_enqueue_style( 'varn-woocommerce',	VARN_CSS . '/woocommerce.css', null, VARN_VERSION );
			endif;
		endif;

		if( $is_minify == true ):
			wp_enqueue_style( 'varn-main-style', 	VARN_CSS . '/style.min.css', null, VARN_VERSION );
			wp_enqueue_style( 'varn-responsive', 	VARN_CSS . '/responsive.min.css', null, VARN_VERSION );
		else :
			wp_enqueue_style( 'varn-main-style', 	VARN_CSS . '/style.css', null, VARN_VERSION );
			wp_enqueue_style( 'varn-responsive', 	VARN_CSS . '/responsive.css', null, VARN_VERSION );
		endif;

		// RTL support CSS 
		if( varn_rtl() == true ):
			wp_enqueue_style( 'varn-rtl', VARN_THEME_URI . '/style-rtl.css' );
		endif;

		wp_enqueue_script( 'vendors', get_template_directory_uri() . '/assets/js/vendors.min.js', array ( 'jquery' ), true);
		wp_enqueue_script( 'ajaxchimp', get_template_directory_uri() . '/assets/js/ajaxChimp.min.js', array ( 'jquery' ), true);

		// Smartify JS 
		if( $is_lazyloader == true ):
			wp_enqueue_script( 'jquery-smartify', VARN_JS . '/jquery.smartify.js', array('jquery'), VARN_VERSION );
			wp_enqueue_script( 'varn-smartify', VARN_JS . '/smartify.js', array('jquery'), VARN_VERSION );
		endif;

		if( $is_minify == true ):
			wp_enqueue_script( 'varn-main', 			VARN_JS . '/main.min.js', array('jquery'), VARN_VERSION );
		else :
			wp_enqueue_script( 'varn-main', 			VARN_JS . '/main.js', array('jquery'), VARN_VERSION );
		endif;
		
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}
	
endif;
add_action( 'wp_enqueue_scripts', 'varn_scripts' );

if ( ! function_exists( 'varn_fonts' ) ) {
	function varn_fonts() {
		wp_enqueue_style( 'varn-fonts', "//fonts.googleapis.com/css?family=Overpass:300,400,500,600,700,700i,800,900&display=swap", '', '1.0.0', 'screen' );
	}
}
add_action( 'wp_enqueue_scripts', 'varn_fonts' );

/**
 * Custom template tags for this theme.
 */
require VARN_THEME_DIR. '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require VARN_THEME_DIR. '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require VARN_THEME_DIR. '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require VARN_THEME_DIR. '/inc/jetpack.php';
}

/**
 * Load bootstrap navwalker 
 */
require VARN_THEME_DIR. '/inc/bootstrap-navwalker.php';

/**
 * Load theme widgets
 */
require VARN_THEME_DIR. '/inc/widget.php';

/**
 * Custom style
 */
require VARN_THEME_DIR. '/inc/custom-style.php';

/**
 * Social link
*/
require VARN_THEME_DIR. '/inc/social-link.php';

/**
 * Header Style
*/
require VARN_THEME_DIR. '/template-parts/header/style-1.php';
require VARN_THEME_DIR. '/template-parts/header/style-2.php';

/**
 * Theme Demo
 */
$pcs = trim( get_option( 'varn_purchase_code_status' ) );
if ( $pcs == 'valid' ) :
    require get_template_directory() . '/inc/theme-demos.php';
endif;

/**
 * Recommended plugin
*/
require VARN_THEME_DIR. '/lib/recommended-plugin.php';

/**
 * ACF meta filed
*/
require VARN_THEME_DIR. '/inc/acf.php';

// Load WooCommerce compatibility file.
if ( class_exists( 'WooCommerce' ) ):
	require VARN_THEME_DIR . '/inc/woocommerce.php';
endif;

/**
 * Filter the categories archive widget to add a span around post count
 */
if ( ! function_exists( 'varn_cat_count_span' ) ) {
	function varn_cat_count_span( $links ) {
		$links = str_replace( '</a> (', '</a><span class="post-count">(', $links );
		$links = str_replace( ')', ')</span>', $links );
		return $links;
	}
}
add_filter( 'wp_list_categories', 'varn_cat_count_span' );

/**
 * Filter the archives widget to add a span around post count
 */
if ( ! function_exists( 'varn_archive_count_span' ) ) {
	function varn_archive_count_span( $links ) {
		$links = str_replace( '</a>&nbsp;(', '</a><span class="post-count">(', $links );
		$links = str_replace( ')', ')</span>', $links );
		return $links;
	}
}
add_filter( 'get_archives_link', 'varn_archive_count_span' );

/**
 * Excerpt more text
 */
if ( ! function_exists( 'varn_excerpt_more' ) ) :
	function varn_excerpt_more( $more ) {
		return ' ';
	}
endif;
add_filter('excerpt_more', 'varn_excerpt_more');

/**
 * Remove pages from search result
 */
if ( ! function_exists( 'varn_remove_pages_from_search' ) ) :
    function varn_remove_pages_from_search() {
		global $varn_opt;
		global $wp_post_types;

		if( isset( $varn_opt['varn_search_page'] ) ):
			if( $varn_opt['varn_search_page'] != true ):
				$wp_post_types['page']->exclude_from_search = true;
			else:
				$wp_post_types['page']->exclude_from_search = false;
			endif;
		else:
			$wp_post_types['page']->exclude_from_search = false;
		endif;
	}
endif;
add_action('init', 'varn_remove_pages_from_search');

/**
 * If page edited by elementor
 */
if ( ! function_exists( 'varn_is_elementor' ) ) :
	function varn_is_elementor(){
		if ( function_exists( 'elementor_load_plugin_textdomain' ) ):
			global $post;
			return \Elementor\Plugin::$instance->db->is_built_with_elementor($post->ID);
		endif;
	}
endif;

/**
 * If page edited by elementor
 */
if ( ! function_exists( 'varn_register_primary_menus' ) ) :
	function varn_register_primary_menus(){
		register_nav_menus(
			array(
				'primary' 		=> esc_html__('Primary Menu', 'varn'),
				'footer-menu' 	=> esc_html__( 'Footer Menu', 'varn' ),
			
			)
		);
	}
endif;
add_action('init', 'varn_register_primary_menus');

/**
 * Classes
 */
require get_template_directory() . '/inc/classes/Varn_base.php';
require get_template_directory() . '/inc/classes/Varn_rt.php';
require get_template_directory() . '/inc/classes/Varn_admin_page.php';
require get_template_directory() . '/inc/admin/dashboard/Varn_admin_dashboard.php';

/**
 * Admin dashboard style and scripts
 */
add_action( 'admin_enqueue_scripts', function() {
    global $pagenow;
    wp_enqueue_script( 'varn-admin', VARN_JS .'/varn-admin.js', array('jquery'), '1.0.0', true );
    if ( $pagenow == 'admin.php' ) {
		wp_enqueue_style( 'varn-admin-dashboard', VARN_CSS .'/admin-dashboard.min.css' );
    }
});

/**
 * Redirect after theme activation
 */
add_action( 'after_switch_theme', function() {
    if ( isset( $_GET['activated'] ) ) {
		wp_safe_redirect( admin_url('admin.php?page=varn') );
		update_option( 'varn_purchase_code_status', '', 'yes' );
		update_option( 'varn_purchase_code', '', 'yes' );
        exit;
	}
	update_option('notice_dismissed', '0');
});

/**
 * Notice dismiss handle
 */
add_action( 'admin_init', function() {
    if ( isset($_GET['dismissed']) && $_GET['dismissed'] == 1 ) {
        update_option('notice_dismissed', '1');
    }
});