<?php
/**
 * The template for displaying the footer
 * @package Varn
 */

	/**
	 * Footer optional data
	 */
	global $varn_opt;
	if( isset( $varn_opt['copyright_text'] )):
		$copyright_text 		= $varn_opt['copyright_text'];
		$enable_back_to_top 	= $varn_opt['enable_back_to_top'];
	else:
		$copyright_text 		= '';
		$enable_back_to_top 	= true;
	endif;

	// Footer Class
	if ( !has_nav_menu('footer-menu') && is_active_sidebar( 'footer_widgets' ) ):
		$footer_class = 'footer-area pb-80';
	elseif( is_active_sidebar( 'footer_widgets' ) ):
		$footer_class = 'footer-area';
	elseif( has_nav_menu('footer-menu') ):
		$footer_class = 'footer-area pt-0';
	else:
		$footer_class = 'blank-footer';
	endif;

?>
	<!-- Start Footer Area -->
	<?php if( $footer_class != 'blank-footer' ): ?>
		<footer class="<?php echo esc_attr( $footer_class ); ?>">
			<div class="container">
				<div class="row">
					<?php if ( is_active_sidebar( 'footer_widgets') ) : ?>
						<?php dynamic_sidebar( 'footer_widgets' ); ?>
					<?php endif; ?>
				</div>

				<?php if( has_nav_menu('footer-menu') || $copyright_text != '' ){ ?>
					<div class="copyright-area">
						<div class="row align-items-center">
							<div class="col-lg-6 col-sm-6 col-md-6">
								<p><?php echo wp_kses_post( $copyright_text ); ?></p>
							</div>

							<div class="col-lg-6 col-sm-6 col-md-6">
								<?php
								if( has_nav_menu('footer-menu') ){
									$args = array(
										'theme_location' 	=> 'footer-menu',
										'menu'            	=> 'footer-menu',
										'container'       	=> 'ul',
										'fallback_cb'  		=> false,
										'menu_class'      	=> 'menu',
										'depth'           	=> 1,
									);
									wp_nav_menu( $args );
								}
								?>
							</div>
						</div>
					</div>
				<?php } ?>
			</div>
		</footer>
	<?php endif; ?>
	<!-- End Footer Area -->

	<?php if( $enable_back_to_top == true ):?>
		<div class="go-top"><i class="fas fa-chevron-up"></i></div>
	<?php endif; ?>

	<!--
	<div class="et-demo-options-toolbar">
		<?php
		//global $wp;
		//$current_url = home_url(add_query_arg(array(), $wp->request));
		?>
		<?php //if( varn_rtl() == true ): ?>
			<a href="<?php //echo esc_url( $current_url ); ?>" class="hint--bounce hint--left hint--black" id="toggle-quick-options" aria-label="LTR">
				<i class="fas fa-align-left"></i>
			</a>
		<?php //else: ?>
			<a href="<?php //echo esc_url( $current_url ); ?>/?rtl=enable" class="hint--bounce hint--left hint--black" id="toggle-quick-options" aria-label="RTL">
				<i class="fas fa-align-right"></i>
			</a>
		<?php //endif; ?>
		<a href="mailto:hello@hibootstrap.com" target="_blank" rel="nofollow" class="hint--bounce hint--left hint--black" aria-label="Reach Us">
			<i class="fas fa-life-ring"></i>
		</a>
		<a href="https://docs.hibootstrap.com/docs/varn-theme-documentation/" target="_blank" rel="nofollow" class="hint--bounce hint--left hint--black" aria-label="Documentation">
			<i class="fas fa-book"></i>
		</a>
		<a href="https://1.envato.market/6Zxn3" target="_blank" rel="nofollow" class="hint--bounce hint--left hint--black" aria-label="Purchase Varn">
			<i class="fas fa-shopping-cart"></i>
		</a>
	</div> 
	-->

<?php wp_footer(); ?>

</body>
</html>