(function($){
	"use strict";
	jQuery(document).on('ready', function () {

        // Header Sticky
		$(window).on('scroll',function() {
            if ($(this).scrollTop() > 120){  
                $('.navbar-area').addClass("is-sticky");
            }
            else{
                $('.navbar-area').removeClass("is-sticky");
            }
        });

        // Sidebar Modal
        $(".burger-menu").on('click',  function() {
			$('.sidebar-modal').toggleClass('active');
		});
        $(".sidebar-modal-close-btn").on('click',  function() {
			$('.sidebar-modal').removeClass('active');
        });
        
        // Search Popup JS
        $('.close-btn').on('click',function() {
            $('.search-overlay').fadeOut();
            $('.search-btn').show();
            $('.close-btn').removeClass('active');
        });
        $('.search-btn').on('click',function() {
            $(this).hide();
            $('.search-overlay').fadeIn();
            $('.close-btn').addClass('active');
        });

        // Accordion
        $('.accordion').find('.accordion-title').on('click', function(){
            // Adds Active Class
            $(this).toggleClass('active');
            // Expand or Collapse This Panel
            $(this).next().slideToggle('fast');
            // Hide The Other Panels
            $('.accordion-content').not($(this).next()).slideUp('fast');
            // Removes Active Class From Other Titles
            $('.accordion-title').not($(this)).removeClass('active');		
        });
        
        // Mean Menu
		jQuery('.mean-menu').meanmenu({
			meanScreenWidth: "991"
        });

        // Button Hover JS
        $(function() {
            $('.default-btn')
            .on('mouseenter', function(e) {
                var parentOffset = $(this).offset(),
                relX = e.pageX - parentOffset.left,
                relY = e.pageY - parentOffset.top;
                $(this).find('span').css({top:relY, left:relX})
            })
            .on('mouseout', function(e) {
                var parentOffset = $(this).offset(),
                relX = e.pageX - parentOffset.left,
                relY = e.pageY - parentOffset.top;
                $(this).find('span').css({top:relY, left:relX})
            });
        });
        // Popup Image
        $('.popup-btn').magnificPopup({
            type: 'image',
            gallery: {
                enabled: true,
            }
        });
        
        // Popup Video
		$('.popup-youtube').magnificPopup({
			disableOn: 320,
			type: 'iframe',
			mainClass: 'mfp-fade',
			removalDelay: 160,
			preloader: false,
			fixedContentPos: false
        });

        // Nice Select JS
        $('select').niceSelect();

        //$('.smartify').smartify();

        // Go to Top
        $(function(){
            // Scroll Event
            $(window).on('scroll', function(){
                var scrolled = $(window).scrollTop();
                if (scrolled > 600) $('.go-top').addClass('active');
                if (scrolled < 600) $('.go-top').removeClass('active');
            });  
            // Click Event
            $('.go-top').on('click', function() {
                $("html, body").animate({ scrollTop: "0" },  500);
            });
        });

    });
	
	// WOW JS
	$(window).on ('load', function (){
        if ($(".wow").length) { 
            var wow = new WOW ({
                boxClass:     'wow',    
                animateClass: 'animated', 
                offset:       20,        
                mobile:       true,   
                live:         true,     
            });
            wow.init();
        }
    });

    // Preloader Area
	$(window).on('load', function() {
		$('.preloader').addClass('preloader-deactivate');
    });

    // Partner Slides
    $( window ).on( 'elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/Partner_Logo.default', function($scope, $){
        
            $('.partner-slides').owlCarousel({
                loop: true,
                nav: false,
                dots: false,
                autoplayHoverPause: true,
                autoplay: true,
                margin: 30,
                navText: [
                    "<i class='flaticon-left-chevron'></i>",
                    "<i class='flaticon-right-chevron'></i>"
                ],
                responsive: {
                    0: {
                        items: 2,
                    },
                    576: {
                        items: 3,
                    },
                    768: {
                        items: 4,
                    },
                    1200: {
                        items: 5,
                    }
                }
            });
        });
    });

    // Tabs
    $( window ).on( 'elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/Feature_Tabs.default', function($scope, $){
        
            (function ($) {
                $('.tab ul.tabs').addClass('active').find('> li:eq(0)').addClass('current');
                $('.tab ul.tabs li a').on('click', function (g) {
                    var tab = $(this).closest('.tab'), 
                    index = $(this).closest('li').index();
                    tab.find('ul.tabs > li').removeClass('current');
                    $(this).closest('li').addClass('current');
                    tab.find('.tab_content').find('div.tabs_item').not('div.tabs_item:eq(' + index + ')').slideUp();
                    tab.find('.tab_content').find('div.tabs_item:eq(' + index + ')').slideDown();
                    g.preventDefault();
                });
            })(jQuery);
        });
    });

    // Fun-facts
    $( window ).on( 'elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/Varn_Funfacts.default', function($scope, $){
        
            // Odometer JS
            $('.odometer').appear(function(e) {
                var odo = $(".odometer");
                odo.each(function() {
                    var countNumber = $(this).attr("data-count");
                    $(this).html(countNumber);
                });
            });
        });
    });

    // Projects Slides
    $( window ).on( 'elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/Project.default', function($scope, $){

            $('.projects-slides').owlCarousel({
                loop: true,
                nav: false,
                dots: true,
                autoplayHoverPause: true,
                autoplay: true,
                margin: 30,
                navText: [
                    "<i class='flaticon-left-chevron'></i>",
                    "<i class='flaticon-right-chevron'></i>"
                ],
                responsive: {
                    0: {
                        items: 1,
                    },
                    576: {
                        items: 2,
                    },
                    768: {
                        items: 2,
                    },
                    1200: {
                        items: 3,
                    }
                }
            });
           
        });
    });

    // Feedback Slides
    $( window ).on( 'elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/Feedback.default', function($scope, $){

            // Feedback Slides
            $('.feedback-slides').owlCarousel({
                loop: true,
                nav: false,
                dots: true,
                autoplayHoverPause: true,
                autoplay: true,
                navText: [
                    "<i class='flaticon-left-chevron'></i>",
                    "<i class='flaticon-right-chevron'></i>"
                ],
                responsive: {
                    0: {
                        items: 1,
                    },
                    768: {
                        items: 2,
                    },
                    1200: {
                        items: 3,
                    },
                    1550: {
                        items: 4,
                    }
                }
            });
           
        });
    });

    // SEO Banner Slider
    $( window ).on( 'elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/Varn_Banner_Five.default', function($scope, $){
            
            $('.it-banner-image').owlCarousel({
                items: 1,
                loop: true,
                nav: false,
                animateOut: 'fadeOut',
                dots: false,
                margin: 0,
                autoplayHoverPause: true,
                autoplay: true,
            });
        });
    });

    // Team Slides
    $( window ).on( 'elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/Team_Slider.default', function($scope, $){
            
            $('.team-slider').owlCarousel({
                loop: true,
                nav: true,
                dots: false,
                margin: 30,
                autoplayHoverPause: true,
                autoplay: true,
                navText: [
                    "<i class='flaticon-left-chevron'></i>",
                    "<i class='flaticon-right-chevron'></i>"
                ],
                responsive: {
                    0: {
                        items: 1,
                    },
                    576: {
                        items: 2,
                    },
                    768: {
                        items: 3,
                    }
                }
            });
        });
    });

    // Work Slides
    $( window ).on( 'elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/Works.default', function($scope, $){
            $('.work-slider').owlCarousel({
                loop: true,
                nav: true,
                dots: false,
                margin: 30,
                autoplayHoverPause: true,
                autoplay: true,
                navText: [
                    "<i class='flaticon-left-chevron'></i>",
                    "<i class='flaticon-right-chevron'></i>"
                ],
                responsive: {
                    0: {
                        items: 1,
                    },
                    576: {
                        items: 2,
                    },
                    930: {
                        items: 3,
                    },
                    1200: {
                        items: 4,
                    }
                }
            });
        });
    });

    // SEO Banner Slider
    $( window ).on( 'elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/Varn_Banner_Six.default', function($scope, $){
            $('.seo-banner-slider').owlCarousel({
                items: 1,
                loop: true,
                nav: true,
                dots: false,
                margin: 0,
                autoplayHoverPause: true,
                autoplay: true,
                autoHeight:true,
                mouseDrag: false,
                navText: [
                    "<i class='flaticon-left-chevron'></i>",
                    "<i class='flaticon-right-chevron'></i>"
                ],
            });

            $(".seo-banner-slider").on("translate.owl.carousel", function(){
                $(".seo-banner h1, .seo-banner p").removeClass("animated fadeInUp").css("opacity", "0");
                $(".seo-banner .banner-btn").removeClass("animated fadeInDown").css("opacity", "0");
            });

            $(".seo-banner-slider").on("translated.owl.carousel", function(){
                $(".seo-banner h1, .seo-banner p").addClass("animated fadeInUp").css("opacity", "1");
                $(".seo-banner .banner-btn").addClass("animated fadeInDown").css("opacity", "1");
            });
        });
    });

    // Machine learning slider
    $( window ).on( 'elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/Varn_Banner_Eight.default', function($scope, $){
            $('.machine-learning-slider').owlCarousel({
                items: 1,
                loop: true,
                nav: true,
                dots: true,
                margin: 0,
                autoplayHoverPause: true,
                autoHeight:true,
                mouseDrag: false,
                navText: [
                    "<i class='flaticon-left-chevron'></i>",
                    "<i class='flaticon-right-chevron'></i>"
                ],
            });

            $(".machine-learning-slider").on("translate.owl.carousel", function(){
                $(".machine-learning-banner h1, .machine-learning-banner p").removeClass("animated fadeInUp").css("opacity", "0");
                $(".machine-learning-banner .banner-btn").removeClass("animated fadeInDown").css("opacity", "0");
            });
            
            $(".machine-learning-slider").on("translated.owl.carousel", function(){
                $(".machine-learning-banner h1, .machine-learning-banner p").addClass("animated fadeInUp").css("opacity", "1");
                $(".machine-learning-banner .banner-btn").addClass("animated fadeInDown").css("opacity", "1");
            });
        });
    });

}(jQuery));