<?php
/**
 * The archive file
 * @package Varn
 */
get_header();

// Blog Sidebar
if(isset($varn_opt['varn_blog_sidebar'])) {
    if( $varn_opt['varn_blog_sidebar'] == 'varn_without_sidebar_center' ):
        $varn_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
    elseif( $varn_opt['varn_blog_sidebar'] == 'varn_without_sidebar' ):
        $varn_sidebar_class = 'col-lg-12 col-md-12';
    else:
        if( is_active_sidebar( 'sidebar-1' ) ):
            $varn_sidebar_class = 'col-lg-8 col-md-12';
        else:
            $varn_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
        endif;
    endif;
    $sidebar_hide           = $varn_opt['varn_blog_sidebar'];
    $hide_blog_banner       = $varn_opt['hide_blog_banner'];
    $blog_title             = $varn_opt['blog_title'];
    $hide_breadcrumb        = $varn_opt['hide_breadcrumb'];
} else {
    if( is_active_sidebar( 'sidebar-1' ) ):
        $varn_sidebar_class         = 'col-lg-8 col-md-12';
        $sidebar_hide               = 'varn_with_sidebar';
    else:
        $varn_sidebar_class             = 'col-lg-8 col-md-12 offset-lg-2';
        $sidebar_hide                   = 'varn_without_sidebar';
    endif;
    $hide_blog_banner = false;
    $blog_title       = esc_html__('Blog', 'varn');
    $hide_breadcrumb  = false;
} 
$blog_link = get_permalink( get_option( 'page_for_posts' ));

$varn_blog_layout = !empty($varn_opt['varn_blog_layout']) ? $varn_opt['varn_blog_layout'] : 'container';
if ( !empty($_GET['varn_blog_layout']) ) {
    $varn_blog_layout = $_GET['varn_blog_layout'];
}

if( isset($varn_opt['page_title_tag']) ):
    $tag = $varn_opt['page_title_tag'];
else:
    $tag = 'h2';
endif;

?>

    <!-- Start Page Title Area -->
    <?php if( $hide_blog_banner == false ): ?>
        <div class="page-title-area page-title-bg1">
            <div class="d-table">
                <div class="d-table-cell">
                    <div class="container">
                        <div class="page-title-content">
                            <<?php echo esc_attr( $tag ); ?>><?php the_archive_title(); ?></<?php echo esc_attr( $tag ); ?>>

                            <?php if( $hide_breadcrumb == false ): ?>
                                <?php
									if ( function_exists('yoast_breadcrumb') ) {
										yoast_breadcrumb( '<p class="varn-seo-breadcrumbs" id="breadcrumbs">','</p>' );
									} else { ?>
                                        <ul>
                                            <li><a href="<?php echo esc_url( $blog_link ); ?>"><?php echo esc_html( $blog_title ); ?></a></li>
                                            <li><?php the_archive_title(); ?></li>
                                            <?php if( get_the_archive_description() != '' ): ?>
                                                <li><?php the_archive_description(); ?></li>
                                            <?php endif; ?>
                                        </ul><?php
                                    }
                            endif; ?>
                        </div>
                    </div>
                </div>
            </div>
			<?php varn_page_shape_images(); ?>
        </div>
    <?php endif; ?>
    <!-- End Page Title Area -->

    <!-- Start Blog Area -->
    <div class="blog-area ptb-100">
        <div class="<?php echo esc_attr( $varn_blog_layout ); ?>">
            <div class="row">
                <!-- Start Blog Content -->
                <div class="<?php echo esc_attr( $varn_sidebar_class ); ?>">
                    <?php
                    if ( have_posts() ) :
                        while ( have_posts() ) :
                            the_post();
                            get_template_part( 'template-parts/content', get_post_format());
                        endwhile;
                    else :
                        get_template_part( 'template-parts/content', 'none' );
                    endif;
                    ?>
            
                    <!-- Stat Pagination -->
                    <div class="pagination-area">
                        <nav aria-label="navigation">
                        <?php echo paginate_links( array(
                            'format' => '?paged=%#%',
                            'prev_text' => '<i class="bx bx-chevrons-left"></i>',
                            'next_text' => '<i class="bx bx-chevrons-right"></i>',
                                )
                            ) ?>
                        </nav>
                    </div>
                    <!-- End Pagination -->
                </div>
                <!-- End Blog Content -->
                
                <?php if( $sidebar_hide == 'varn_with_sidebar' ): ?>
                    <?php get_sidebar(); ?>
                <?php endif; ?>
            </div>   
        </div>
    </div>
    <!-- End Blog Area -->
<?php
get_footer();
