<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package Varn
 */

global $varn_opt;

get_header();

if ( isset( $varn_opt['title_not_found'] ) ):
	$title 		= $varn_opt['title_not_found'];
	$content 	= $varn_opt['content_not_found'];
	$button 	= $varn_opt['button_not_found'];
	$image 		= $varn_opt['not_found_image']['url'];
else:
	$title 		=  esc_html__('Page Not Found', 'varn');
	$content 	=  esc_html__('The page you are looking for might have been removed had its name changed or is temporarily unavailable.', 'varn');
	$button 	=  esc_html__('Go to Home', 'varn');
	$image 		= '';
endif;

if( isset( $varn_opt['enable_lazyloader'] ) ):
	$is_lazyloader = $varn_opt['enable_lazyloader'];
else:
	$is_lazyloader = true;
endif;
?>
<div class="error-area">
	<div class="d-table">
		<div class="d-table-cell">
			<div class="container">
				<div class="error-content">
					<?php if( $image != '' ): 
						if( $is_lazyloader == true ): ?>
							<img class="smartify" sm-src="<?php echo esc_url( $image ); ?> " alt="<?php echo esc_attr( $title ); ?>">
						<?php else: ?>
							<img src="<?php echo esc_url( $image ); ?> " alt="<?php echo esc_attr( $title ); ?>">
						<?php endif;
					endif; ?>

					<?php if ( !isset( $varn_opt['not_found_image'] ) ):
						if( $is_lazyloader == true ): ?>
							<img class="smartify" sm-src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/404.png' ); ?>" alt="<?php echo esc_attr__( '404', 'varn' ); ?>">
						<?php else: ?>
							<img src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/404.png' ); ?>" alt="<?php echo esc_attr__( '404', 'varn' ); ?>">
						<?php endif;
					endif; ?>

					<h3><?php echo esc_html( $title ); ?></h3>
					<p><?php echo esc_html( $content ); ?></p>

					<?php if(  $button != '' ): ?>
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="default-btn"><?php echo esc_html( $button ); ?><span></span></a>
					<?php endif; ?>

				</div>
			</div>
		</div>
	</div>
</div>

<?php get_footer();