<?php
/**
 * Template part for displaying Login widget when user authorized.
 * You free to customize widget contents in child theme.
 * Copy that file into 'parts' folder of your Child Theme.
 *
 * @package Utouch
 */

global $allowedposttags;
$template_uri = get_template_directory_uri();
$author_id    = get_the_author_meta( 'ID' );
$description  = get_the_author_meta( 'description' );
$socials      = get_the_author_meta( 'utouch_social_networks' );
$socials      = utouch_akg( 'social-networks', $socials, array() );
if ( ! empty( $description ) ) {
	?>
	<div class="blog-details-author">

		<div class="img-author">
			<?php echo get_avatar( $author_id, 64 ); ?>
		</div>
		<div class="author-info">
			<a href="<?php echo get_author_posts_url( $author_id ); ?>"
			   class="h6 author-name"><?php the_author_meta( 'display_name', $author_id ); ?></a>
			<p><?php echo wp_kses( $description, $allowedposttags ); ?></p>
		</div>

		<ul class="socials socials--round socials--colored">

			<?php foreach ( $socials as $social ) { ?>
				<li>
					<a href="<?php echo esc_html( $social['link'] ); ?>" target="_blank"
					   class="social__item <?php echo str_replace('.svg','',$social['icon'])?>"><?php $svg_link = get_template_directory_uri() . '/svg/socials/plain/' . $social['icon'];
						echo utouch_get_svg_icon( $svg_link ); ?></a>
				</li>
			<?php } ?>
		</ul>

	</div>


<?php }