<?php
/** @var array $atts */
$title      = $desc = $icon = $image = $position = $show_link = $link_button = $link = $custom_class = $data_img = $data_icon = $data_title = $data_desc = $data_position = $data_button = $media = '';
$btn_color  = $btn_size = $outlined = '';
$layout     = 'standard';
$wrap_class = apply_filters( 'kc-el-class', $atts );

global $allowedtags;
extract( $atts );
$wrap_class[] = 'crumina-module';
$wrap_class[] = 'crumina-info-box';
$wrap_class[] = 'info-box--' . $layout;

if ( ! empty( $custom_class ) ) {
	$wrap_class[] = $custom_class;
}
$img_width  = 70;
$img_height = 70;

if ( 'classic' === $layout ) {
	$img_width = $img_height = 60;
}
if ( 'standard-nofloat' === $layout ) {
	$img_width = $img_height = 40;
}

if ( 'image' === $media && $image > 0 ) {
	$img_link = wp_get_attachment_image_src( $image, 'full' );

	$data_img .= '<img width="' . $img_width . '" height="' . $img_height . '" src="' . $img_link[0] . '" alt="">';

} else {
	if ( empty( $icon ) || $icon == '__empty__' ) {
		$icon = 'et-trophy';
	}

	$data_img .= '<i class="' . $icon . '"></i>';
}

if ( $show_link == 'yes' ) {
	$link        = ( '||' === $link ) ? '' : $link;
	$button_link = kc_parse_link( $link );

	if ( strlen( $button_link['url'] ) > 0 ) {
		$button_href   = $button_link['url'];
		$button_title  = ! empty( $button_link['title'] ) ? $button_link['title'] : esc_html__( 'Read More', 'utouch' );
		$button_target = ! empty( $button_link['target'] ) ? $button_link['target'] : '_self';

		if ( 'yes' === $link_button ) {
			$btn_class = array( 'btn', ' btn--with-shadow' );
			if ( 'yes' == $outlined ) {
				$btn_class[] = 'btn-border';
			}
			$btn_class[] = 'btn-' . esc_attr( $btn_size );

			$btn_color = empty($btn_color) ? 'primary' : $btn_color;
			$btn_class[] = 'btn--' . esc_attr( $btn_color );

			$data_button .= '<a href="' . esc_url( $button_href ) . '" target="' . $button_target . '" title="' . $button_title . '"';
			$data_button .= 'class="' . esc_attr( implode( ' ', $btn_class ) ) . '" >';
			$data_button .= '<span class="text">' . esc_html( $button_title ) . ' </span>';
			$data_button .= '</a>';
		} else {
			$data_button .= '<a class="read-more" href="' . esc_url( $button_href ) . '" target="' . $button_target . '" title="' . $button_title . '">' . $button_title . '<i class="seoicon-right-arrow"></i></a>';
		}
		if ( ! empty( $title ) ) {
			$title_href = '<a href="' . esc_url( $button_href ) . '" target="' . $button_target . '" title="' . $button_title . '">' . esc_html( $title ) . '</a>';
		}
	}
} ?>
<?php

if ( 'standard-hover' === $layout ) {
	?>
	<div class="<?php echo implode( ' ', $wrap_class ); ?>">

		<div class="info-box-image">
			<?php echo( $data_img ); ?>
		</div>

		<div class="info-box-content">
			<?php
			if('yes' === $show_link){
				$title_tag = 'a';
				$before_title = '<h5>';
				$after_title = '</h5>';
			}else{
				$title_tag = 'h5';
				$before_title = '';
				$after_title = '';
			}
			echo $before_title . utouch_html_tag( $title_tag, array(
					'class' => 'h5 info-box-title',
					'href'  => isset( $button_href ) ? $button_href : ''
				), $title ) . $after_title;
			?>

			<div class="info-box-text"><?php echo esc_html( $desc ) ?></div>
		</div>

		<?php if ( 'yes' === $show_link ) { ?>
			<a href="<?php echo( isset( $button_href ) ? $button_href : '' ) ?>" class="btn-next">
				<svg class="utouch-icon icon-hover utouch-icon-arrow-right-1">
					<use xlink:href="#utouch-icon-arrow-right-1"></use>
				</svg>
				<svg class="utouch-icon utouch-icon-arrow-right1">
					<use xlink:href="#utouch-icon-arrow-right1"></use>
				</svg>
			</a>
		<?php } ?>

	</div>

	<?php
} elseif ( 'classic' === $layout ) {
	?>
	<div class="<?php echo implode( ' ', $wrap_class ); ?>" data-mh="box--classic">

		<div class="info-box-image">
			<?php echo( $data_img ); ?>
		</div>

		<div class="info-box-content">
			<?php
			if('yes' === $show_link){
				$title_tag = 'a';
				$before_title = '<h5>';
				$after_title = '</h5>';
			}else{
				$title_tag = 'h5';
				$before_title = '';
				$after_title = '';
			}
			echo $before_title . utouch_html_tag( $title_tag, array(
				'class' => 'h5 info-box-title',
				'href'  => isset( $button_href ) ? $button_href : ''
			), $title ) . $after_title;
			?>
			<div class="info-box-text"><?php echo esc_html( $desc ) ?></div>
		</div>
	</div>
	<?php

} elseif ( 'standard-nofloat' === $layout ) {
	$wrap_class[] = 'info-box--standard';
	?>
	<div class="<?php echo implode( ' ', $wrap_class ); ?>">
		<div class="info-box-image display-flex">
			<div class="icon-small info-box-image"><?php echo( $data_img ); ?></div>
			<?php
			if('yes' === $show_link){
				$title_tag = 'a';
				$before_title = '<h5>';
				$after_title = '</h5>';
			}else{
				$title_tag = 'h6';
				$before_title = '';
				$after_title = '';
			}
			echo $before_title . utouch_html_tag( $title_tag, array(
					'class' => 'h6 info-box-title',
					'href'  => isset( $button_href ) ? $button_href : ''
				), $title ) . $after_title;
			?>

		</div>
		<div class="info-box-text"><?php echo esc_html( $desc ) ?></div>
	</div>
	<?php
} elseif ( 'number' === $layout ) {
	?>
	<div class="crumina-module crumina-info-box info-box--numbers">
		<h5 class="order-number"><?php echo esc_html($box_number) ?></h5>
		<?php
		if('yes' === $show_link){
			$title_tag = 'a';
			$before_title = '<h5>';
			$after_title = '</h5>';
		}else{
			$title_tag = 'h3';
			$before_title = '';
			$after_title = '';
		}
		echo $before_title . utouch_html_tag( $title_tag, array(
				'class' => 'h3 info-box-title',
				'href'  => isset( $button_href ) ? $button_href : ''
			), $title ) . $after_title;
		?>
		<div class="info-box-text"><?php echo esc_html( $desc ) ?></div>
	</div>
	<?php
}
return;
?>
<div class="<?php echo implode( ' ', $wrap_class ); ?>">
	<div class="info-box-image">
		<?php echo( $data_img ); ?>
	</div>
	<div class="info-box-content">
		<?php
		if ( ! empty( $title ) ) { ?>
			<h5 class="info-box-title"><?php echo wp_kses( $title, $allowedtags ) ?></h5>
		<?php } ?>
		<?php if ( ! empty( $desc ) ) { ?>
			<div class="info-box-text"><?php echo wp_kses( $desc, $allowedtags ); ?></div>
		<?php } ?>
		<?php echo( $data_button ) ?>
	</div>
</div>