<?php
/**
 * @package utouch-wp
 */

/**
 * Class Utouch_Event
 *
 * @property int ID
 *
 * general tab
 *
 * @property bool show_share
 * @property string navigation_type
 * @property string prev_next_home
 * @property string related_title
 * @property string related_to_show
 * ------------------------------------
 *
 * content tab
 *
 * @property string workshop_title
 * @property string workshop_desc
 * ------------------------------------
 *
 * schedule tab
 *
 * @property bool show_schedule
 * @property string schedule_title
 * @property string schedule_desc
 * @property bool all_day_event
 * @property array dates
 * ------------------------------------
 *
 * speakers tab
 *
 * @property bool show_speakers
 * @property string speakers_title
 * @property string speakers_desc
 * @property array speakers
 * ------------------------------------
 *
 * location tab
 *
 * @property bool show_location
 * @property string location_title
 * @property string location_desc
 * @property string gmaps_api_key
 * @property array location
 * @property array contacts
 * ------------------------------------
 *
 * get in touch tab
 *
 * @property bool show_get_in_touch
 * @property string get_in_touch_title
 * @property string get_in_touch_desc
 * @property string get_in_touch_email
 * @property string get_in_touch_btn_label
 * @property string get_in_touch_btn_color
 * ------------------------------------
 *
 * aside block tab
 *
 * @property bool show_aside_block
 * @property string countdown_title
 * @property int main_speaker
 * @property string button_label
 * @property string button_color
 * @property string button_url
 * @property string button_target
 * ------------------------------------
 *
 * customizer tab labels
 *
 * @property string workshop_label
 * @property string schedule_label
 * @property string speakers_label
 * @property string location_label
 * ------------------------------------
 *
 * preview style
 *
 * @property string preview_style
 * @property string preview_size
 * @property int category_id
 * @property string preview_accent_color
 * @property string preview_overlay
 * ------------------------------------
 *
 * generated by class
 *
 * @property DateTime $date_start
 * @property DateTime $date_finish
 *
 * @property array $day_dates
 */
class Utouch_Event {
	private $data;

	public function __construct( $data ) {
		$this->data = $data;


		$dates_by_day = array();
		foreach ( $this->data['dates'] as &$dates ) {
			$dates['from'] = new DateTime( $dates['from'] );
			$dates['to']   = new DateTime( $dates['to'] );

			$key = $dates['from']->format( 'o.m.d' );
			if ( ! array_key_exists( $key, $dates_by_day ) ) {
				$dates_by_day[ $key ]['day'] = $dates['from'];
			}

			$dates_by_day[ $key ]['dates'][] = $dates;

		}
		ksort( $dates_by_day );
		foreach ( $dates_by_day as &$day_dates ) {
			usort( $day_dates['dates'], array( $this, 'compare_dates' ) );
		}
		$this->day_dates = $dates_by_day;

		if ( ! empty( $this->dates ) ) {
			$date_start  = $this->dates[0]['from'];
			$date_finish = $this->dates[0]['to'];

			for ( $i = 1, $j = count( $this->dates ); $i < $j; $i ++ ) {
				$t_start  = $this->dates[ $i ]['from'];
				$t_finish = $this->dates[ $i ]['to'];

				if ( $t_start < $date_start ) {
					$date_start = $t_start;
				}

				if ( $t_finish > $date_finish ) {
					$date_finish = $t_finish;
				}
			}

			$this->data['date_start']  = $date_start;
			$this->data['date_finish'] = $date_finish;
		}
	}

	/**
	 * Get utouch event dates range
	 *
	 * @return string
	 */
	function get_dates_range() {
		if ( empty( $this->date_start ) || empty( $this->date_finish ) ) {
			return '';
		}
		$date_start  = $this->date_start;
		$date_finish = $this->date_finish;

		if ( $date_start->format( 'Y' ) === $date_finish->format( 'Y' ) ) {
			if ( $date_start->format( 'n' ) === $date_finish->format( 'n' ) ) {
				if ( $date_start->format( 'j' ) === $date_finish->format( 'j' ) ) {
					return $date_start->format( 'F j, Y' );
				} else {
					return $date_start->format( 'F j' ) . ' - ' . $date_finish->format( 'j, Y' );
				}
			} else {
				return $date_start->format( 'F j' ) . ' - ' . $date_finish->format( 'F j, Y' );
			}
		} else {
			return $date_start->format( 'F j, Y' ) . ' - ' . $date_finish->format( 'F j, Y' );
		}

	}

	/**
	 * Get utouch event date & location string
	 *
	 * @return string
	 */
	function get_date_location() {

		return trim( $this->get_dates_range() . ', ' . $this->location['city'], ', ' );

	}

	public function compare_dates( $d1, $d2 ) {
		if ( $d1['from'] < $d2['from'] ) {
			return - 1;
		} else {
			return 1;
		}
	}

	/**
	 * Get class property
	 *
	 * @param string $name name of class property.
	 *
	 * @return mixed
	 */
	public function __get( $name ) {

		return isset( $this->data[ $name ] ) ? $this->data[ $name ] : null;
	}

	/**
	 * Check is class property is set
	 *
	 * @param string $name name of class property.
	 *
	 * @return bool
	 */
	public function __isset( $name ) {
		return isset( $this->data[ $name ] );
	}

}