<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
} ?>
<?php if ( isset( $data['slides'] ) ):
	global $allowedtags;
//	fw_print( $data );
	$attributes      = array();
	$autoplay        = utouch_akg( 'settings/extra/autoplay', $data, 0 );
	$full_height     = utouch_akg( 'settings/extra/full_height', $data, 'off' );
	$slide_labels    = utouch_akg( 'settings/extra/slide_labels', $data, 'on' );
	$slide_arrows    = utouch_akg( 'settings/extra/slide_arrows', $data, 'on' );
	$slider_infinity = utouch_akg( 'settings/extra/slider_infinity', $data, 'on' );


	if ( 0 !== $autoplay ) {
		$attributes[] = 'data-autoplay="' . esc_attr( $autoplay * 1000 ) . '"';
	}
	if ( 'off' === $slider_infinity ) {
		$attributes[] = 'data-loop="false"';
	}
	$additional_class = 'on' === $full_height ? 'js-full-window' : '';
	$additional_class .= 'off' === $slide_labels ? ' no-labels' : '';

	?>

<div class="crumina-module-slider">
	<div class=" swiper-container main-slider navigation-center-both-sides <?php echo esc_attr( $additional_class ); ?>"
		 data-effect="fade" data-parallax="true" <?php echo implode( ' ', $attributes ); ?>>

		<!-- Additional required wrapper -->
		<div class="swiper-wrapper">
			<!-- Slides -->
			<?php foreach ( $data['slides'] as $slide ) {
				Utouch::set_var( 'swiper_slide', $slide );
				$align = utouch_akg( 'extra/text-align', $slide, 'center' );
				get_template_part( 'parts/main-slider/align', $align );
				continue;
				$bg_color     = utouch_akg( 'extra/bg-color', $slide, '#f7f9f9' );
				$bg_image     = utouch_akg( 'extra/bg-image/url', $slide, '' );
				$title        = utouch_akg( 'title', $slide, '' );
				$subtitle     = utouch_akg( 'desc', $slide, '' );
				$image_layout = utouch_akg( 'extra/image_layout', $slide, 'content' );

				$slide_class = 'dark' === utouch_akg( 'extra/text-color', $slide, 'dark' ) ? 'main-slider-bg-light c-black' : 'main-slider-bg-dark c-white';
				$buttons     = utouch_akg( 'extra/buttons', $slide, array() );
				$slide_class .= 'alignright' === $align ? ' thumb-left' : '';

//				$column_class = ( 'center' === $align || ! isset( $slide['attachment_id'] ) || empty( $slide['attachment_id'] ) ) ? 'slider-content-fullwidth align-center' : 'slider-content-half-width table-cell ';
				$column_class = ( 'center' === $align ) ? 'slider-content-fullwidth align-center col-lg-8 col-lg-offset-2 col-md-8 col-md-offset-2 col-sm-12 col-sm-offset-0 col-xs-12' : 'slider-content-half-width table-cell ';


				if ( 'center' === $align ) {
					$title_tag    = 'h1';
					$subtitle_tag = 'h6';
				} else {
					$title_tag    = 'h2';
					$subtitle_tag = 'h6';
				}
				if ( 'background' === $image_layout ) {
					$bg_image     = wp_get_attachment_image_url( $slide['attachment_id'], 'full' );
					$overlay_html = '<div class="overlay" style="background-color:' . esc_attr( $bg_color ) . '; opacity:0.3"></div>';
				} else {
					$overlay_html = '';
				}

				$slide_style = '';

				if ( ! empty( $bg_image ) ) {
					$slide_style .= 'background-image:url(' . esc_attr( utouch_akg( 'extra/bg-image/url', $slide, '' ) ) . ')';
				}
				if ( ! empty( $bg_color ) ) {
					$slide_style .= 'background-color: ' . esc_attr( $bg_color ) . '';
				}

				if ( 'yes' === utouch_akg( 'extra/title_decoration', $slide, 'no' ) ) {
					$title_tag .= ' with-decoration ';
				}


				?>
				<!-- Slides -->

				<div class="swiper-slide <?php echo esc_attr( $slide_class ) ?>"
					 style="<?php echo( $slide_style ) ?>">
					<?php echo( $overlay_html ) ?>
					<div class="container table">
						<div class="slider-content  <?php echo esc_attr( $column_class ) ?>">
							<?php if ( ! empty( $title ) ) { ?>
								<h1 class="slider-content-title <?php echo esc_attr( $title_tag ) ?>"
									data-swiper-parallax="-100"><?php echo wp_kses( $title, $allowedtags ) ?><?php
									if ( 'yes' === utouch_akg( 'extra/title_decoration', $slide, 'no' ) ) {
										?>

										<svg class="first-decoration utouch-icon utouch-icon-arrow-left">
											<use xlink:href="#utouch-icon-arrow-left"></use>
										</svg>

										<svg class="second-decoration utouch-icon utouch-icon-arrow-left">
											<use xlink:href="#utouch-icon-arrow-left"></use>
										</svg>
										<?php
									}
									?></h1>
							<?php }
							if ( ! empty( $subtitle ) ) { ?>
								<div class="slider-content-text <?php echo esc_attr( $subtitle_tag ) ?>"
									 data-swiper-parallax="-200"><?php echo do_shortcode( $subtitle ) ?></div>
							<?php } ?>

							<?php if ( count( $buttons ) > 0 ) { ?>
								<div class="main-slider-btn-wrap" data-swiper-parallax="-300">
									<?php foreach ( $buttons as $button ) {
										$style = utouch_akg( 'button/style', $button, 'app-store' );
										$link  = utouch_gen_link_for_shortcode( $button );

										if ( 'app-store' === $style ) {
											?>
											<a href="<?php echo esc_url( $link['link'] ) ?>"
											   target="<?php echo esc_attr( $link['target'] ) ?>"
											   class="btn btn-small btn--black btn--with-icon">
												<svg class="utouch-icon utouch-icon-apple-logotype-1">
													<use xlink:href="#utouch-icon-apple-logotype-1"></use>
												</svg>
												<div class="text">
													<span class="sup-title"><?php echo esc_html__( 'Download on the', 'utouch' ) ?></span>
													<span class="title"><?php echo esc_html__( 'App Store', 'utouch' ) ?></span>
												</div>
											</a>

											<?php
										} elseif ( 'google-play' === $style ) {

											?>

											<a href="<?php echo esc_url( $link['link'] ) ?>"
											   target="<?php echo esc_attr( $link['target'] ) ?>"
											   class="btn btn-small btn--black btn--with-icon">
												<img class="utouch-icon"
													 src="<?php echo get_template_directory_uri() ?>/svg/google-play.svg"
													 alt="google">
												<div class="text">
													<span class="sup-title"><?php echo esc_html__( 'Download on the', 'utouch' ) ?></span>
													<span class="title"><?php echo esc_html__( 'Google Play', 'utouch' ) ?></span>
												</div>
											</a>
										<?php } elseif ( 'regular' === $style ) {
											$button = utouch_akg( 'button/regular', $button, array() );
											if ( ! empty( $button['label'] ) ) {
												$classes   = array();
												$classes[] = 'btn'; // Base button class.
												$classes[] = 'btn-' . $button['size']; // Size class.
												$classes[] = 'on' === ( $button['shadow'] ) ? 'btn--with-shadow' : ''; // Shadow class
												$classes[] = 'btn--' . $button['color'];
												if ( isset( $button['outlined'] ) && 'on' === ( $button['outlined'] ) ) {
													$classes[] = 'btn-border';
												}
												$classes[] = isset( $button['class'] ) ? $button['class'] : '';
												?>
												<a href="<?php echo esc_url( $link['link'] ) ?>"
												   target="<?php echo esc_attr( $link['target'] ) ?>"
												   class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>">
													<span class="text"><?php echo esc_html( $button['label'] ) ?></span>
													<?php if ( '_blank' === $link['target'] ) {
														echo '<i class="seoicon-right-arrow"></i>';
													} ?>
												</a>
											<?php }

										}

									} ?>
								</div>
							<?php } ?>
						</div>

						<div class="<?php echo esc_attr( $column_class ) ?>">
							<?php if ( isset( $slide['attachment_id'] ) && ! empty( $slide['attachment_id'] ) && 'background' !== $image_layout ) { ?>
								<div class="slider-thumb-img align-center" data-swiper-parallax="-400"
									 data-swiper-parallax-duration="600">
									<?php echo wp_get_attachment_image( $slide['attachment_id'], 'full' ); ?>
								</div>
							<?php } ?>
						</div>

					</div>

				</div>

			<?php } ?>

		</div>


		<?php if ( ( count( $data['slides'] ) > 1 ) && ( $slide_arrows !== 'off' ) ) { ?>
			<!--Prev next buttons-->
			<div class="btn-prev with-bg">
				<svg class="utouch-icon icon-hover utouch-icon-arrow-left-1">
					<use xlink:href="#utouch-icon-arrow-left-1"></use>
				</svg>
				<svg class="utouch-icon utouch-icon-arrow-left1">
					<use xlink:href="#utouch-icon-arrow-left1"></use>
				</svg>
			</div>

			<div class="btn-next with-bg">
				<svg class="utouch-icon icon-hover utouch-icon-arrow-right-1">
					<use xlink:href="#utouch-icon-arrow-right-1"></use>
				</svg>
				<svg class="utouch-icon utouch-icon-arrow-right1">
					<use xlink:href="#utouch-icon-arrow-right1"></use>
				</svg>
			</div>
		<?php } ?>
		<!--Pagination tabs-->
	</div>
	<!-- ... End Main Slider -->
</div>
<?php endif; ?>