<?php

/**
 * importer field extension class.
 *
 * @version     1.0.0
 */
/* exit if accessed directly. */
if (!defined('ABSPATH')) {
    exit;
}

/* don't duplicate me! */
if (!class_exists('ReduxFramework_extension_importer')) {


    /**
     *  ReduxFramework_extension_importer class.
     *
     * @since       1.0.0
     */
    class ReduxFramework_extension_importer extends ReduxFramework {

        /**
         * @access      protected
         * @since       1.0.0
         * @var         array $parent ReduxFramework object
         */
        protected $parent;

        /**
         * @access      public
         * @static
         * @since       1.0.0
         * @var         object $instance singleton instance
         */
        public static $instance;

        /**
         * class Constructor - defines the args for the extions class.
         *
         * @access      public
         * @since       1.0.0
         *
         * @param       array $sections   panel sections
         * @param       array $args       panel arguments
         * @param       array $extra_tabs extra panel tabs
         *
         * @return      void
         */
        public function __construct($parent) {
            $this->parent = $parent;
            $this->field_name = 'importer';

            if (!isset(self::$instance)) {
                self::$instance = $this;
            }

            /* implement custom field. */
            add_filter('redux/' . $this->parent->args['opt_name'] . '/field/class/' . $this->field_name, array($this, 'overload_field_path'));
            $this->redux_importer_section();
            add_action('wp_ajax_nopriv_unload_demoImporter', array($this, 'unload_demoImporter'));
            add_action('wp_ajax_unload_demoImporter', array($this, 'unload_demoImporter'));
            add_action('wp_ajax_nopriv_unload_importNow', array($this, 'unload_importNow'));
            add_action('wp_ajax_unload_importNow', array($this, 'unload_importNow'));
        }

        /* __construct() */

        /**
         * get singleton instance.
         *
         * @access      public
         * @static
         * @since       1.0.0
         * @return      object      $instance       singleton instance
         */
        public static function getInstance() {

            if (!isset(self::$instance)) {

                /* instance class. */
                self::$instance = new self;
            }

            return self::$instance;
        }

        /* get_instance() */

        /**
         * implement custom field.
         *
         * @access      public
         * @static
         * @since       1.0.0
         * @return      object      $instance       singleton instance
         */
        public function overload_field_path($field) {
            return Plugin_ROOT . 'panel/redux-extensions/extensions/' . $this->field_name . '/' . $this->field_name . '.php';
        }

        /* overload_field_path() */

        public function redux_importer_section() {
            for ($n = 0; $n <= count($this->parent->sections); $n ++) {
                if (isset($this->parent->sections[$n]['id']) && $this->parent->sections[$n]['id'] == 'redux_importer_section') {
                    return;
                }
            }

            $redux_importer_label = trim(esc_html(apply_filters('wp_importer_label', esc_html__('Demo Importer', 'unload'))));
            $redux_importer_label = (!empty($wbc_importer_label) ) ? $redux_importer_label : esc_html__('Demo Importer', 'unload');
            $section = array(
                'id' => 'redux_importer_section',
                'title' => $redux_importer_label,
                'desc' => 'Click "Import Demo" button to import demo settings',
                'icon' => 'el-icon-website',
                'fields' => array(
                    array(
                        'id' => 'redux_importer',
                        'type' => 'importer',
                        'full_width' => TRUE,
                    )
                )
            );
            $this->parent->sections[] = $section;
        }

        public function unload_demoImporter() {

            if (isset($_POST) && $_POST['action'] == 'unload_demoImporter') {

                $url = 'http://webinane.com/demoData/unload/demo.zip';

                $file = 'demo.zip';

                $ext = get_loaded_extensions();

                global $wp_version, $wp_filesystem;
                if (empty($wp_filesystem)) {
                    require_once( ABSPATH . '/wp-admin/includes/file.php' );
                    WP_Filesystem();
                }
                $demo_type = $_POST['demo_type'] ? $_POST['demo_type'] : 'placehold';
                
                if (!empty($url)) {

                    if (file_exists(str_replace('\\', '/', ABSPATH) . 'wp-content/webinane/' . $file)) {
                        unlink(str_replace('\\', '/', ABSPATH) . 'wp-content/webinane/' . $file);
                    }
                    $wp_filesystem->mkdir(str_replace('\\', '/', ABSPATH) . 'wp-content/webinane');

                    $query = array('secretkey' => 'dsfkdkx3232');
                    $zipdata = '';
                    if (function_exists('unload_downloadZip')) {
                        $downloadUrl = add_query_arg($query, $url);
                        unload_downloadZip($downloadUrl);
                    }
                    if (in_array('zip', $ext)) {
                        $zip = new ZipArchive;
                        if ($zip->open(ABSPATH . 'wp-content/webinane/' . $file) === TRUE) {
                            $zip->extractTo(ABSPATH . 'wp-content/webinane/');
                            $zip->close();
                            unlink(ABSPATH . 'wp-content/webinane/' . $file);
                            $message = esc_html__('Download completed! Now importing the demo please be patience...', 'unlaod');
                            $request = true;
                            
                        } else {
                            $message = esc_html__('There is some error to extract Demo File', 'unlaod');
                        $request = false;
                        }
                    } else {
                        $message = esc_html__('Please Enable ZIP Extension in php.ini', 'unlaod');
                    $request = false;
                    }
                    $request = true;
                }
            } else {
               $message = esc_html__('Given URL not present', 'unlaod');
            $request = false;
            }
            echo json_encode(array('next_request' => $request, 'message' => $message, 'data' => "uri=" . esc_js($url) . "&request_number=1&demo_type=" . $demo_type . "&action=unload_importNow"));
            exit;
        }
        static public function unload_importNow() {
        //$h = new unlaod_Helper();
        if (isset($_POST) && $_POST['action'] == 'unload_importNow') {
            $url = ABSPATH . 'wp-content/webinane/demo/';
            $file = 'demo.zip';
            $ext = get_loaded_extensions();
            global $wp_version, $wp_filesystem;
            if (empty($wp_filesystem)) {
                require_once(ABSPATH . '/wp-admin/includes/file.php');
                WP_Filesystem();
            }

            if (!empty($url)) {
                $response_message = $_POST['demo_type'];
                if ($_POST['demo_type'] == 'images') {
                     
                    $dir = ABSPATH . 'wp-content/webinane/demo/images_data/';
                    $demo_type = 'images';
                   
                   
                } else {
                    $dir = ABSPATH . 'wp-content/webinane/demo/placehold_data/';
                    $demo_type = 'placehold';
                }
                if (function_exists('unload_scan_dir'))
                    $total_files = count(array_diff(unload_scan_dir($dir), array('.', '..')));

                else
                    $total_files = 0;
                if ($_POST['request_number'])
                    $file_number = $_POST['request_number'];
                else
                    $file_number = 1;
                $file = ABSPATH . 'wp-content/webinane/demo/' . $_POST['demo_type'] . '_data/data_' . $file_number . '.xml';

                if (file_exists($file)) {
                    define('WP_LOAD_IMPORTERS', true);

                    if (!class_exists('WP_Import')) {
                        include_once( ABSPATH . 'wp-content/plugins/unload/wordpress-importer/wordpress-importer.php');
                    }
                    //print_r('hello'); exit();
                    ob_start();

                    $GLOBALS['wp_import'] = new WP_Import();

                   $GLOBALS['wp_import']->fetch_attachments = true;
                    
                    $GLOBALS['wp_import']->import($file);
                   
                    $message = ob_get_contents();

                    ob_end_clean();

                    $message = $response_message . $message;
                    $request_num = $file_number + 1;
                       

                    if ($file_number == $total_files) {
                        self::unload_ImportSettings();
                        $message .= '<p>' . esc_html__('All done.', 'unlaod') . ' <a href="' . esc_url(admin_url()) . '">' . esc_html__('Have fun!', 'unlaod') . '</a>' . '</p>';
                        $message .= '<p>' . esc_html__('Remember to update the passwords and roles of imported users.', 'unlaod') . '</p>';
                        $message .= sprintf(esc_html__('Awesomeness has beed created %s to enjoy it!', 'unlaod'), '<a target="_blank" href="' . esc_url(home_url('/')) . '">' . esc_html__('click here', 'unlaod') . '</a>');
                        echo json_encode(array('next_request' => false, 'message_type' => true, 'message' => $message));
                    } else {
                        echo json_encode(array('next_request' => true, 'message_type' => false, 'total_request' => $total_files, 'request_number' => $request_num, 'data' => "uri=" . $url . "&demo_type=" . $demo_type . "&message=" . $message . "&request_number=" . $request_num . "&action=unload_importNow"));
                    }
                    exit;
                } else {
                    echo json_encode(array('next_request' => false, 'message_type' => false, 'message' => esc_html__('Sorry The demo could not install properly. Please submit the ticket to our support team', 'unlaod')));
                }
            }
        } else {
            echo json_encode(array('next_request' => false, 'message_type' => false, 'message' => esc_html__('Sorry this demo is not currently available. Please submit your ticket our support team', 'unlaod')));
        }
        exit;
    }

        public function unload_rrmdir($dir) {
             //print_r('there');exit();
            if (is_dir($dir)) {
                $objects = scandir($dir);
                foreach ($objects as $object) {
                    if ($object != "." && $object != "..") {
                        if (filetype($dir . "/" . $object) == "dir") {
                           self::unload_rrmdir($dir . "/" . $object);
                        } else {
                            unlink($dir . "/" . $object);
                        }
                    }
                }
                reset($objects);
                rmdir($dir);
            }
        }

        public function unload_ImportSettings() {
            
            if (function_exists('unload_wpImporterScript')) {
                unload_wpImporterScript();
            }
             
            $importer = new unload_import_export();
            $importer->import();
           
            self::unload_rrmdir(realpath(ABSPATH . 'wp-content/webinane'));
            //if (function_exists('unload_delLogs')) {
               // unload_delLogs();
            //}
        }

    }

    /* class */
}   /* if */
