<?php

if ( !function_exists( 'unload_register_custom_extension_loader' ) ) :

	function unload_register_custom_extension_loader( $ReduxFramework ) {

		$path = Plugin_ROOT . 'panel/redux-extensions/extensions/';
		$folders = scandir( $path, 1 );
		foreach ( $folders as $folder ) {
			if ( $folder === '.' or $folder === '..' or ! is_dir( $path . $folder ) ) {
				continue;
			}
			$extension_class = 'ReduxFramework_Extension_' . $folder;
			if ( !class_exists( $extension_class ) ) {
				// In case you wanted override your override, hah.
				$class_file = $path . $folder . '/extension_' . $folder . '.php';
				$class_file = apply_filters( 'redux/extension/' . $ReduxFramework->args['opt_name'] . '/' . $folder, $class_file );
				if ( $class_file ) {
					require_once( $class_file );
				}
			}
			if ( !isset( $ReduxFramework->extensions[$folder] ) ) {
				$ReduxFramework->extensions[$folder] = new $extension_class( $ReduxFramework );
			}
		}
	}

	// Modify {$reduxunload_OPTname} to match your opt_name
	add_action( "redux/extensions/theme_options/before", 'unload_register_custom_extension_loader' );
endif;