<?php

class unload_ServiceFields
{

    public function __construct()
    {
        add_action('cmb2_init', array($this, 'unload_Register'));
    }

    public function unload_Register()
    {
        $settings = array(
            'id' => 'service_meta',
            'title' => esc_html__('Service Additional Fields', 'unload'),
            'object_types' => array('service'),
            'context' => 'normal',
            'priority' => 'high',
            'show_names' => true,
        );
        $meta = new_cmb2_box($settings);
        $fields = $this->unload_fields();
        (new unload_Helper())->unload_check($fields);
        foreach ($fields as $field) {
            $meta->add_field($field);
        }
    }

    public function unload_fields()
    {
        return array(
            array(
                'name' => esc_html__('Show All Service List', 'unload'),
                'id' => 'metaServiceList',
                'type' => 'checkbox',
            ),
            array(
                'name' => esc_html__('List Title', 'unload'),
                'desc' => esc_html__('Enter side list service title', 'unload'),
                'id' => 'metaListTitle',
                'type' => 'text',
                'attributes' => array(
                    'required' => false,
                    'data-conditional-id' => 'metaServiceList',
                )
            ),
            array(
                'name' => esc_html__('List Sub Title', 'unload'),
                'desc' => esc_html__('Enter side list service sub title', 'unload'),
                'id' => 'metaListSubTitle',
                'type' => 'text',
                'attributes' => array(
                    'required' => false,
                    'data-conditional-id' => 'metaServiceList',
                )
            ),
            array(
                'name' => esc_html__('Company Name', 'unload'),
                'desc' => esc_html__('Enter your company name', 'unload'),
                'id' => 'metacompanyName',
                'type' => 'text',
            ),
            array(
                'name' => esc_html__('Sub Title', 'unload'),
                'desc' => esc_html__('Enter service sub title', 'unload'),
                'id' => 'metaServiceSubTitle',
                'type' => 'text',
            ),
            array(
                'name' => esc_html__('Service Icon', 'unload'),
                'desc' => esc_html__('Select Service Icon', 'unload'),
                'id' => 'metaServiceIcon',
                'type' => 'iconbox',
            ),
            array(
                'name' => esc_html__('Shipping Name', 'unload'),
                'desc' => esc_html__('Enter the shipping name', 'unload'),
                'id' => 'metaShippingName',
                'type' => 'text',
            ),
            array(
                'name' => esc_html__('Short Note', 'unload'),
                'desc' => esc_html__('Enter short note for this service for users', 'unload'),
                'id' => 'metaShortNote',
                'type' => 'textarea_small',
            ),
            array(
                'name' => esc_html__('Delivery Time', 'unload'),
                'desc' => esc_html__('Enter the shipping delivery time', 'unload'),
                'id' => 'metaDeliveryTime',
                'type' => 'text',
            ),
            array(
                'name' => esc_html__('Email ID', 'unload'),
                'desc' => esc_html__('Enter the shipping email id', 'unload'),
                'id' => 'metaEmailId',
                'type' => 'text_email',
            ),
            array(
                'name' => esc_html__('Office Address', 'unload'),
                'desc' => esc_html__('Enter your office address', 'unload'),
                'id' => 'metaOfficeAddress',
                'type' => 'textarea_small',
            ),
            array(
                'name' => esc_html__('Custom URL', 'unload'),
                'desc' => esc_html__('Enter custom url for booking button', 'unload'),
                'id' => 'metacustombookingurl',
                'type' => 'text',
            ),
            array(
                'name' => esc_html__('Satisfied Users', 'unload'),
                'desc' => esc_html__('Enter the number of Satisfied Users, Max Value is 100', 'unload'),
                'id' => 'metaSatisfideUser',
                'type' => 'text_number',
            )
        );
    }

}
