<?php

class unload_RegionFields
{

    public function __construct()
    {
        add_action('cmb2_init', array($this, 'unload_Register'));
    }

    public function unload_Register()
    {
        $settings = array(
            'id' => 'region_meta',
            'title' => esc_html__('Office Detail', 'unload'),
            'object_types' => array('region'),
            'context' => 'normal',
            'priority' => 'high',
            'show_names' => true,
        );
        $meta = new_cmb2_box($settings);
        $fields = $this->unload_fields();
        (new unload_Helper())->unload_check($fields);
        foreach ($fields as $field) {
            $meta->add_field($field);
        }
    }

    public function unload_fields()
    {
        return array(
            array(
                'name' => esc_html__('Description', 'unload'),
                'desc' => esc_html__('Enter the description', 'unload'),
                'id' => 'metaDesc',
                'type' => 'textarea',
            ),
            array(
                'name' => esc_html__('Sub Title', 'unload'),
                'desc' => esc_html__('Enter the sub title for this office', 'unload'),
                'id' => 'metaSubTitle',
                'type' => 'text',
            ),
            array(
                'name' => esc_html__('Office Address', 'unload'),
                'desc' => esc_html__('Enter the office address', 'unload'),
                'id' => 'metaAddress',
                'type' => 'textarea_small',
            ),
            array(
                'name' => esc_html__('Contact No.', 'unload'),
                'desc' => esc_html__('Enter the contact number. Note: for multiple contact number please use | no space ', 'unload'),
                'id' => 'metaContact',
                'type' => 'text',
            ),
            array(
                'name' => esc_html__('Email', 'unload'),
                'desc' => esc_html__('Enter the email id', 'unload'),
                'id' => 'metaEmail',
                'type' => 'text',
            ),
            array(
                'name' => esc_html__('Office Timing', 'unload'),
                'desc' => esc_html__('Enter the Office timing', 'unload'),
                'id' => 'metaTiming',
                'type' => 'text'
            ),
            array(
                'name' => esc_html__('Location', 'unload'),
                'desc' => esc_html__('Enter the location of this event', 'unload'),
                'id' => 'metaLocation',
                'type' => 'pw_map',
                'split_values' => true
            )
        );
    }

}
