<?php

class unload_ProjectFields
{

    public function __construct()
    {
        add_action('cmb2_init', array($this, 'unload_Register'));
    }

    public function unload_Register()
    {
        $settings = array(
            'id' => 'project_meta',
            'title' => esc_html__('Project Additional Fields', 'unload'),
            'object_types' => array('project'),
            'context' => 'normal',
            'priority' => 'high',
            'show_names' => true,
        );
        $meta = new_cmb2_box($settings);
        $fields = $this->unload_fields();
        (new unload_Helper())->unload_check($fields);
        foreach ($fields as $field) {
            $meta->add_field($field);
        }
    }

    public function unload_fields()
    {
        return array(
            array(
                'name' => esc_html__('Content Image', 'unload'),
                'desc' => esc_html__('Upload Project Content Image', 'unload'),
                'id' => 'metaProjectPostImg',
                'type' => 'file',
            ),
            array(
                'name' => esc_html__('Sub Title', 'unload'),
                'desc' => esc_html__('Enter project sub title', 'unload'),
                'id' => 'metaProjectSubTitle',
                'type' => 'text',
            ),
            array(
                'name' => esc_html__('Per Packet', 'unload'),
                'desc' => esc_html__('Enter the amount of per pack', 'unload'),
                'id' => 'metaPerPack',
                'type' => 'text_money',
            ),
            array(
                'name' => esc_html__('Time', 'unload'),
                'desc' => esc_html__('Enter the delivery time example "3 Days"', 'unload'),
                'id' => 'metaDeliveryTime',
                'type' => 'text',
            ),
            array(
                'name' => esc_html__('Date', 'unload'),
                'desc' => esc_html__('Select Delivery Date', 'unload'),
                'id' => 'metaDeliveryDate',
                'type' => 'text_date_timestamp',
            ),
            array(
                'name' => esc_html__('Delivered By', 'unload'),
                'desc' => esc_html__('Enter the name of delivering service', 'unload'),
                'id' => 'metaService',
                'type' => 'text',
            ),
            array(
                'name' => esc_html__('From Address', 'unload'),
                'desc' => esc_html__('Enter the address where package was picked', 'unload'),
                'id' => 'metaFromAddress',
                'type' => 'textarea_small',
            ),
            array(
                'name' => esc_html__('To Address', 'unload'),
                'desc' => esc_html__('Enter the address where package was dropped', 'unload'),
                'id' => 'metatoAddress',
                'type' => 'textarea_small',
            ),
            array(
                'name' => esc_html__('Reference Number', 'unload'),
                'desc' => esc_html__('Enter the reference number', 'unload'),
                'id' => 'metaRefNub',
                'type' => 'text_small',
            )
        );
    }

}
