<?php

class unload_PricetableFields {

	public function __construct() {
		add_action( 'cmb2_init', array( $this, 'unload_Register' ) );
	}

	public function unload_Register() {
		$settings = array(
			'id' => 'ptable_meta',
			'title' => esc_html__( 'Price Table', 'unload' ),
			'object_types' => array( 'price_table' ),
			'context' => 'normal',
			'priority' => 'high',
			'show_names' => true,
		);
		$meta = new_cmb2_box( $settings );
		$fields = $this->unload_fields();
		(new unload_Helper() )->unload_check( $fields );
		foreach ( $fields as $field ) {
			$meta->add_field( $field );
		}
		$this->unload_groupFields( $meta );
	}

	public function unload_fields() {
		return array(
			array(
				'name' => esc_html__( 'Sub Title', 'unload' ),
				'desc' => esc_html__( 'Enter the Sub Title', 'unload' ),
				'id' => 'metaSubTitle',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'Currency', 'unload' ),
				'desc' => esc_html__( 'Enter the currency symbol', 'unload' ),
				'id' => 'metaCurrency',
				'type' => 'text_small',
			),
			array(
				'name' => esc_html__( 'Price', 'unload' ),
				'desc' => esc_html__( 'Enter the price', 'unload' ),
				'id' => 'metaPrice',
				'type' => 'text_money',
			),
			array(
				'name' => esc_html__( 'Image', 'unload' ),
				'id' => 'metaimage',
				'type' => 'file',
				'options' => array(
					'url' => true
				),
				'text' => array(
					'add_upload_file_text' => esc_html__( 'Add File', 'unload' )
				),
			),
			array(
				'name' => esc_html__( 'Background', 'unload' ),
				'id' => 'metaBbimage',
				'type' => 'file',
				'options' => array(
					'url' => true
				),
				'text' => array(
					'add_upload_file_text' => esc_html__( 'Add File', 'unload' )
				),
			),
			array(
				'name' => esc_html__( 'Link', 'unload' ),
				'id' => 'metaLink',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'Button Title', 'unload' ),
				'desc' => esc_html__( 'Enter the Button Title', 'unload' ),
				'id' => 'metaBtnTitle',
				'type' => 'text_small',
			),
		);
	}

	public function unload_groupFields( $meta ) {

		$group_field_id = $meta->add_field( array(
			'id' => 'metaSocialProfiler',
			'type' => 'group',
			'options' => array(
				'group_title' => esc_html__( 'Additional Features {#}', 'unload' ),
				'add_button' => esc_html__( 'Add Another', 'unload' ),
				'remove_button' => esc_html__( 'Remove', 'unload' ),
				'sortable' => true,
				'closed' => true
			),
				) );
		$meta->add_group_field( $group_field_id, array(
			'name' => esc_html__( 'Enter Value', 'unload' ),
			'id' => 'metaTableVal',
			'type' => 'text'
		) );
	}

}
