<?php

class unload_PostFields {

	public function __construct() {
		add_action( 'cmb2_init', array( $this, 'unload_Register' ) );
	}

	public function unload_Register() {
		$settings = array(
			'id' => 'post_meta',
			'title' => esc_html__( 'Additional Fields', 'unload' ),
			'object_types' => array( 'post', 'page', 'service', 'project', 'un_package', 'team', 'event' ),
			'context' => 'normal',
			'priority' => 'high',
			'show_names' => true,
		);
		$meta = new_cmb2_box( $settings );
		$fields = $this->unload_fields();
		(new unload_Helper() )->unload_check( $fields );
		foreach ( $fields as $field ) {
			$meta->add_field( $field );
		}
	}

	public function unload_fields() {
		return array(
			array(
				'name' => esc_html__( 'Header Section', 'unload' ),
				'id' => 'metaHeader',
				'type' => 'checkbox',
			),
			array(
				'name' => esc_html__( 'Header Title', 'unload' ),
				'id' => 'metaHeaderTitle',
				'type' => 'text',
				'attributes' => array(
					'required' => false,
					'data-conditional-id' => 'metaHeader',
				)
			),
			array(
				'name' => esc_html__( 'Header Sub Title', 'unload' ),
				'id' => 'metaHeaderSubTitle',
				'type' => 'text',
				'attributes' => array(
					'required' => false,
					'data-conditional-id' => 'metaHeader',
				)
			),
			array(
				'name' => esc_html__( 'Header Background', 'unload' ),
				'id' => 'metaHeaderBg',
				'type' => 'file',
				'attributes' => array(
					'required' => false,
					'data-conditional-id' => 'metaHeader',
				)
			),
			array(
				'name' => esc_html__( 'Sidebar Layout', 'unload' ),
				'id' => 'metaSidebarLayout',
				'type' => 'radio_img',
				'show_option_none' => false,
				'default' => 'full',
				'options' => array(
					'left' => '<img src="' . unload_Uri . 'app/panel/redux-framework/assets/img/2cl.png" />',
					'right' => '<img src="' . unload_Uri . 'app/panel/redux-framework/assets/img/2cr.png" />',
					'full' => '<img src="' . unload_Uri . 'app/panel/redux-framework/assets/img/theme-option.png" />',
					'none' => '<img src="' . unload_Uri . 'app/panel/redux-framework/assets/img/none.png" />'
				)
			),
			array(
				'name' => esc_html__( 'Select Sidebar', 'unload' ),
				'id' => 'metaSidebar',
				'type' => 'select',
				'options' => (new unload_Helper )->unload_sidebar(),
				'attributes' => array(
					'required' => true,
					'data-conditional-id' => 'metaSidebarLayout',
					'data-conditional-value' => json_encode( array( 'left', 'right' ) )
				)
			),
		);
	}

}
