<?php

function unload_set( $var, $key, $def = '' ) {
	if ( ! $var ) {
		return FALSE;
	}
	if ( is_object( $var ) && isset( $var->$key ) ) {
		return $var->$key;
	} elseif ( is_array( $var ) && isset( $var[ $key ] ) ) {
		return $var[ $key ];
	} elseif ( $def ) {
		return $def;
	} else {
		return FALSE;
	}
}

$page = isset( $_GET[ 'page' ] ) ? $_GET[ 'page' ] : '';
if ( $page != 'themeOptions' ) {
	add_action( 'admin_enqueue_scripts', 'unload_renderExtScripts' );
}

function unload_renderExtScripts() {
	$style = array(
		'ext-fontawesome' => 'https://maxcdn.bootstrapcdn.com/font-awesome/4.6.2/css/font-awesome.min.css',
		'ext-iconbox'     => 'metabox/css/iconbox.css'
	);
	foreach ( $style as $name => $file ) {
		$handle = 'unload-' . $name;
		wp_enqueue_style( $handle, unload_url( $file ), array(), '', 'all' );
	}

	$scripts = array(
		'ext-icon-box-scroll' => 'metabox/js/social_media_scroll.min.js',
		'ext-icon-box-script' => 'metabox/js/scripts.js'
	);
	foreach ( $scripts as $name => $file ) {
		$handle = 'unload-' . $name;
		wp_enqueue_script( $handle, unload_url( $file ), array(), '', 'all' );
	}
}

function unload_url( $url = '' ) {
	if ( strpos( $url, 'http' ) === 0 || strpos( $url, 'https' ) === 0 ) {
		return $url;
	}

	return PLUGIN_URI . ltrim( $url, '/' );
}

function unload_IconBoxIcons() {
	//delete_transient( 'unload_iconbox' );
	if ( FALSE === ( $icons = get_transient( 'unload_iconbox' ) ) ) {
		$pattern = '/\.(fa-(?:\w+(?:-)?)+):before/';
		$subject = wp_remote_get( 'https://maxcdn.bootstrapcdn.com/font-awesome/4.6.2/css/font-awesome.min.css' );
		preg_match_all( $pattern, wp_remote_retrieve_body( $subject ), $matches, PREG_SET_ORDER );
		$icons = array();
		foreach ( $matches as $match ) {
			$icons[] = 'fa ' . $match[ 1 ];
		}
		set_transient( 'unload_iconbox', $icons, 60 * 60 * 24 );
	}

	return $icons;
}

if ( ! function_exists( 'unload_decrypt' ) ) {

	function unload_decrypt( $param ) {
		return base64_decode( $param );
	}

}

if ( ! function_exists( 'unload_encrypt' ) ) {

	function unload_encrypt( $param ) {
		return base64_encode( $param );
	}

}