<?php

/*
  Plugin Name: Unload
  Plugin URI: http://www.webinane.com
  Description: A utitlity plugin for Unload Wordpress Theme
  Author: webinane
  Author URI: http://www.webinane.com
  Version: 1.4
  Text Domain: unload
  License: GPLv2
  License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */
define('Plugin_ROOT', plugin_dir_path(__FILE__));
define('PLUGIN_URI', plugins_url('unload') . '/');
define('CPATH', plugin_dir_path(__FILE__));
define('CURL', plugin_dir_url(__FILE__));


add_action('locale', 'unload_setTextdomain');
function unload_setTextdomain($locale)
{
    include_once(ABSPATH . 'wp-content/themes/unload/app/classes/helper.php');
    $h = new unload_Helper();
        $opt = $h->unload_opt();
        $lang = $h->unload_set($opt, 'optLanguage');
    if (isset($_GET['l'])) {
        return esc_attr($_GET['l']);
    }
    return (!empty($lang)) ? $lang : $locale;

}

load_textdomain('unload', Plugin_ROOT . 'languages/' . get_locale() . '.mo');

include trailingslashit(__DIR__) . '/importer/importer.php';
include_once('customPostType.php');
include_once 'metabox/cmb2-fontawesome/cmb2-fontawesome-picker.php';
include_once 'metabox/cmb_field_map/cmb-field-map.php';

if (class_exists('unload_CPT')) {

    $postTypes = array(
        'service' => array(
            'singular' => esc_html__('Service', 'unload'),
            'plural' => esc_html__('Services', 'unload'),
            'slug' => 'service',
            'icon' => 'dashicons-unload-service',
            'supports' => array('title', 'editor', 'thumbnail', 'comments')
        ),
        'project' => array(
            'singular' => esc_html__('Project', 'unload'),
            'plural' => esc_html__('Projects', 'unload'),
            'slug' => 'project',
            'icon' => 'dashicons-unload-project',
            'supports' => array('title', 'editor', 'thumbnail'),
            'column' => array('comments'),
        ),
        'un_package' => array(
            'singular' => esc_html__('Package', 'unload'),
            'plural' => esc_html__('Packages', 'unload'),
            'slug' => 'un_package',
            'icon' => 'dashicons-unload-package',
            'supports' => array('title', 'editor', 'thumbnail'),
            'column' => array('thumbnail', 'comments'),
        ),
        'event' => array(
            'singular' => esc_html__('Event', 'unload'),
            'plural' => esc_html__('Events', 'unload'),
            'slug' => 'event',
            'icon' => 'dashicons-unload-event',
            'supports' => array('title', 'editor', 'thumbnail', 'comments')
        ),
        'testimonial' => array(
            'singular' => esc_html__('Testimonial', 'unload'),
            'plural' => esc_html__('Testimonials', 'unload'),
            'slug' => 'testimonial',
            'icon' => 'dashicons-unload-testimonial',
            'supports' => array('title', 'editor', 'thumbnail')
        ),
        'team' => array(
            'singular' => esc_html__('Member', 'unload'),
            'plural' => esc_html__('Members', 'unload'),
            'slug' => 'team',
            'icon' => 'dashicons-unload-team',
            'supports' => array('title', 'editor', 'thumbnail')
        ),
        'price_table' => array(
            'singular' => esc_html__('Table', 'unload'),
            'plural' => esc_html__('Tables', 'unload'),
            'slug' => 'price_tables',
            'icon' => 'dashicons-unload-price-table',
            'supports' => array('title')
        ),
        'region' => array(
            'singular' => esc_html__('Region', 'unload'),
            'plural' => esc_html__('Region\'s', 'unload'),
            'slug' => 'package',
            'icon' => 'dashicons-unload-region',
            'supports' => array('title', 'thumbnail'),
            'column' => array('thumbnail', 'comments'),
        ),
        'un_order' => array(
            'singular' => esc_html__('Order', 'unload'),
            'plural' => esc_html__('Order\'s', 'unload'),
            'slug' => 'order',
            'icon' => 'dashicons-unload-order',
            'supports' => array('title'),
            'column' => array('thumbnail'),
        )
    );

    foreach ($postTypes as $name => $value) {
        $postTypeName = '$' . $name;
        $postTypeName = new unload_CPT(array(
            'post_type_name' => $postTypeName,
            'singular' => $value['singular'],
            'plural' => $value['plural'],
            'slug' => $value['slug'],
        ), array(
            'supports' => $value['supports']
        ));

        if (isset($value['icon'])) {
            $postTypeName->menu_icon($value['icon']);
        }

        $tax = (isset($value['taxonomy'])) ? $value['taxonomy']['taxonomy_name'] : 'category';
        $default = array(
            'cb' => '<input type="checkbox" />',
            'thumbnail' => '<span><span title="' . esc_html__('Thumbnail', 'unload') . '" class="dashicons dashicons-format-image"><span class="screen-reader-text">' . esc_html__('Thumbnail', 'unload') . '</span></span></span>',
            'title' => esc_html__('Title', 'unload'),
            'author' => esc_html__('Author', 'unload'),
            $tax => esc_html__('Categories', 'unload'),
            'comments' => '<span><span title="' . esc_html__('Comments', 'unload') . '" class="vers comment-grey-bubble"><span class="screen-reader-text">' . esc_html__('Comments', 'unload') . '</span></span></span>',
            'date' => esc_html__('Date', 'unload')
        );

        if (!isset($value['taxonomy'])) {
            unset($default['category']);
        }

        if (isset($value['column'])) {
            foreach ($value['column'] as $col) {
                if ($col == 'category') {
                    unset($default['category']);
                } else {
                    unset($default[$col]);
                }
            }
        }
        $postTypeName->columns($default);
        if (isset($value['taxonomy'])) {
            $postTypeName->register_taxonomy(array(
                'taxonomy_name' => $value['taxonomy']['taxonomy_name'],
                'singular' => $value['taxonomy']['singular'],
                'plural' => $value['taxonomy']['plural'],
                'slug' => $value['taxonomy']['slug']
            ));
        }
        $postTypeName->populate_column('thumbnail', function ($column, $post) {
            $post_thumbnail_id = get_post_thumbnail_id($post->id);
            if ($post_thumbnail_id) {
                $post_thumbnail_img = wp_get_attachment_image_src($post_thumbnail_id, 'thumbnail');
                echo '<img height="50px" width="50px" src="' . $post_thumbnail_img['0'] . '" />';
            }
        });
    }
    /* ============================= register service post type ============================= */
}

if (file_exists(dirname(__FILE__) . '/metabox/init.php')) {
    require_once dirname(__FILE__) . '/metabox/init.php';
    require_once dirname(__FILE__) . '/metabox/cmb2-conditionals/cmb2-conditionals.php';
}
add_action('admin_enqueue_scripts', 'unlod_enqueue_medias');

function unlod_enqueue_medias()
{
    wp_enqueue_style('cmb2-select', cmb2_utils()->url("css/cmb2-select2.min.css"));
    wp_enqueue_script('cmb2-select', cmb2_utils()->url("js/select2.full.js"), '', '', TRUE);
}

if (!function_exists('unload_shortcode_setup')) {

    function unload_shortcode_setup($param1, $param2)
    {
        add_shortcode($param1, $param2);
    }

}

if (!function_exists('unload_nested_shortcode')) {

    function unload_nested_shortcode($data)
    {
        return eval($data);
    }

}

if (!function_exists('unload_color_scheme')) {

    function unload_color_scheme($data)
    {
        return readfile($data);
    }

}
if (!function_exists('unload_encrypt')) {

    function unload_encrypt($param)
    {
        return base64_encode($param);
    }

}


include_once('functions.php');
add_action('init', 'loadThemeOptions');

function loadThemeOptions()
{
    include_once 'panel/panel-init.php';
}

// start render numbers
add_action('cmb2_render_text_number', 'unload_TextNumber', 10, 5);

function unload_TextNumber($field, $escaped_value, $object_id, $object_type, $field_type_object)
{

    echo $field_type_object->input(array('class' => 'cmb2-text-large', 'type' => 'number'));
}

add_filter('cmb2_sanitize_text_number', 'unload_sanitize_TextNumber', 10, 2);

function unload_sanitize_TextNumber($null, $new)
{
    $new = preg_replace("/[^0-9]/", "", $new);

    return $new;
}

// end render number

// if (!function_exists('unload_downloadZip')) {

//     function unload_downloadZip($source)
//     {
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, $source);
//         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
//         $data = curl_exec($ch);
//         curl_close($ch);

//         $destination = str_replace('\\', '/', ABSPATH) . 'wp-content/webinane/demo.zip';
//         $file = fopen($destination, "w+");
//         fputs($file, $data);
//         fclose($file);
//     }
// }


if ( !function_exists( 'unload_downloadZip' ) ) {

    function unload_downloadZip( $source ) {
         $data = wp_remote_get($source, array( 'timeout' => 500 ) );

        if ( ! is_wp_error ( $data ) ) {
            $destination = str_replace('\\', '/', ABSPATH) . 'wp-content/webinane/demo.zip';
            $file = fopen($destination, "w+");
            fputs($file, $data['body']);
            fclose($file);
        } else {
            wp_send_json( array('next_request' => false, 'message' => esc_html__('There is an error downlaoding the demo content from server', 'unload' ) ) );
        }
    }
}


if (!function_exists('unload_wpImporterScript')) {

    function unload_wpImporterScript()
    {
        return include(__DIR__ . '/import_export.php');
    }
}
if(!function_exists('unload_scan_dir')){
    function unload_scan_dir($dir, $sorting = 0){
        return scandir($dir, $sorting);
    }
}
