function ajaxCall(data) {
    ajax_request = jQuery.ajax({
        dataType: 'json',
        type: "post",
        url: ajaxurl,
        data: data,
    }).done(function (response) {
        if (response.next_request == true) {
            ajaxCall(response.data);
            var progress_split = 100 / response.total_request;
            var progress_value = progress_split * (response.request_number - 1);
            jQuery("#progressbar").progressbar({
                value: progress_value
            });
            jQuery('.download-result').html(parseInt(progress_value) + '% demo imported please be patience to complete the process!');
            jQuery('.download-result').removeClass('alert-success');
            jQuery('.download-result').addClass('alert-info');
        } else if (response.next_request == false) {
            if (response.message_type == false) {
                jQuery('.download-result').html(response.message);
                jQuery('.download-result').removeClass('alert-success');
                jQuery('.download-result').addClass('alert-warning');
                jQuery('.demo-importer').removeAttr("disabled");
            } else {
                jQuery('.download-result').html(response.message);
                jQuery('.download-result').removeClass('alert-info');
                jQuery('.download-result').addClass('alert-success');
                jQuery("#progressbar").progressbar({
                    value: 100
                });
                jQuery('.demo-importer').removeAttr("disabled");
            }
        }
    }).fail(function (error) {
        if (error.status == 504) {
            if (jQuery('.download-result').hasClass('alert-info'))
                jQuery('.download-result').removeClass('alert-info');
            if (jQuery('.download-result').hasClass('alert-success'))
                jQuery('.download-result').removeClass('alert-success');
            jQuery('.download-result').html('<h2>Sorry there was a problem with demo installation!</h2><p>One click importer needs the following specs in php.ini:<br>1- post_max_size = 120M<br>2- upload_max_filesize = 120M<br>3- memory_limit = 128M<br>4- max_execution_time = 300<br>5- max_input_time = 300<br>If you have verified the specifications which are listed above. Please try again! or submit a ticket to our <a href="https://webinane.ticksy.com/">Support Team</a></p>');
            jQuery('.download-result').addClass('alert-warning');
        }
    });
}

jQuery(document).ready(function () {

    jQuery('a#overlay-install-demo, div#install-demo').on('click', function ($) {

        if (jQuery('body').find('div.preloader-wrapper') > 0) {
        } else {
            jQuery('body').prepend('<div class="preloader-wrapper"></div>');
        }
        if (jQuery('.download-result').length != 0)
            jQuery('.download-result').remove();
        if (jQuery('#progressbar').length != 0)
            jQuery('#progressbar').hide();
        jQuery('.preloader-wrapper').show();
    });
    jQuery('.demo-importer').live('click', function () {
        if (!jQuery("input[name='demo_type']:checked").val()) {
            alert('Please select demo content type which you want to import on site!');
            return false;
        }
        var demo_type = jQuery("input[name='demo_type']:checked").val();
        jQuery('.demo-importer').attr("disabled", "disabled");
        jQuery('.preloader-wrapper .box-content').prepend('<p class="download-result alert alert-info">Downloading demo data...</p>');
        var data = 'action=unload_demoImporter&demo_type=' + demo_type;
        ajax_request = jQuery.ajax({
            dataType: 'json',
            type: "post",
            url: ajaxurl,
            data: data,
        }).done(function (response) {

            if (response.next_request == true) {
                jQuery('.download-result').html(response.message);
                jQuery('.download-result').removeClass('alert-info');
                jQuery('.download-result').addClass('alert-success');
                jQuery('#progressbar').show();
                jQuery("#progressbar").progressbar({
                    value: 2,
                    classes: {
                        "ui-progressbar": "highlight"
                    }
                });
                ajaxCall(response.data);
            } else {
                jQuery('.download-result').html(response.message);
                jQuery('.download-result').removeClass('alert-info');
                jQuery('.download-result').addClass('alert-danger');
            }

        }).fail(function (error) {
            if (error.status == 504) {
                if (jQuery('.download-result').hasClass('alert-info'))
                    jQuery('.download-result').removeClass('alert-info');
                if (jQuery('.download-result').hasClass('alert-success'))
                    jQuery('.download-result').removeClass('alert-success');
                jQuery('.download-result').html('<h2>Sorry there was a problem with demo installatopm!</h2><p>One click importer needs the following specs in php.ini:<br>1- post_max_size = 120M<br>2- upload_max_filesize = 120M<br>3- memory_limit = 128M<br>4- max_execution_time = 300<br>5- max_input_time = 300<br>If you have verified the specifications which are listed above. Please submit a ticket to our <a href="https://webinane.ticksy.com/">Support Link</a></p>');
                jQuery('.download-result').addClass('alert-warning');
            }
        });
        return false;
    });
    jQuery('div.importer-box .close').live('click', function ($) {
        jQuery('div.preloader-wrapper').hide();
        if (ajax_request != '') {
            if (ajax_request != null)
                ajax_request.abort();
        }
    });
});