<?php

class unload_un_orderFields {

	public function __construct() {
		add_action( 'cmb2_init', array( $this, 'unload_Register' ) );
	}

	public function unload_Register() {
		$settings = array(
			'id' => 'order_meta',
			'title' => esc_html__( 'Order Info', 'unload' ),
			'object_types' => array( 'un_order' ),
			'context' => 'normal',
			'priority' => 'high',
			'show_names' => true,
		);
		$meta = new_cmb2_box( $settings );
		$fields = $this->unload_fields();
		(new unload_Helper() )->unload_check( $fields );
		foreach ( $fields as $field ) {
			$meta->add_field( $field );
		}
	}

	public function unload_fields() {
		return array(
			array(
				'name' => esc_html__( 'Order Status', 'unload' ),
				'id' => 'metaOrderStatus',
				'type' => 'textarea_small',
			),
			array(
				'name' => esc_html__( 'From Country', 'unload' ),
				'id' => 'metaFromCountry',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'From City', 'unload' ),
				'id' => 'metaFromCity',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'To Country', 'unload' ),
				'id' => 'metaToCountry',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'To City', 'unload' ),
				'id' => 'metaToCity',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'Service', 'unload' ),
				'id' => 'metaService',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'Order Date', 'unload' ),
				'id' => 'metaOrderDate',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'Sender Name', 'unload' ),
				'id' => 'metaSenderName',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'Sender Email', 'unload' ),
				'id' => 'metaSenderEmail',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'Sender Contact', 'unload' ),
				'id' => 'metaSenderContact',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'Sender Address', 'unload' ),
				'id' => 'metaSenderAddress',
				'type' => 'textarea_small',
			),
			array(
				'name' => esc_html__( 'Receiver Name', 'unload' ),
				'id' => 'metaReciverName',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'Receiver Email', 'unload' ),
				'id' => 'metaReciverEmail',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'Receiver Contact', 'unload' ),
				'id' => 'metaReciverContact',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'Receiver Address', 'unload' ),
				'id' => 'metaReciverAddress',
				'type' => 'textarea_small',
			),
			array(
				'name' => esc_html__( 'Order Note', 'unload' ),
				'id' => 'metaOrderNote',
				'type' => 'textarea_small',
			)
		);
	}

}
