<?php

class unload_TeamFields {

	public function __construct() {
		add_action( 'cmb2_init', array( $this, 'unload_Register' ) );
	}

	public function unload_Register() {
		$settings = array(
			'id' => 'team_meta',
			'title' => esc_html__( 'Member Detail', 'unload' ),
			'object_types' => array( 'team' ),
			'context' => 'normal',
			'priority' => 'high',
			'show_names' => true,
		);
		$meta = new_cmb2_box( $settings );
		$fields = $this->unload_fields();
		(new unload_Helper() )->unload_check( $fields );
		foreach ( $fields as $field ) {
			$meta->add_field( $field );
		}
		$this->unload_groupFields( $meta );
	}

	public function unload_fields() {
		return array(
			array(
				'name' => esc_html__( 'Show Office Contact', 'unload' ),
				'id' => 'metaOffice',
				'type' => 'checkbox',
			),
			array(
				'name' => esc_html__( 'Designation', 'unload' ),
				'desc' => esc_html__( 'Enter the member designation', 'unload' ),
				'id' => 'metaDesignation',
				'type' => 'text',
			)
		);
	}

	public function unload_groupFields( $meta ) {

		$group_field_id = $meta->add_field( array(
			'id' => 'metaSocialProfiler',
			'type' => 'group',
			'options' => array(
				'group_title' => esc_html__( 'Social Profile {#}', 'unload' ),
				'add_button' => esc_html__( 'Add Another', 'unload' ),
				'remove_button' => esc_html__( 'Remove', 'unload' ),
				'sortable' => false,
				'closed' => true
			),
				) );
		$meta->add_group_field( $group_field_id, array(
			'name' => esc_html__( 'Select Icon', 'unload' ),
			'id' => 'metaProfileIcon',
			'type' => 'fontawesome_icon'
		) );
		$meta->add_group_field( $group_field_id, array(
			'name' => esc_html__( 'Link', 'unload' ),
			'id' => 'metaProfileLink',
			'type' => 'text_url'
		) );
	}

}
