<?php

class unload_Project2Fields {

	public function __construct() {
		add_action( 'cmb2_init', array( $this, 'unload_Register' ) );
	}

	public function unload_Register() {
		$settings = array(
			'id' => 'project2_meta',
			'title' => esc_html__( 'Project Additional Details', 'unload' ),
			'object_types' => array( 'project' ),
			'context' => 'normal',
			'priority' => 'high',
			'show_names' => true,
		);
		$meta = new_cmb2_box( $settings );
		$fields = $this->unload_fields();
		(new unload_Helper() )->unload_check( $fields );
		foreach ( $fields as $field ) {
			$meta->add_field( $field );
		}
	}

	public function unload_fields() {
		return array(
			array(
				'name' => esc_html__( 'Additional Details', 'unload' ),
				'id' => 'metaPAD',
				'type' => 'checkbox',
			),
			array(
				'name' => esc_html__( 'Title', 'unload' ),
				'desc' => esc_html__( 'Enter the title', 'unload' ),
				'id' => 'metaPADTitle',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'Sub Title', 'unload' ),
				'desc' => esc_html__( 'Enter the sub title', 'unload' ),
				'id' => 'metaPADSubTitle',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'Short Note', 'unload' ),
				'desc' => esc_html__( 'Enter the short note', 'unload' ),
				'id' => 'metaPADShortNote',
				'type' => 'textarea_small',
			),
			array(
				'name' => esc_html__( 'Short Note', 'unload' ),
				'desc' => esc_html__( 'Enter the short note', 'unload' ),
				'id' => 'metaPADShortNote',
				'type' => 'textarea_small',
			),
			array(
				'name' => esc_html__( 'Bottom Content', 'unload' ),
				'desc' => esc_html__( 'Enter the bottom content', 'unload' ),
				'id' => 'metaPADBottomContent',
				'type' => 'wysiwyg',
				'options' => array(
					'wpautop' => true, // use wpautop?
					'media_buttons' => false, // show insert/upload button(s)
					'textarea_name' => 'metaPADBottomContent', // set the textarea name to something different, square brackets [] can be used here
					'textarea_rows' => get_option( 'default_post_edit_rows', 10 ), // rows="..."
					'tabindex' => '',
					'editor_css' => '', // intended for extra styles for both visual and HTML editors buttons, needs to include the style tag can use "scoped".
					'editor_class' => '', // add extra class(es) to the editor textarea
					'teeny' => false, // output the minimal editor config used in Press This
					'dfw' => false, // replace the default fullscreen with DFW (needs specific css)
					'tinymce' => true, // load TinyMCE, can be used to pass settings directly to TinyMCE using an array()
					'quicktags' => true // load Quicktags, can be used to pass settings directly to Quicktags using an array()
				),
			),
			array(
				'name' => esc_html__( 'Key Features', 'unload' ),
				'desc' => esc_html__( 'Enter the key features', 'unload' ),
				'id' => 'metaPADKeyFeatures',
				'type' => 'text',
				'repeatable' => true,
			),
			array(
				'name' => esc_html__( 'Gallery', 'unload' ),
				'id' => 'metaPADGallery',
				'type' => 'file_list',
				'preview_size' => array( 100, 100 ),
				'text' => array(
					'add_upload_files_text' => 'Replacement',
					'remove_image_text' => 'Replacement',
					'file_text' => 'Replacement',
					'file_download_text' => 'Replacement',
					'remove_text' => 'Replacement',
				),
			)
		);
	}

}
