<?php

class unload_PackageFields {

	public function __construct() {
		add_action( 'cmb2_init', array( $this, 'unload_Register' ) );
	}

	public function unload_Register() {
		$settings = array(
			'id'           => 'package_meta',
			'title'        => esc_html__( 'Additional Details', 'unload' ),
			'object_types' => array( 'un_package' ),
			'context'      => 'normal',
			'priority'     => 'high',
			'show_names'   => TRUE,
		);
		$meta     = new_cmb2_box( $settings );
		$fields   = $this->unload_fields();
		( new unload_Helper() )->unload_check( $fields );
		foreach ( $fields as $field ) {
			$meta->add_field( $field );
		}
	}

	public function unload_fields() {
		return array(
			array(
				'name' => esc_html__( 'Select Icon', 'unload' ),
				'desc' => esc_html__( 'Enter icon for this package', 'unload' ),
				'id'   => 'metaIcon',
				'type' => 'iconbox',
			),
			array(
				'name' => esc_html__( 'Sub Title', 'unload' ),
				'desc' => esc_html__( 'Enter the sub title', 'unload' ),
				'id'   => 'metaSubTitle',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'Time', 'unload' ),
				'desc' => esc_html__( 'Enter the delivery time example 3 Days', 'unload' ),
				'id'   => 'metaDeliveryTime',
				'type' => 'text',
			),
			array(
				'name'       => esc_html__( 'Key Features', 'unload' ),
				'desc'       => esc_html__( 'Enter the key features', 'unload' ),
				'id'         => 'metaKeyFeatures',
				'type'       => 'text',
				'repeatable' => TRUE,
			),
			array(
				'name'         => esc_html__( 'Gallery', 'unload' ),
				'id'           => 'metaGallery',
				'type'         => 'file_list',
				'preview_size' => array( 100, 100 ),
				'text'         => array(
					'add_upload_files_text' => 'Replacement',
					'remove_image_text'     => 'Replacement',
					'file_text'             => 'Replacement',
					'file_download_text'    => 'Replacement',
					'remove_text'           => 'Replacement',
				),
			)
		);
	}

}
