<?php

class unload_EventFields {

	public function __construct() {
		add_action( 'cmb2_init', array( $this, 'unload_Register' ) );
	}

	public function unload_Register() {
		$settings = array(
			'id' => 'event_meta',
			'title' => esc_html__( 'Event Detail', 'unload' ),
			'object_types' => array( 'event' ),
			'context' => 'normal',
			'priority' => 'high',
			'show_names' => true,
		);
		$meta = new_cmb2_box( $settings );
		$fields = $this->unload_fields();
		(new unload_Helper() )->unload_check( $fields );
		foreach ( $fields as $field ) {
			$meta->add_field( $field );
		}
	}

	public function unload_fields() {
		return array(
			array(
				'name' => esc_html__( 'Organiser', 'unload' ),
				'desc' => esc_html__( 'Enter the name of event organiser', 'unload' ),
				'id' => 'metaOrganiser',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'Avatar', 'unload' ),
				'desc' => esc_html__( 'Upload avatar of event organiser', 'unload' ),
				'id' => 'metaavatar',
				'type' => 'file',
			),
			array(
				'name' => esc_html__( 'Contact Number', 'unload' ),
				'desc' => esc_html__( 'Enter the contact number of event organiser', 'unload' ),
				'id' => 'metaContact',
				'type' => 'text',
			),
			array(
				'name' => esc_html__( 'Address', 'unload' ),
				'desc' => esc_html__( 'Enter the address of event organiser', 'unload' ),
				'id' => 'metaAddress',
				'type' => 'textarea_small',
			),
			array(
				'name' => esc_html__( 'Start Date', 'unload' ),
				'desc' => esc_html__( 'Select event start date', 'unload' ),
				'id' => 'metaStartDate',
				'type' => 'text_date_timestamp',
				'date_format' => 'd/m/Y',
			),
			array(
				'name' => esc_html__( 'End Date', 'unload' ),
				'desc' => esc_html__( 'Select event end date', 'unload' ),
				'id' => 'metaEndDate',
				'type' => 'text_date_timestamp',
				'date_format' => 'd/m/Y',
			),
			array(
				'name' => esc_html__( 'Location', 'unload' ),
				'desc' => esc_html__( 'Enter the location of this event', 'unload' ),
				'id' => 'metaLocation',
				'type' => 'pw_map',
				'split_values' => true
			)
		);
	}

}
