<?php
/**
 * Plugin Name:     Unik Plugin
 * Plugin URI:      https://themeforest.net/user/wpmines/
 * Description:     The plugin supports the Unik WordPress theme
 * Author:          Wpmines
 * Author URI:      https://themeforest.net/user/wpmines/
 * Text Domain:     unik-plugin
 * Domain Path:     /languages
 * Version:         0.1.0
 *
 * @package         Unik_Plugin
 */


defined( 'UNIK_PLUGIN_PATH' ) || define( 'UNIK_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );


require_once UNIK_PLUGIN_PATH . 'post-types/portfolio.php';
require_once UNIK_PLUGIN_PATH . 'post-types/weblusive_slider.php';

add_action( 'unik_theme_loaded', 'unik_theme_loaded' );
add_action( 'unik_radium_theme_importer', 'unik_radium_theme_importer' );
add_filter( 'unik_demo_files_path', 'unik_demo_files_path' );

function unik_theme_loaded() {


	require_once UNIK_PLUGIN_PATH . 'post-options.php';

	require_once (UNIK_PLUGIN_PATH . 'library/includes/the_breadcrumb.php');

	require_once (UNIK_PLUGIN_PATH . 'library/includes/OAuth.php');
	require_once (UNIK_PLUGIN_PATH . 'library/includes/twitteroauth.php');
	require_once (UNIK_PLUGIN_PATH . 'library/includes/portfolio_walker.php');

}


function unik_radium_theme_importer() {
	
	require_once (UNIK_PLUGIN_PATH . 'importer/radium-importer.php');
}

function unik_demo_files_path( $path ) {
	return UNIK_PLUGIN_PATH . 'importer/demo-files/';
}

if ( ! function_exists( 'unik_baseencode' ) ) {

	function unik_baseencode( $data ) {
		return base64_encode( $data );
	}
}

if ( ! function_exists( 'unik_basedecode' ) ) {

	function unik_basedecode( $data ) {
		return base64_encode( $data );
	}
}


if ( ! function_exists( 'unik_shortcode' ) ) {

	function unik_shortcode( $tag, $func ) {
		add_shortcode( $tag, $func );
	}
}


/********** GET PAGES BY PARAMS ************/

if ( ! function_exists( 'get_root_page' ) ) {
	/*-- Get root parent of a page --*/
	function get_root_page($page_id) 
	{
		global $wpdb;
		
		$parent = $wpdb->get_var("SELECT post_parent FROM $wpdb->posts WHERE post_type='page' AND ID = '$page_id'");
		
		if ($parent == 0) 
			return $page_id;
		else 
			return get_root_page($parent);
	}
}

if ( function_exists( 'get_page_name_by_ID' ) ) {
	/*-- Get page name by ID --*/
	function get_page_name_by_ID($page_id)
	{
		global $wpdb;
		$page_name = $wpdb->get_var("SELECT post_title FROM $wpdb->posts WHERE ID = '$page_id'");
		return $page_name;
	}
}

if ( ! function_exists( 'get_page_ID_by_page_template' ) ) {
	/*-- Get page ID by Page Template --*/
	function get_page_ID_by_page_template($template_name)
	{
		global $wpdb;
		$page_ID = $wpdb->get_var("SELECT post_id FROM $wpdb->postmeta WHERE meta_value = '$template_name' AND meta_key = '_wp_page_template'");
		return $page_ID;
	}
}

/*-- Get page content (Used for pages with custom post types) --*/
if(!function_exists('getPageContent'))
{
	function getPageContent($pageId)
	{
		if(!is_numeric($pageId))
		{
			return;
		}
		global $wpdb;
		$sql_query = 'SELECT DISTINCT * FROM ' . $wpdb->posts .
		' WHERE ' . $wpdb->posts . '.ID=' . $pageId;
		$posts = $wpdb->get_results($sql_query);
		if(!empty($posts))
		{
			foreach($posts as $post)
			{
				return nl2br($post->post_content);
			}
		}
	}
}

if ( ! function_exists( 'get_page_ID_by_custom_field_value' ) ) {
	/* -- Get page ID by Custom Field Value -- */
	function get_page_ID_by_custom_field_value($custom_field, $value)
	{
		global $wpdb;
		$page_ID = $wpdb->get_var("
		    SELECT wposts.ID
	    	FROM $wpdb->posts wposts, $wpdb->postmeta wpostmeta
		    WHERE wposts.ID = wpostmeta.post_id 
	    	AND wpostmeta.meta_key = '$custom_field' 
		    AND (wpostmeta.meta_value like '$value,%' OR wpostmeta.meta_value like '%,$value,%' OR wpostmeta.meta_value like '%,$value' OR wpostmeta.meta_value = '$value')		
	    	AND wposts.post_status = 'publish' 
		    AND wposts.post_type = 'page'
			LIMIT 0, 1");

		return $page_ID;
	}
}

function unik_plugin_get_related( $post, $limit, $tagslist ) {

	global $wpdb;

	// Do the query
	$q = "
		SELECT p.*, count(tr.object_id) as count
		FROM $wpdb->term_taxonomy AS tt, $wpdb->term_relationships AS tr, $wpdb->posts AS p
		WHERE tt.taxonomy ='post_tag'
			AND tt.term_taxonomy_id = tr.term_taxonomy_id
			AND tr.object_id  = p.ID
			AND tt.term_id IN ($tagslist)
			AND p.ID != $post->ID
			AND p.post_status = 'publish'
			AND p.post_date_gmt < NOW()
		GROUP BY tr.object_id
		ORDER BY count DESC, p.post_date_gmt DESC
		LIMIT $limit;";

	$related = $wpdb->get_results($q);

	return $related;
}


function unik_plugin_total_posts_Widget_query() {
	global $wpdb;

	$sql = "SELECT DISTINCT ID, post_title, post_password, comment_ID, comment_post_ID, comment_author, comment_author_email, comment_date_gmt, comment_approved, comment_type, comment_author_url, SUBSTRING(comment_content,1,70) AS com_excerpt FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID = $wpdb->posts.ID) WHERE comment_approved = '1' AND comment_type = '' AND post_password = '' ORDER BY comment_date_gmt DESC LIMIT 5";
	$comments = $wpdb->get_results($sql);

	return $comments;
}


if ( ! function_exists('unik_email' ) ) {

	function unik_email( $mailTo, $mailFromSubject, $msg, $headers = '' ) {

		wp_mail( $mailTo, $mailFromSubject, $msg, $headers );
	}
}

add_action( 'unik_process_form', 'unik_email', 10, 4 );

function unik_plugin_admin_menu() {


}

add_action( 'admin_menu', 'unik_plugin_admin_menu', 20 );