<?php

function weblusive_slider_init() {
	register_post_type( 'weblusive_slider', array(
		'labels'            => array(
			'name'                => __( 'Sliders', 'uniq-plugin' ),
			'singular_name'       => __( 'Slider', 'uniq-plugin' ),
			'all_items'           => __( 'All Sliders', 'uniq-plugin' ),
			'new_item'            => __( 'New Slider', 'uniq-plugin' ),
			'add_new'             => __( 'Add New', 'uniq-plugin' ),
			'add_new_item'        => __( 'Add New Slider', 'uniq-plugin' ),
			'edit_item'           => __( 'Edit Slider', 'uniq-plugin' ),
			'view_item'           => __( 'View Slider', 'uniq-plugin' ),
			'search_items'        => __( 'Search Sliders', 'uniq-plugin' ),
			'not_found'           => __( 'No Sliders found', 'uniq-plugin' ),
			'not_found_in_trash'  => __( 'No Sliders found in trash', 'uniq-plugin' ),
			'parent_item_colon'   => __( 'Parent Slider', 'uniq-plugin' ),
			'menu_name'           => __( 'Sliders', 'uniq-plugin' ),
		),
		'public'            => false,
		'hierarchical'      => false,
		'show_ui'           => true,
		'show_in_nav_menus' => true,
		'supports'          => array( 'title', 'thumbnail' ),
		'has_archive'       => true,
		'rewrite'           => true,
		'query_var'         => true,
		'menu_icon'         => 'dashicons-format-gallery',
		'show_in_rest'      => true,
		'rest_base'         => 'weblusive_slider',
		'rest_controller_class' => 'WP_REST_Posts_Controller',
	) );

}
add_action( 'init', 'weblusive_slider_init' );

function weblusive_slider_updated_messages( $messages ) {
	global $post;

	$permalink = get_permalink( $post );

	$messages['weblusive_slider'] = array(
		0 => '', // Unused. Messages start at index 1.
		1 => sprintf( __('Slider updated. <a target="_blank" href="%s">View Slider</a>', 'uniq-plugin'), esc_url( $permalink ) ),
		2 => __('Custom field updated.', 'uniq-plugin'),
		3 => __('Custom field deleted.', 'uniq-plugin'),
		4 => __('Slider updated.', 'uniq-plugin'),
		/* translators: %s: date and time of the revision */
		5 => isset($_GET['revision']) ? sprintf( __('Slider restored to revision from %s', 'uniq-plugin'), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
		6 => sprintf( __('Slider published. <a href="%s">View Slider</a>', 'uniq-plugin'), esc_url( $permalink ) ),
		7 => __('Slider saved.', 'uniq-plugin'),
		8 => sprintf( __('Slider submitted. <a target="_blank" href="%s">Preview Slider</a>', 'uniq-plugin'), esc_url( add_query_arg( 'preview', 'true', $permalink ) ) ),
		9 => sprintf( __('Slider scheduled for: <strong>%1$s</strong>. <a target="_blank" href="%2$s">Preview Slider</a>', 'uniq-plugin'),
		// translators: Publish box date format, see http://php.net/date
		date_i18n( __( 'M j, Y @ G:i' ), strtotime( $post->post_date ) ), esc_url( $permalink ) ),
		10 => sprintf( __('Slider draft updated. <a target="_blank" href="%s">Preview Slider</a>', 'uniq-plugin'), esc_url( add_query_arg( 'preview', 'true', $permalink ) ) ),
	);

	return $messages;
}
add_filter( 'post_updated_messages', 'weblusive_slider_updated_messages' );


add_action("admin_init", "weblusive_slider_admin_init");
 
function weblusive_slider_admin_init(){
  add_meta_box("weblusive_slider_slides", "Slides", "weblusive_slider_slides", "weblusive_slider", "normal", "high");
}
 

function weblusive_slider_slides(){
	global $post;
	$custom = get_post_custom($post->ID);
	
	$slider = (isset ($custom["custom_slider"]) && (!is_array($custom["custom_slider"][0]))) ? unserialize( $custom["custom_slider"][0]) : '';
	$interval = isset ($custom["custom_slider_interval"]) ? ( $custom["custom_slider_interval"][0]) : '3000';
	
	wp_enqueue_script( 'weblusive-admin-slider' );  
	wp_print_scripts('media-upload');
	wp_enqueue_script('thickbox');
	wp_enqueue_style('thickbox');
		
  ?>

  <input id="upload_add_slide" type="button" class="mpanel-save" value="Add New Slide">

	<ul id="weblusive-slider-items">
	<li>
		<div class="widget-content option-item">
			<label for="interval">Sliding interval (in milliseconds)</label>
			<input id="interval" name="custom_slider_interval" value="<?php echo isset($interval) ? $interval : '5000';?>" />
		</div>
	</li>
	<?php
	if( $slider ){
	$i=0;
	foreach( $slider as $slide ):
		$i++; ?>
		<li id="listItem_<?php echo $i ?>"  class="ui-state-default zebra-table">
			<div class="widget-content option-item">
				<p class="hint-title">Main parameters</p>
				<div class="slider-img"><?php echo wp_get_attachment_image( $slide['id'] , 'thumbnail' );  ?></div>
				<label for="custom_slider[<?php echo $i ?>][caption]"><span style="float:left" >Slide text :</span><textarea name="custom_slider[<?php echo $i ?>][caption]" id="custom_slider[<?php echo $i ?>][caption]"><?php echo stripslashes($slide['caption']) ; ?></textarea></label>
				<label for="custom_slider[<?php echo $i ?>][link]">
					<span style="float:left" >Slide URL (Optional) :</span>
					<input type="text" name="custom_slider[<?php echo $i ?>][link]" id="custom_slider[<?php echo $i ?>][link]" value="<?php echo isset($slide['link']) ? stripslashes($slide['link']) : ''; ?>" />
				</label>
				<input id="custom_slider[<?php echo $i ?>][id]" name="custom_slider[<?php echo $i ?>][id]" value="<?php  echo $slide['id']  ?>" type="hidden" />
				<a class="del-cat"></a>
			</div>
		</li>
	<?php endforeach; 
	}else{
		echo ' <p> Use the button above to add slides.</p>';
	}?>
	</ul>
	<?php if( $slider ):?><script> var mynextCell = <?php echo $i+1 ?> ;</script><?php endif?>

  <script>
  jQuery(document).ready(function() {
  	
  	var mynextCell = ( $('#weblusive-slider-items li.ui-state-default').length ) ? $('#weblusive-slider-items li.ui-state-default').length + 1 : 0;

	jQuery(function() {
		jQuery( "#weblusive-slider-items" ).sortable({placeholder: "ui-state-highlight"});
	});

	console.log(mynextCell);
	var options = {};
	var settings = $.extend({
            
        target : '.smartcat-uploader', // The class wrapping the textbox
        uploaderTitle : 'Select or upload image', // The title of the media upload popup
        uploaderButton : 'Set image', // the text of the button in the media upload popup
        multiple : true, // Allow the user to select multiple images
        buttonText : 'Upload image', // The text of the upload button
        buttonClass : '.smartcat-upload', // the class of the upload button
        previewSize : '150px', // The preview image size
        modal : false, // is the upload button within a bootstrap modal ?
        buttonStyle : { // style the button
            color : '#fff',
            background : '#3bafda',
            fontSize : '16px',                
            padding : '10px 15px',                
        },
        
    }, options );

	function custom_slider_uploader( field ) {
		$('body').on('click', "#upload_"+field, function(e) {
            
            e.preventDefault();
            var selector = $(this).parent( settings.target );

            if (settings.counter === undefined) {
	            settings.counter = mynextCell;
	        }
            var custom_uploader = wp.media({
                title: settings.uploaderTitle,
                button: {
                    text: settings.uploaderButton
                },
                multiple: settings.multiple
            })
            .on('select', function() {

                var attachments = custom_uploader.state().get('selection').toJSON();
				
     			if (mynextCell === undefined) {
     				var mynextCell = settings.counter;
     			}

     			$.each( attachments, function( ind, el ) {     

     				var imgurl = el.url,
     				id = el.id;
     				console.log(mynextCell);
                	jQuery('#weblusive-slider-items').append('<li id="listItem_'+ mynextCell +'" class="ui-state-default"><div class="widget-content option-item"><p class="hint-title">Main parameters</p><div class="slider-img"><img src="'+imgurl+'" alt=""></div><label for="custom_slider['+ mynextCell +'][caption]"><span style="float:left" >Slide Caption :</span><textarea name="custom_slider['+ mynextCell +'][caption]" id="custom_slider['+ mynextCell +'][caption]"></textarea></label><input id="custom_slider['+ mynextCell +'][id]" name="custom_slider['+ mynextCell +'][id]" value="'+id+'" type="hidden" /><a class="del-cat"></a></div></li>');
					
                	mynextCell ++ ;
                	settings.counter++;                	
                });

                jQuery( "#weblusive-slider-items" ).sortable({placeholder: "ui-state-highlight"});
            })
            .open();
        });
	}
	
	
	custom_slider_uploader("add_slide");
	
});

  </script>
  
 
  <?php
}
 


add_action('save_post', 'save_slide');
function save_slide(){
  global $post;
  
  	if( isset($_POST['custom_slider']) && $_POST['custom_slider'] != "" ){
		update_post_meta($post->ID, 'custom_slider' , $_POST['custom_slider']);		
	}
	else{ 
		if (isset($post->ID))
		delete_post_meta($post->ID, 'custom_slider' );
	}
	if( isset($_POST['custom_slider_interval']) && $_POST['custom_slider_interval'] != "" ){
		update_post_meta($post->ID, 'custom_slider_interval' , $_POST['custom_slider_interval']);		
	}
	else{ 
		if (isset($post->ID))
		delete_post_meta($post->ID, 'custom_slider_interval' );
	}
}


add_filter("manage_edit-weblusive_slider_columns", "weblusive_slider_edit_columns");
function weblusive_slider_edit_columns($columns){
  $columns = array(
    "cb" => "<input type=\"checkbox\" />",
    "title" => "Title",
	"slides" => "Number of Slides",
    "date" => "Date",
  );
 
  return $columns;
}


add_action("manage_weblusive_slider_posts_custom_column",  "weblusive_slider_custom_columns");
function weblusive_slider_custom_columns($column){
	global $post;
	
	switch ($column) {
		case "slides":
			$custom_slider_args = array( 'post_type' => 'weblusive_slider', 'p' => $post->ID );
			$custom_slider = new WP_Query( $custom_slider_args );
			if( $custom_slider->have_posts()){
				while ( $custom_slider->have_posts() ) {
					$number =0;
					$custom_slider->the_post();
					$custom = get_post_custom($post->ID);
					if (!is_array($custom["custom_slider"][0])) {
						if( !empty($custom["custom_slider"][0])){
							$slider = unserialize( $custom["custom_slider"][0] );
							echo $number = count($slider);
						}
					}
					else echo 0;
				}
			}
		break;
	}
}
