<?php

function unik_portfolio_init() {
	register_post_type( 'portfolio', array(
		'labels'            => array(
			'name'                => __( 'Portfolios', 'uniq-plugin' ),
			'singular_name'       => __( 'Portfolio', 'uniq-plugin' ),
			'all_items'           => __( 'All Portfolios', 'uniq-plugin' ),
			'new_item'            => __( 'New Portfolio', 'uniq-plugin' ),
			'add_new'             => __( 'Add New', 'uniq-plugin' ),
			'add_new_item'        => __( 'Add New Portfolio', 'uniq-plugin' ),
			'edit_item'           => __( 'Edit Portfolio', 'uniq-plugin' ),
			'view_item'           => __( 'View Portfolio', 'uniq-plugin' ),
			'search_items'        => __( 'Search Portfolios', 'uniq-plugin' ),
			'not_found'           => __( 'No Portfolios found', 'uniq-plugin' ),
			'not_found_in_trash'  => __( 'No Portfolios found in trash', 'uniq-plugin' ),
			'parent_item_colon'   => __( 'Parent Portfolio', 'uniq-plugin' ),
			'menu_name'           => __( 'Portfolios', 'uniq-plugin' ),
		),
		'public'            => true,
		'hierarchical'      => false,
		'show_ui'           => true,
		'show_in_nav_menus' => true,
		'supports'          => array( 'title', 'editor', 'thumbnail' ),
		'has_archive'       => true,
		'rewrite'           => true,
		'query_var'         => true,
		'menu_icon'         => 'dashicons-welcome-view-site',
		'show_in_rest'      => true,
		'rest_base'         => 'portfolio',
		'rest_controller_class' => 'WP_REST_Posts_Controller',
	) );


	register_taxonomy( 'portfolio_category', 
			'portfolio', 
			array( 'hierarchical' => true, 
					'label' => __('Categories', 'unik'),
					'singular_label' => __('Category', 'unik'), 
					'public' => true,
						'show_tagcloud' => false,
					'query_var' => 'true',
 					'rewrite' => array('slug' => 'portfolio_category' , 'with_front' => false)
			)
		);  


	add_filter('manage_edit-portfolio_columns', 'unik_portfolio_edit_columns');
	add_action('manage_posts_custom_column',  'unik_portfolio_custom_columns');

}
add_action( 'init', 'unik_portfolio_init' );

function unik_portfolio_updated_messages( $messages ) {
	global $post;

	$permalink = get_permalink( $post );

	$messages['portfolio'] = array(
		0 => '', // Unused. Messages start at index 1.
		1 => sprintf( __('Portfolio updated. <a target="_blank" href="%s">View Portfolio</a>', 'uniq-plugin'), esc_url( $permalink ) ),
		2 => __('Custom field updated.', 'uniq-plugin'),
		3 => __('Custom field deleted.', 'uniq-plugin'),
		4 => __('Portfolio updated.', 'uniq-plugin'),
		/* translators: %s: date and time of the revision */
		5 => isset($_GET['revision']) ? sprintf( __('Portfolio restored to revision from %s', 'uniq-plugin'), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
		6 => sprintf( __('Portfolio published. <a href="%s">View Portfolio</a>', 'uniq-plugin'), esc_url( $permalink ) ),
		7 => __('Portfolio saved.', 'uniq-plugin'),
		8 => sprintf( __('Portfolio submitted. <a target="_blank" href="%s">Preview Portfolio</a>', 'uniq-plugin'), esc_url( add_query_arg( 'preview', 'true', $permalink ) ) ),
		9 => sprintf( __('Portfolio scheduled for: <strong>%1$s</strong>. <a target="_blank" href="%2$s">Preview Portfolio</a>', 'uniq-plugin'),
		// translators: Publish box date format, see http://php.net/date
		date_i18n( __( 'M j, Y @ G:i' ), strtotime( $post->post_date ) ), esc_url( $permalink ) ),
		10 => sprintf( __('Portfolio draft updated. <a target="_blank" href="%s">Preview Portfolio</a>', 'uniq-plugin'), esc_url( add_query_arg( 'preview', 'true', $permalink ) ) ),
	);

	return $messages;
}
add_filter( 'post_updated_messages', 'unik_portfolio_updated_messages' );


function unik_portfolio_edit_columns($columns){
	$columns = array(
		'cb' => '<input type="checkbox" />',
		'title' => 'Title',
		'portfolio_category' => 'Category',
		'portfolio_description' => 'Description',
		'portfolio_image' => 'Image Preview'
	);

	return $columns;
}

function unik_portfolio_custom_columns($column){
	global $post;
	switch ($column)
	{
		case "portfolio_category":  
			echo get_the_term_list($post->ID, 'portfolio_category', '', ', ','');  
			break;  

		case 'portfolio_description':
			the_excerpt();  
			break;  

		case 'portfolio_image':
			the_post_thumbnail( 'blog-thumb' );
			break;
	}
}




add_action( 'admin_menu', 'register_portfolio_menu' );

function register_portfolio_menu() {
	add_submenu_page(
		'edit.php?post_type=portfolio',
		'Order portfolio',
		'Sort items',
		'edit_pages', 'portfolio-order',
		'portfolio_order_page'
	);
}


function portfolio_order_page() 
{
	?></pre>
	<div class="wrap">
        <h2>Sort Items</h2>
        Simply drag the items up or down and they will be saved in that order.
        
        <?php $slides = new WP_Query( array( 'post_type' => 'portfolio', 'posts_per_page' => -1, 'order' => 'ASC', 'orderby' => 'menu_order' ) ); ?>
        <table id="sortable-table-portfolio" class="wp-list-table widefat fixed posts">
            <thead>
                <tr>
                    <th class="column-order">Order</th>
                    <th class="column-title">Title</th>
                    <th class="column-thumbnail">Thumbnail</th>
         
                </tr>
            </thead>
            <tbody data-post-type="portfolio"><!--?php while( $products--->
				<?php if( $slides->have_posts() )  : ?>
                    <?php while ($slides->have_posts()): $slides->the_post(); ?>
                        <tr id="post-<?php the_ID(); ?>">
                            <td class="column-order"><img title="" src="<?php echo get_stylesheet_directory_uri() . '/images/move-icon.png'; ?>" alt="Move Icon" width="32" height="32" /></td>
                            <td class="column-title"><strong><?php the_title(); ?></strong></td>
                    		<td class="column-thumbnail"><?php the_post_thumbnail( 'blog-thumb' ); ?></td>
                         </tr>
                    <?php endwhile; ?>
                <?php else : ?>        
                    No portfolio items found, make sure you <a href="post-new.php?post_type=portfolio">create one</a>.
                <?php endif; ?>
                <?php wp_reset_postdata(); ?>	
            </tbody>
            <tfoot>
                <tr>
                    <th class="column-order">Order</th>
                    <th class="column-title">Title</th>
                    <th class="column-thumbnail">Thumbnail</th>
                </tr>
            </tfoot>
        </table>
 	</div>
	<pre>
	<!-- .wrap -->	
	<?php 
}
