<?php
/**
 * Install functions.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'Uncode_Install' ) ) :

/**
 * Uncode_Install Class
 */
class Uncode_Install {

	/**
	 * Init functions.
	 */
	public static function init() {
		add_action( 'after_setup_theme', array( __CLASS__, 'insert_theme_options' ) );
		add_action( 'woocommerce_installed', array( __CLASS__, 'regenerate_dynamic_css_on_wc_activation' ) );
	}

	/**
	 * Insert default theme options when installing Uncode.
	 */
	public static function insert_theme_options() {
		$current_options = get_option( ot_options_id() );

		if ( ! $current_options || ! is_array( $current_options ) ) {
			$default_theme_options = array (
				'_uncode_logo_switch' => 'off',
				'_uncode_logo' => '',
				'_uncode_logo_light' => '',
				'_uncode_logo_dark' => '',
				'_uncode_logo_mobile_switch' => 'off',
				'_uncode_logo_mobile' => '',
				'_uncode_logo_mobile_light' => '',
				'_uncode_logo_mobile_dark' => '',
				'_uncode_logo_height' => '20',
				'_uncode_logo_height_mobile' => '',
				'_uncode_headers' => 'hmenu-right',
				'_uncode_hmenu_position' => 'left',
				'_uncode_vmenu_position' => 'left',
				'_uncode_vmenu_v_position' => 'middle',
				'_uncode_vmenu_align' => 'left',
				'_uncode_vmenu_width' => '252',
				'_uncode_menu_accordion_active' => 'off',
				'_uncode_menu_full' => 'off',
				'_uncode_offcanvas_overlay' => 'off',
				'_uncode_submenu_style' => '',
				'_uncode_menu_shadows' => 'on',
				'_uncode_submenu_shadows' => '',
				'_uncode_submenu_darker_shadows' => 'off',
				'_uncode_menu_borders' => 'on',
				'_uncode_menu_no_arrows' => 'off',
				'_uncode_menu_desktop_transparency' => 'off',
				'_uncode_menu_mobile_transparency' => 'off',
				'_uncode_menu_custom_padding' => 'off',
				'_uncode_menu_custom_padding_desktop' => '27',
				'_uncode_menu_custom_padding_mobile' => '27',
				'_uncode_menu_custom_lateral_padding' => '36',
				'_uncode_menu_side_to_side' => 'off',
				'_uncode_menu_focus' => 'off',
				'_uncode_overlay_menu_bg' => 'off',
				'_uncode_overlay_menu_bg_opacity' => '95',
				'_uncode_menu_sticky' => 'off',
				'_uncode_menu_sticky_mobile' => 'off',
				'_uncode_menu_mobile_centered' => 'off',
				'_uncode_menu_hide' => 'off',
				'_uncode_menu_hide_mobile' => 'off',
				'_uncode_menu_shrink' => 'off',
				'_uncode_min_logo' => '',
				'_uncode_menu_li_animation' => 'off',
				'_uncode_menu_mobile_animation' => 'none',
				'_uncode_menu_overlay_animation' => 'sequential',
				'_uncode_menu_no_secondary' => 'off',
				'_uncode_secondary_padding' => 'on',
				'_uncode_menu_no_cta' => 'on',
				'_uncode_menu_socials' => 'off',
				'_uncode_menu_search' => 'on',
				'_uncode_menu_search_desktop' => 'off',
				'_uncode_menu_search_animation' => 'sequential',
				'_uncode_menu_search_type' => 'default',
				'_uncode_woocommerce_cart' => 'on',
				'_uncode_woocommerce_cart_desktop' => 'off',
				'_uncode_woocommerce_cart_icon' => 'fa fa-bag',
				'_uncode_login_account' => 'off',
				'_uncode_login_account_desktop' => 'off',
				'_uncode_login_account_icon' => 'fa fa-user-o',
				'_uncode_woocommerce_cart_mobile' => 'off',
				'_uncode_menu_bloginfo' => '',
				'_uncode_main_width' => array (
					0 => '1200',
					1 => 'px',
				),
				'_uncode_main_align' => 'center',
				'_uncode_boxed' => 'off',
				'_uncode_body_border' => '0',
				'_uncode_progressive_blur' => '',
				'_uncode_progressive_blur_h' => '25vh',
				'_uncode_progressive_blur_val' => 20,
				'_uncode_body_border_color' => '',
				'_uncode_header_full' => 'on',
				'_uncode_body_full' => 'off',
				'_uncode_footer_full' => 'off',
				'_uncode_footer_block' => '',
				'_uncode_copy_hide' => 'off',
				'_uncode_footer_copyright' => 'on',
				'_uncode_footer_text' => '',
				'_uncode_footer_position' => 'left',
				'_uncode_footer_uparrow' => 'on',
				'_uncode_footer_uparrow_mobile' => 'on',
				'_uncode_footer_uparrow_style' => 'default',
				'_uncode_post_menu' => '',
				'_uncode_post_menu_width' => '',
				'_uncode_post_menu_opaque' => 'off',
				'_uncode_post_header' => 'header_basic',
				'_uncode_post_blocks' => '',
				'_uncode_post_header_width' => '',
				'_uncode_post_header_height' => array (
					0 => '60',
					1 => '%',
				),
				'_uncode_post_header_min_height' => '300',
				'_uncode_post_header_title' => 'on',
				'_uncode_post_header_style' => 'light',
				'_uncode_post_header_content_width' => 'off',
				'_uncode_post_header_custom_width' => '100',
				'_uncode_post_header_align' => 'center',
				'_uncode_post_header_position' => 'header-center header-middle',
				'_uncode_post_header_title_font' => 'font-555555',
				'_uncode_post_header_title_size' => 'h1',
				'_uncode_post_header_title_height' => '',
				'_uncode_post_header_title_spacing' => '',
				'_uncode_post_header_title_weight' => '',
				'_uncode_post_header_title_transform' => '',
				'_uncode_post_header_title_italic' => 'off',
				'_uncode_post_header_text_animation' => '',
				'_uncode_post_header_animation_speed' => '',
				'_uncode_post_header_animation_delay' => '',
				'_uncode_post_header_featured' => 'on',
				'_uncode_post_header_background' => array (
					'background-color' => 'color-gyho',
					'background-attachment' => '',
					'background-position' => '',
					'background-size' => '',
					'background-image' => '',
				),
				'_uncode_post_header_parallax' => 'off',
				'_uncode_post_header_kburns' => '',
				'_uncode_post_header_overlay_color' => '',
				'_uncode_post_header_overlay_color_alpha' => '100',
				'_uncode_post_header_scroll_opacity' => 'off',
				'_uncode_post_header_scrolldown' => 'off',
				'_uncode_post_menu_no_padding' => 'off',
				'_uncode_post_menu_no_padding_mobile' => 'off',
				'_uncode_post_select_content' => '',
				'_uncode_post_content_block' => '',
				'_uncode_post_layout_width' => '',
				'_uncode_post_layout_width_custom' => array (
					0 => '',
					1 => 'px',
				),
				'_uncode_post_breadcrumb' => 'off',
				'_uncode_post_breadcrumb_align' => '',
				'_uncode_post_title' => 'off',
				'_uncode_post_media' => 'on',
				'_uncode_post_featured_media_display' => 'carousel',
				'_uncode_post_featured_media' => 'off',
				'_uncode_post_share' => 'off',
				'_uncode_post_tags' => 'off',
				'_uncode_post_tags_align' => 'left',
				'_uncode_post_content_block_after_pre' => '',
				'_uncode_post_content_block_after' => '',
				'_uncode_post_comments' => 'on',
				'_uncode_post_activate_sidebar' => 'on',
				'_uncode_post_sidebar' => 'sidebar-1',
				'_uncode_post_sidebar_position' => 'sidebar_right',
				'_uncode_post_sidebar_size' => '4',
				'_uncode_post_sidebar_sticky' => 'off',
				'_uncode_post_sidebar_style' => '',
				'_uncode_post_sidebar_bgcolor' => '',
				'_uncode_post_sidebar_fill' => 'off',
				'_uncode_post_navigation_activate' => 'on',
				'_uncode_post_navigation_index' => '',
				'_uncode_post_navigation_index_label' => '',
				'_uncode_post_navigation_nextprev_title' => 'off',
				'_uncode_post_footer_block' => '',
				'_uncode_post_footer_width' => '',
				'_uncode_page_menu' => '',
				'_uncode_page_menu_width' => '',
				'_uncode_page_menu_opaque' => 'off',
				'_uncode_page_header' => 'none',
				'_uncode_page_blocks' => '',
				'_uncode_page_header_width' => '',
				'_uncode_page_header_height' => array (
					0 => '60',
					1 => '%',
				),
				'_uncode_page_header_min_height' => '300',
				'_uncode_page_header_title' => 'on',
				'_uncode_page_header_style' => 'light',
				'_uncode_page_header_content_width' => 'off',
				'_uncode_page_header_custom_width' => '100',
				'_uncode_page_header_align' => 'center',
				'_uncode_page_header_position' => 'header-center header-middle',
				'_uncode_page_header_title_font' => 'font-555555',
				'_uncode_page_header_title_size' => 'h1',
				'_uncode_page_header_title_height' => '',
				'_uncode_page_header_title_spacing' => '',
				'_uncode_page_header_title_weight' => '',
				'_uncode_page_header_title_transform' => '',
				'_uncode_page_header_title_italic' => 'off',
				'_uncode_page_header_text_animation' => '',
				'_uncode_page_header_animation_speed' => '',
				'_uncode_page_header_animation_delay' => '',
				'_uncode_page_header_featured' => 'on',
				'_uncode_page_header_background' => array (
					'background-color' => 'color-gyho',
					'background-attachment' => '',
					'background-position' => '',
					'background-size' => '',
					'background-image' => '',
				),
				'_uncode_page_header_parallax' => 'off',
				'_uncode_page_header_kburns' => '',
				'_uncode_page_header_overlay_color' => '',
				'_uncode_page_header_overlay_color_alpha' => '100',
				'_uncode_page_header_scroll_opacity' => 'off',
				'_uncode_page_header_scrolldown' => 'off',
				'_uncode_page_menu_no_padding' => 'off',
				'_uncode_page_menu_no_padding_mobile' => 'off',
				'_uncode_page_select_content' => '',
				'_uncode_page_content_block' => '',
				'_uncode_page_layout_width' => '',
				'_uncode_page_layout_width_custom' => array (
					0 => '',
					1 => 'px',
				),
				'_uncode_page_breadcrumb' => 'off',
				'_uncode_page_breadcrumb_align' => '',
				'_uncode_page_title' => 'on',
				'_uncode_page_media' => 'on',
				'_uncode_page_featured_media_display' => 'carousel',
				'_uncode_page_featured_media' => 'off',
				'_uncode_page_content_block_after' => '',
				'_uncode_page_comments' => 'on',
				'_uncode_page_activate_sidebar' => 'off',
				'_uncode_page_sidebar' => '',
				'_uncode_page_sidebar_position' => 'sidebar_right',
				'_uncode_page_sidebar_size' => '4',
				'_uncode_page_sidebar_sticky' => 'off',
				'_uncode_page_sidebar_style' => '',
				'_uncode_page_sidebar_bgcolor' => '',
				'_uncode_page_sidebar_fill' => 'off',
				'_uncode_page_footer_block' => '',
				'_uncode_page_footer_width' => '',
				'_uncode_portfolio_menu' => '',
				'_uncode_portfolio_menu_width' => '',
				'_uncode_portfolio_menu_opaque' => 'off',
				'_uncode_portfolio_header' => 'none',
				'_uncode_portfolio_blocks' => '',
				'_uncode_portfolio_header_width' => '',
				'_uncode_portfolio_header_height' => array (
					0 => '60',
					1 => '%',
				),
				'_uncode_portfolio_header_min_height' => '300',
				'_uncode_portfolio_header_title' => 'on',
				'_uncode_portfolio_header_style' => 'light',
				'_uncode_portfolio_header_content_width' => 'off',
				'_uncode_portfolio_header_custom_width' => '100',
				'_uncode_portfolio_header_align' => 'center',
				'_uncode_portfolio_header_position' => 'header-center header-middle',
				'_uncode_portfolio_header_title_font' => 'font-555555',
				'_uncode_portfolio_header_title_size' => 'h1',
				'_uncode_portfolio_header_title_height' => '',
				'_uncode_portfolio_header_title_spacing' => '',
				'_uncode_portfolio_header_title_weight' => '',
				'_uncode_portfolio_header_title_transform' => '',
				'_uncode_portfolio_header_title_italic' => 'off',
				'_uncode_portfolio_header_text_animation' => '',
				'_uncode_portfolio_header_animation_speed' => '',
				'_uncode_portfolio_header_animation_delay' => '',
				'_uncode_portfolio_header_featured' => 'on',
				'_uncode_portfolio_header_background' => array (
					'background-color' => 'color-gyho',
					'background-attachment' => '',
					'background-position' => '',
					'background-size' => '',
					'background-image' => '',
				),
				'_uncode_portfolio_header_parallax' => 'off',
				'_uncode_portfolio_header_kburns' => '',
				'_uncode_portfolio_header_overlay_color' => '',
				'_uncode_portfolio_header_overlay_color_alpha' => '100',
				'_uncode_portfolio_header_scroll_opacity' => 'off',
				'_uncode_portfolio_header_scrolldown' => 'off',
				'_uncode_portfolio_menu_no_padding' => 'off',
				'_uncode_portfolio_menu_no_padding_mobile' => 'off',
				'_uncode_portfolio_select_content' => '',
				'_uncode_portfolio_content_block' => '',
				'_uncode_portfolio_layout_width' => '',
				'_uncode_portfolio_layout_width_custom' => array (
					0 => '',
					1 => 'px',
				),
				'_uncode_portfolio_breadcrumb' => 'off',
				'_uncode_portfolio_breadcrumb_align' => '',
				'_uncode_portfolio_title' => 'on',
				'_uncode_portfolio_media' => 'on',
				'_uncode_portfolio_featured_media_display' => 'carousel',
				'_uncode_portfolio_featured_media' => 'off',
				'_uncode_portfolio_share' => 'off',
				'_uncode_portfolio_content_block_after' => '',
				'_uncode_portfolio_comments' => 'off',
				'_uncode_portfolio_position' => '',
				'_uncode_portfolio_sidebar_size' => '4',
				'_uncode_portfolio_sidebar_sticky' => 'off',
				'_uncode_portfolio_style' => '',
				'_uncode_portfolio_bgcolor' => '',
				'_uncode_portfolio_sidebar_fill' => 'off',
				'_uncode_portfolio_navigation_activate' => 'on',
				'_uncode_portfolio_navigation_index' => '',
				'_uncode_portfolio_navigation_index_label' => '',
				'_uncode_portfolio_navigation_nextprev_title' => 'off',
				'_uncode_portfolio_footer_block' => '',
				'_uncode_portfolio_footer_width' => '',
				'_uncode_post_index_menu' => '',
				'_uncode_post_index_menu_width' => '',
				'_uncode_post_index_menu_opaque' => 'off',
				'_uncode_post_index_header' => 'header_basic',
				'_uncode_post_index_blocks' => '',
				'_uncode_post_index_header_width' => '',
				'_uncode_post_index_header_height' => array (
					0 => '60',
					1 => '%',
				),
				'_uncode_post_index_header_min_height' => '300',
				'_uncode_post_index_header_title' => 'on',
				'_uncode_post_index_header_style' => 'light',
				'_uncode_post_index_header_content_width' => 'off',
				'_uncode_post_index_header_custom_width' => '100',
				'_uncode_post_index_header_align' => 'center',
				'_uncode_post_index_header_position' => 'header-center header-middle',
				'_uncode_post_index_header_title_font' => 'font-555555',
				'_uncode_post_index_header_title_size' => 'h1',
				'_uncode_post_index_header_title_height' => '',
				'_uncode_post_index_header_title_spacing' => '',
				'_uncode_post_index_header_title_weight' => '',
				'_uncode_post_index_header_title_transform' => '',
				'_uncode_post_index_header_title_italic' => 'off',
				'_uncode_post_index_header_text_animation' => '',
				'_uncode_post_index_header_animation_speed' => '',
				'_uncode_post_index_header_animation_delay' => '',
				'_uncode_post_index_header_featured' => 'on',
				'_uncode_post_index_header_background' => array (
					'background-color' => 'color-gyho',
					'background-attachment' => '',
					'background-position' => '',
					'background-size' => '',
					'background-image' => '',
				),
				'_uncode_post_index_header_parallax' => 'off',
				'_uncode_post_index_header_kburns' => '',
				'_uncode_post_index_header_overlay_color' => '',
				'_uncode_post_index_header_overlay_color_alpha' => '100',
				'_uncode_post_index_header_scroll_opacity' => 'off',
				'_uncode_post_index_header_scrolldown' => 'off',
				'_uncode_post_index_menu_no_padding' => 'off',
				'_uncode_post_index_menu_no_padding_mobile' => 'off',
				'_uncode_post_index_custom_title_activate' => 'off',
				'_uncode_post_index_custom_title_text' => '',
				'_uncode_post_index_custom_subtitle_text' => '',
				'_uncode_post_index_breadcrumb' => 'off',
				'_uncode_post_index_breadcrumb_align' => '',
				'_uncode_post_index_content_block' => '',
				'_uncode_post_index_layout_width' => '',
				'_uncode_post_index_single_width' => '4',
				'_uncode_post_index_single_text_length' => '',
				'_uncode_post_index_title' => 'off',
				'_uncode_post_index_remove_pagination' => 'off',
				'_uncode_post_index_activate_sidebar' => 'on',
				'_uncode_post_index_sidebar' => 'sidebar-1',
				'_uncode_post_index_sidebar_position' => 'sidebar_right',
				'_uncode_post_index_sidebar_size' => '4',
				'_uncode_post_index_sidebar_sticky' => 'off',
				'_uncode_post_index_sidebar_style' => '',
				'_uncode_post_index_sidebar_bgcolor' => '',
				'_uncode_post_index_sidebar_fill' => 'off',
				'_uncode_post_index_footer_block' => '',
				'_uncode_post_index_footer_width' => '',
				'_uncode_page_index_menu' => '',
				'_uncode_page_index_menu_width' => '',
				'_uncode_page_index_menu_opaque' => 'off',
				'_uncode_page_index_header' => 'header_basic',
				'_uncode_page_index_blocks' => '',
				'_uncode_page_index_header_width' => '',
				'_uncode_page_index_header_height' => array (
					0 => '60',
					1 => '%',
				),
				'_uncode_page_index_header_min_height' => '300',
				'_uncode_page_index_header_title' => 'on',
				'_uncode_page_index_header_style' => 'light',
				'_uncode_page_index_header_content_width' => 'off',
				'_uncode_page_index_header_custom_width' => '100',
				'_uncode_page_index_header_align' => 'center',
				'_uncode_page_index_header_position' => 'header-center header-middle',
				'_uncode_page_index_header_title_font' => 'font-555555',
				'_uncode_page_index_header_title_size' => 'h1',
				'_uncode_page_index_header_title_height' => '',
				'_uncode_page_index_header_title_spacing' => '',
				'_uncode_page_index_header_title_weight' => '',
				'_uncode_page_index_header_title_transform' => '',
				'_uncode_page_index_header_title_italic' => 'off',
				'_uncode_page_index_header_text_animation' => '',
				'_uncode_page_index_header_animation_speed' => '',
				'_uncode_page_index_header_animation_delay' => '',
				'_uncode_page_index_header_featured' => 'on',
				'_uncode_page_index_header_background' => array (
					'background-color' => 'color-gyho',
					'background-attachment' => '',
					'background-position' => '',
					'background-size' => '',
					'background-image' => '',
				),
				'_uncode_page_index_header_parallax' => 'off',
				'_uncode_page_index_header_kburns' => '',
				'_uncode_page_index_header_overlay_color' => '',
				'_uncode_page_index_header_overlay_color_alpha' => '100',
				'_uncode_page_index_header_scroll_opacity' => 'off',
				'_uncode_page_index_header_scrolldown' => 'off',
				'_uncode_page_index_menu_no_padding' => 'off',
				'_uncode_page_index_menu_no_padding_mobile' => 'off',
				'_uncode_page_index_breadcrumb' => 'off',
				'_uncode_page_index_breadcrumb_align' => '',
				'_uncode_page_index_content_block' => '',
				'_uncode_page_index_layout_width' => '',
				'_uncode_page_index_single_width' => '4',
				'_uncode_page_index_single_text_length' => '',
				'_uncode_page_index_title' => 'off',
				'_uncode_page_index_remove_pagination' => 'off',
				'_uncode_page_index_activate_sidebar' => 'on',
				'_uncode_page_index_sidebar' => 'sidebar-1',
				'_uncode_page_index_sidebar_position' => 'sidebar_right',
				'_uncode_page_index_sidebar_size' => '4',
				'_uncode_page_index_sidebar_sticky' => 'off',
				'_uncode_page_index_sidebar_style' => '',
				'_uncode_page_index_sidebar_bgcolor' => '',
				'_uncode_page_index_sidebar_fill' => 'off',
				'_uncode_page_index_footer_block' => '',
				'_uncode_page_index_footer_width' => '',
				'_uncode_portfolio_index_menu' => '',
				'_uncode_portfolio_index_menu_width' => '',
				'_uncode_portfolio_index_menu_opaque' => 'off',
				'_uncode_portfolio_index_header' => 'header_basic',
				'_uncode_portfolio_index_blocks' => '',
				'_uncode_portfolio_index_header_width' => '',
				'_uncode_portfolio_index_header_height' => array (
					0 => '60',
					1 => '%',
				),
				'_uncode_portfolio_index_header_min_height' => '300',
				'_uncode_portfolio_index_header_title' => 'on',
				'_uncode_portfolio_index_header_style' => 'light',
				'_uncode_portfolio_index_header_content_width' => 'off',
				'_uncode_portfolio_index_header_custom_width' => '100',
				'_uncode_portfolio_index_header_align' => 'center',
				'_uncode_portfolio_index_header_position' => 'header-center header-middle',
				'_uncode_portfolio_index_header_title_font' => 'font-555555',
				'_uncode_portfolio_index_header_title_size' => 'h1',
				'_uncode_portfolio_index_header_title_height' => '',
				'_uncode_portfolio_index_header_title_spacing' => '',
				'_uncode_portfolio_index_header_title_weight' => '',
				'_uncode_portfolio_index_header_title_transform' => '',
				'_uncode_portfolio_index_header_title_italic' => 'off',
				'_uncode_portfolio_index_header_text_animation' => '',
				'_uncode_portfolio_index_header_animation_speed' => '',
				'_uncode_portfolio_index_header_animation_delay' => '',
				'_uncode_portfolio_index_header_featured' => 'on',
				'_uncode_portfolio_index_header_background' => array (
					'background-color' => 'color-gyho',
					'background-attachment' => '',
					'background-position' => '',
					'background-size' => '',
					'background-image' => '',
				),
				'_uncode_portfolio_index_header_parallax' => 'off',
				'_uncode_portfolio_index_header_kburns' => '',
				'_uncode_portfolio_index_header_overlay_color' => '',
				'_uncode_portfolio_index_header_overlay_color_alpha' => '100',
				'_uncode_portfolio_index_header_scroll_opacity' => 'off',
				'_uncode_portfolio_index_header_scrolldown' => 'off',
				'_uncode_portfolio_index_menu_no_padding' => 'off',
				'_uncode_portfolio_index_menu_no_padding_mobile' => 'off',
				'_uncode_portfolio_index_custom_title_activate' => 'off',
				'_uncode_portfolio_index_custom_title_text' => '',
				'_uncode_portfolio_index_custom_subtitle_text' => '',
				'_uncode_portfolio_index_breadcrumb' => 'off',
				'_uncode_portfolio_index_breadcrumb_align' => '',
				'_uncode_portfolio_index_content_block' => '',
				'_uncode_portfolio_index_layout_width' => '',
				'_uncode_portfolio_index_single_width' => '4',
				'_uncode_portfolio_index_title' => 'off',
				'_uncode_portfolio_index_remove_pagination' => 'off',
				'_uncode_portfolio_index_activate_sidebar' => 'off',
				'_uncode_portfolio_index_sidebar' => '',
				'_uncode_portfolio_index_sidebar_position' => 'sidebar_right',
				'_uncode_portfolio_index_sidebar_size' => '4',
				'_uncode_portfolio_index_sidebar_sticky' => 'off',
				'_uncode_portfolio_index_sidebar_style' => '',
				'_uncode_portfolio_index_sidebar_bgcolor' => '',
				'_uncode_portfolio_index_sidebar_fill' => 'off',
				'_uncode_portfolio_index_footer_block' => '',
				'_uncode_portfolio_index_footer_width' => '',
				'_uncode_author_index_menu' => '',
				'_uncode_author_index_menu_width' => '',
				'_uncode_author_index_menu_opaque' => 'off',
				'_uncode_author_index_header' => 'header_basic',
				'_uncode_author_index_blocks' => '',
				'_uncode_author_index_header_width' => '',
				'_uncode_author_index_header_height' => array (
					0 => '60',
					1 => '%',
				),
				'_uncode_author_index_header_min_height' => '300',
				'_uncode_author_index_header_title' => 'on',
				'_uncode_author_index_header_style' => 'light',
				'_uncode_author_index_header_content_width' => 'off',
				'_uncode_author_index_header_custom_width' => '100',
				'_uncode_author_index_header_align' => 'center',
				'_uncode_author_index_header_position' => 'header-center header-middle',
				'_uncode_author_index_header_title_font' => 'font-555555',
				'_uncode_author_index_header_title_size' => 'h1',
				'_uncode_author_index_header_title_height' => '',
				'_uncode_author_index_header_title_spacing' => '',
				'_uncode_author_index_header_title_weight' => '',
				'_uncode_author_index_header_title_transform' => '',
				'_uncode_author_index_header_title_italic' => 'off',
				'_uncode_author_index_header_text_animation' => '',
				'_uncode_author_index_header_animation_speed' => '',
				'_uncode_author_index_header_animation_delay' => '',
				'_uncode_author_index_header_featured' => 'on',
				'_uncode_author_index_header_background' => array (
					'background-color' => 'color-gyho',
					'background-attachment' => '',
					'background-position' => '',
					'background-size' => '',
					'background-image' => '',
				),
				'_uncode_author_index_header_parallax' => 'off',
				'_uncode_author_index_header_kburns' => '',
				'_uncode_author_index_header_overlay_color' => '',
				'_uncode_author_index_header_overlay_color_alpha' => '100',
				'_uncode_author_index_header_scroll_opacity' => 'off',
				'_uncode_author_index_header_scrolldown' => 'off',
				'_uncode_author_index_menu_no_padding' => 'off',
				'_uncode_author_index_menu_no_padding_mobile' => 'off',
				'_uncode_author_index_breadcrumb' => 'off',
				'_uncode_author_index_breadcrumb_align' => '',
				'_uncode_author_index_content_block' => '',
				'_uncode_author_index_layout_width' => '',
				'_uncode_author_index_single_width' => '4',
				'_uncode_author_index_single_text_length' => '',
				'_uncode_author_index_title' => 'off',
				'_uncode_author_index_remove_pagination' => 'off',
				'_uncode_author_index_activate_sidebar' => 'on',
				'_uncode_author_index_sidebar' => 'sidebar-1',
				'_uncode_author_index_sidebar_position' => 'sidebar_right',
				'_uncode_author_index_sidebar_size' => '4',
				'_uncode_author_index_sidebar_sticky' => 'off',
				'_uncode_author_index_sidebar_style' => '',
				'_uncode_author_index_sidebar_bgcolor' => '',
				'_uncode_author_index_sidebar_fill' => 'off',
				'_uncode_author_index_footer_block' => '',
				'_uncode_author_index_footer_width' => '',
				'_uncode_search_index_menu' => '',
				'_uncode_search_index_menu_width' => '',
				'_uncode_search_index_menu_opaque' => 'off',
				'_uncode_search_index_header' => 'header_basic',
				'_uncode_search_index_blocks' => '',
				'_uncode_search_index_header_width' => '',
				'_uncode_search_index_header_height' => array (
					0 => '60',
					1 => '%',
				),
				'_uncode_search_index_header_min_height' => '300',
				'_uncode_search_index_header_title' => 'on',
				'_uncode_search_index_header_title_text' => '',
				'_uncode_search_index_header_style' => 'light',
				'_uncode_search_index_header_content_width' => 'off',
				'_uncode_search_index_header_custom_width' => '100',
				'_uncode_search_index_header_align' => 'center',
				'_uncode_search_index_header_position' => 'header-center header-middle',
				'_uncode_search_index_header_title_font' => 'font-555555',
				'_uncode_search_index_header_title_size' => 'h1',
				'_uncode_search_index_header_title_height' => '',
				'_uncode_search_index_header_title_spacing' => '',
				'_uncode_search_index_header_title_weight' => '',
				'_uncode_search_index_header_title_transform' => '',
				'_uncode_search_index_header_title_italic' => 'off',
				'_uncode_search_index_header_text_animation' => '',
				'_uncode_search_index_header_animation_speed' => '',
				'_uncode_search_index_header_animation_delay' => '',
				'_uncode_search_index_header_background' => array (
					'background-color' => 'color-gyho',
					'background-attachment' => '',
					'background-position' => '',
					'background-size' => '',
					'background-image' => '',
				),
				'_uncode_search_index_header_parallax' => 'off',
				'_uncode_search_index_header_kburns' => '',
				'_uncode_search_index_header_overlay_color' => '',
				'_uncode_search_index_header_overlay_color_alpha' => '100',
				'_uncode_search_index_header_scroll_opacity' => 'off',
				'_uncode_search_index_header_scrolldown' => 'off',
				'_uncode_search_index_menu_no_padding' => 'off',
				'_uncode_search_index_menu_no_padding_mobile' => 'off',
				'_uncode_search_index_custom_title_activate' => 'off',
				'_uncode_search_index_custom_title_text' => '',
				'_uncode_search_index_custom_subtitle_text' => '',
				'_uncode_search_index_content_block' => '',
				'_uncode_search_index_layout_width' => '',
				'_uncode_search_index_remove_pagination' => 'off',
				'_uncode_search_index_activate_sidebar' => 'off',
				'_uncode_search_index_sidebar' => '',
				'_uncode_search_index_sidebar_position' => 'sidebar_right',
				'_uncode_search_index_sidebar_size' => '4',
				'_uncode_search_index_sidebar_sticky' => 'off',
				'_uncode_search_index_sidebar_style' => '',
				'_uncode_search_index_sidebar_bgcolor' => '',
				'_uncode_search_index_sidebar_fill' => 'off',
				'_uncode_search_index_footer_block' => '',
				'_uncode_search_index_footer_width' => '',
				'_uncode_404_menu' => '',
				'_uncode_404_menu_width' => '',
				'_uncode_404_menu_opaque' => 'off',
				'_uncode_404_header' => 'none',
				'_uncode_404_blocks' => '',
				'_uncode_404_header_width' => '',
				'_uncode_404_header_height' => array (
					0 => '60',
					1 => '%',
				),
				'_uncode_404_header_min_height' => '300',
				'_uncode_404_header_title' => 'on',
				'_uncode_404_header_title_text' => '',
				'_uncode_404_header_style' => 'light',
				'_uncode_404_header_content_width' => 'off',
				'_uncode_404_header_custom_width' => '100',
				'_uncode_404_header_align' => 'center',
				'_uncode_404_header_position' => 'header-center header-middle',
				'_uncode_404_header_title_font' => 'font-555555',
				'_uncode_404_header_title_size' => 'h1',
				'_uncode_404_header_title_height' => '',
				'_uncode_404_header_title_spacing' => '',
				'_uncode_404_header_title_weight' => '',
				'_uncode_404_header_title_transform' => '',
				'_uncode_404_header_title_italic' => 'off',
				'_uncode_404_header_text_animation' => '',
				'_uncode_404_header_animation_speed' => '',
				'_uncode_404_header_animation_delay' => '',
				'_uncode_404_header_background' => array (
					'background-color' => 'color-gyho',
					'background-attachment' => '',
					'background-position' => '',
					'background-size' => '',
					'background-image' => '',
				),
				'_uncode_404_header_parallax' => 'off',
				'_uncode_404_header_kburns' => '',
				'_uncode_404_header_overlay_color' => '',
				'_uncode_404_header_overlay_color_alpha' => '100',
				'_uncode_404_header_scroll_opacity' => 'off',
				'_uncode_404_header_scrolldown' => 'off',
				'_uncode_404_menu_no_padding' => 'off',
				'_uncode_404_menu_no_padding_mobile' => 'off',
				'_uncode_404_layout_width' => '',
				'_uncode_404_body' => '',
				'_uncode_404_body_block' => '',
				'_uncode_404_footer_block' => '',
				'_uncode_404_footer_width' => '',
				'_uncode_custom_colors_list' => array (
					0 => array (
						'title' => 'Black',
						'_uncode_custom_color_unique_id' => 'color-jevc',
						'_uncode_custom_color_regular' => 'on',
						'_uncode_custom_color' => '#000000',
						'_uncode_custom_color_gradient' => '',
					),
					1 => array (
						'title' => 'Dark 1',
						'_uncode_custom_color_unique_id' => 'color-nhtu',
						'_uncode_custom_color_regular' => 'on',
						'_uncode_custom_color' => '#101213',
						'_uncode_custom_color_gradient' => '',
					),
					2 => array (
						'title' => 'Dark 2',
						'_uncode_custom_color_unique_id' => 'color-wayh',
						'_uncode_custom_color_regular' => 'on',
						'_uncode_custom_color' => '#141618',
						'_uncode_custom_color_gradient' => '',
					),
					3 => array (
						'title' => 'Dark 3',
						'_uncode_custom_color_unique_id' => 'color-rgdb',
						'_uncode_custom_color_regular' => 'on',
						'_uncode_custom_color' => '#1b1d1f',
						'_uncode_custom_color_gradient' => '',
					),
					4 => array (
						'title' => 'Dark 4',
						'_uncode_custom_color_unique_id' => 'color-prif',
						'_uncode_custom_color_regular' => 'on',
						'_uncode_custom_color' => '#303133',
						'_uncode_custom_color_gradient' => '',
					),
					5 => array (
						'title' => 'White',
						'_uncode_custom_color_unique_id' => 'color-xsdn',
						'_uncode_custom_color_regular' => 'on',
						'_uncode_custom_color' => '#ffffff',
						'_uncode_custom_color_gradient' => '',
					),
					6 => array (
						'title' => 'Light 1',
						'_uncode_custom_color_unique_id' => 'color-lxmt',
						'_uncode_custom_color_regular' => 'on',
						'_uncode_custom_color' => '#f7f7f7',
						'_uncode_custom_color_gradient' => '',
					),
					7 => array (
						'title' => 'Light 2',
						'_uncode_custom_color_unique_id' => 'color-gyho',
						'_uncode_custom_color_regular' => 'on',
						'_uncode_custom_color' => '#eaeaea',
						'_uncode_custom_color_gradient' => '',
					),
					8 => array (
						'title' => 'Light 3',
						'_uncode_custom_color_unique_id' => 'color-uydo',
						'_uncode_custom_color_regular' => 'on',
						'_uncode_custom_color' => '#dddddd',
						'_uncode_custom_color_gradient' => '',
					),
					9 => array (
						'title' => 'Light 4',
						'_uncode_custom_color_unique_id' => 'color-wvjs',
						'_uncode_custom_color_regular' => 'on',
						'_uncode_custom_color' => '#777777',
						'_uncode_custom_color_gradient' => '',
					),
					10 => array (
						'title' => 'Cerulean',
						'_uncode_custom_color_unique_id' => 'color-vyce',
						'_uncode_custom_color_regular' => 'on',
						'_uncode_custom_color' => '#0cb4ce',
						'_uncode_custom_color_gradient' => '',
					),
					11 => array (
						'title' => 'Blue Ribbon',
						'_uncode_custom_color_unique_id' => 'color-210407',
						'_uncode_custom_color_regular' => 'on',
						'_uncode_custom_color' => '#006cff',
						'_uncode_custom_color_gradient' => '{"css":"background: linear-gradient(left , rgb(23, 200, 7) 74% , rgb(103, 30, 204) 78%);background: -o-linear-gradient(left , rgb(23, 200, 7) 74% , rgb(103, 30, 204) 78%);background: -ms-linear-gradient(left , rgb(23, 200, 7) 74% , rgb(103, 30, 204) 78%);background: -moz-linear-gradient(left , rgb(23, 200, 7) 74% , rgb(103, 30, 204) 78%);background: -webkit-linear-gradient(left , rgb(23, 200, 7) 74% , rgb(103, 30, 204) 78%);","sliders":[{"color":"rgb(23, 200, 7)","position":74},{"color":"rgb(103, 30, 204)","position":78}],"type":"linear","direction":"left"}',
					),
				),
				'_uncode_font_groups' => array (
					0 => array (
						'title' => 'Font Default',
						'_uncode_font_group_unique_id' => 'font-555555',
						'_uncode_font_group' => 'manual',
						'_uncode_font_manual' => '-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue",sans-serif',
					),
				),
				'_uncode_font_size' => '15',
				'_uncode_large_text_size' => '18',
				'_uncode_small_text_size' => '13',
				'_uncode_heading_h1' => '35',
				'_uncode_heading_h2' => '29',
				'_uncode_heading_h3' => '24',
				'_uncode_heading_h4' => '20',
				'_uncode_heading_h5' => '17',
				'_uncode_heading_h6' => '14',
				'_uncode_logo_color_light' => 'color-prif',
				'_uncode_menu_color_light' => 'color-prif',
				'_uncode_menu_bg_color_light' => 'color-xsdn',
				'_uncode_menu_bg_alpha_light' => '100',
				'_uncode_submenu_bg_color_light' => 'color-xsdn',
				'_uncode_menu_border_color_light' => 'color-gyho',
				'_uncode_menu_border_alpha_light' => '100',
				'_uncode_secmenu_bg_color_light' => 'color-xsdn',
				'_uncode_heading_color_light' => 'color-prif',
				'_uncode_text_color_light' => 'color-wvjs',
				'_uncode_background_color_light' => 'color-xsdn',
				'_uncode_logo_color_dark' => 'color-xsdn',
				'_uncode_menu_color_dark' => 'color-xsdn',
				'_uncode_menu_bg_color_dark' => 'color-wayh',
				'_uncode_menu_bg_alpha_dark' => '100',
				'_uncode_submenu_bg_color_dark' => 'color-rgdb',
				'_uncode_menu_border_color_dark' => 'color-prif',
				'_uncode_menu_border_alpha_dark' => '100',
				'_uncode_secmenu_bg_color_dark' => 'color-wayh',
				'_uncode_heading_color_dark' => 'color-xsdn',
				'_uncode_text_color_dark' => 'color-xsdn',
				'_uncode_background_color_dark' => 'color-wayh',
				'_uncode_body_background' => array (
					'background-color' => 'color-lxmt',
					'background-attachment' => '',
					'background-position' => '',
					'background-size' => '',
					'background-image' => '',
				),
				'_uncode_accent_color' => 'color-210407',
				'_uncode_body_link_color' => '',
				'_uncode_body_font_family' => 'font-555555',
				'_uncode_body_font_weight' => '400',
				'_uncode_heading_font_family' => 'font-555555',
				'_uncode_heading_font_weight' => '600',
				'_uncode_heading_letter_spacing' => '0.00',
				'_uncode_fallback_font' => 'font-555555',
				'_uncode_shadow_type'=> '',
				'_uncode_custom_cursor' => '',
				'_uncode_custom_cursor_links' => 'off',
				'_uncode_skew' => 'off',
				'_uncode_overlay_menu_style' => 'light',
				'_uncode_menu_color_hover' => '',
				'_uncode_primary_menu_style' => 'light',
				'_uncode_primary_submenu_style' => 'light',
				'_uncode_secondary_menu_style' => 'dark',
				'_uncode_menu_font_size' => '12',
				'_uncode_submenu_font_size' => '12',
				'_uncode_menu_overlay_font_size' => '3.5vh',
				'_uncode_submenu_overlay_font_size' => '',
				'_uncode_secondary_menu_font_size' => '12',
				'_uncode_secondary_menu_mobile_font_size' => '10',
				'_uncode_menu_mobile_font_size' => '12',
				'_uncode_menu_mobile_centered_font_size' => '5.5vw',
				'_uncode_submenu_mobile_centered_font_size' => '',
				'_uncode_menu_font_family' => 'font-555555',
				'_uncode_menu_font_weight' => '600',
				'_uncode_menu_letter_spacing' => '0.05',
				'_uncode_menu_first_uppercase' => 'off',
				'_uncode_menu_other_uppercase' => 'off',
				'_uncode_topbar_font_family' => 'font-555555',
				'_uncode_topbar_font_weight' => '400',
				'_uncode_general_style' => 'light',
				'_uncode_general_bg_color' => '',
				'_uncode_button_shape' => '',
				'_uncode_buttons_font_family' => 'font-555555',
				'_uncode_buttons_font_weight' => '600',
				'_uncode_buttons_font_size' => '12',
				'_uncode_buttons_text_transform' => 'uppercase',
				'_uncode_buttons_letter_spacing' => '',
				'_uncode_buttons_border_width' => '1',
				'_uncode_button_hover' => '',
				'_uncode_button_proportions' => '',
				'_uncode_input_underline' => '',
				'_uncode_ui_font_family' => 'font-555555',
				'_uncode_ui_font_weight' => '600',
				'_uncode_ui_font_size' => '12',
				'_uncode_ui_text_transform' => 'uppercase',
				'_uncode_ui_letter_spacing' => '',
				'_uncode_menu_filter_font_family' => 'font-555555',
				'_uncode_menu_filter_font_weight' => '600',
				'_uncode_menu_filter_font_size' => '11',
				'_uncode_menu_filter_letter_spacing' => '',
				'_uncode_footer_last_style' => 'dark',
				'_uncode_footer_bg_color' => '',
				'_uncode_scroll_constant' => 'on',
				'_uncode_scroll_constant_factor' => '2',
				'_uncode_scroll_speed_value' => '1000',
				'_uncode_parallax_factor' => '2.5',
				'_uncode_sticky_elements' => 'off',
				'_uncode_woocommerce_hooks' => 'off',
				'_uncode_woocommerce_minicart_style' => '',
				'_uncode_woocommerce_sidecart_skin' => 'light',
				'_uncode_woocommerce_sidecart_position' => 'right',
				'_uncode_woocommerce_activate_sidecart_mobile' => 'off',
				'_uncode_product_index_quick_view' => 'off',
				'_uncode_product_index_quick_view_hooks' => 'off',
				'_uncode_product_index_quick_view_type' => '',
				'_uncode_product_index_quick_view_content_block' => '',
				'_uncode_woocommerce_enhanced_atc' => 'off',
				'_uncode_woocommerce_width_atc' => 'off',
				'_uncode_woocommerce_atc_notify' => '',
				'_uncode_woocommerce_catalog_mode' => 'off',
				'_uncode_woocommerce_catalog_mode_disabled_for_admins' => 'off',
				'_uncode_portfolio_cpt' => 'portfolio',
				'_uncode_portfolio_cpt_slug' => 'portfolio',
				'_uncode_gmaps_api' => '',
				'_uncode_redirect' => 'off',
				'_uncode_redirect_page' => '',
				'_uncode_admin_help' => 'on',
				'_uncode_custom_css' => '',
				'_uncode_custom_js' => '',
				'_uncode_custom_tracking' => '',
				'_uncode_custom_tracking_head' => '',
				'_uncode_adaptive' => 'off',
				'_uncode_adaptive_async' => 'off',
				'_uncode_adaptive_async_blur' => 'off',
				'_uncode_adaptive_mobile_advanced' => 'off',
				'_uncode_adaptive_use_orientation_width' => 'off',
				'_uncode_adaptive_limit_density' => 'off',
				'_uncode_dynamic_srcset' => 'on',
				'_uncode_dynamic_srcset_lazy_animations' => 'off',
				'_uncode_adaptive_quality' => '90',
				'_uncode_dynamic_srcset_sizes' => '720,1032',
				'_uncode_adaptive_sizes' => '258,516,720,1032,1440,2064,2880',
				'_uncode_adaptive_register_meta' => 'off',
				'_uncode_htaccess' => 'off',
				'_uncode_media_player' => 'off',
				'_uncode_production' => 'off',
				'_uncode_product_menu' => '',
				'_uncode_product_menu_width' => '',
				'_uncode_product_menu_opaque' => 'off',
				'_uncode_product_header' => 'none',
				'_uncode_product_blocks' => '',
				'_uncode_product_header_width' => '',
				'_uncode_product_header_height' => array (
					0 => '60',
					1 => '%',
				),
				'_uncode_product_header_min_height' => '300',
				'_uncode_product_header_title' => 'on',
				'_uncode_product_header_style' => 'light',
				'_uncode_product_header_content_width' => 'off',
				'_uncode_product_header_custom_width' => '100',
				'_uncode_product_header_align' => 'center',
				'_uncode_product_header_position' => 'header-center header-middle',
				'_uncode_product_header_title_font' => 'font-555555',
				'_uncode_product_header_title_size' => 'h1',
				'_uncode_product_header_title_height' => '',
				'_uncode_product_header_title_spacing' => '',
				'_uncode_product_header_title_weight' => '',
				'_uncode_product_header_title_transform' => '',
				'_uncode_product_header_title_italic' => 'off',
				'_uncode_product_header_text_animation' => '',
				'_uncode_product_header_animation_speed' => '',
				'_uncode_product_header_animation_delay' => '',
				'_uncode_product_header_featured' => 'on',
				'_uncode_product_header_background' => array (
					'background-color' => 'color-gyho',
					'background-attachment' => '',
					'background-position' => '',
					'background-size' => '',
					'background-image' => '',
				),
				'_uncode_product_header_parallax' => 'off',
				'_uncode_product_header_kburns' => '',
				'_uncode_product_header_overlay_color' => '',
				'_uncode_product_header_overlay_color_alpha' => '100',
				'_uncode_product_header_scroll_opacity' => 'off',
				'_uncode_product_header_scrolldown' => 'off',
				'_uncode_product_menu_no_padding' => 'off',
				'_uncode_product_menu_no_padding_mobile' => 'off',
				'_uncode_product_select_content' => '',
				'_uncode_product_content_block' => '',
				'_uncode_product_layout_width' => '',
				'_uncode_product_layout_width_custom' => array (
					0 => '',
					1 => 'px',
				),
				'_uncode_product_breadcrumb' => 'off',
				'_uncode_product_breadcrumb_align' => '',
				'_uncode_product_title' => 'off',
				'_uncode_product_enable_ajax_add_to_cart' => 'off',
				'_uncode_product_quantity_input_style' => '',
				'_uncode_product_share' => 'on',
				'_uncode_product_image_layout' => '',
				'_uncode_product_media_size' => '6',
				'_uncode_product_sticky_desc' => 'on',
				'_uncode_product_enable_zoom' => 'off',
				'_uncode_product_thumb_cols' => '',
				'_uncode_product_enable_slider' => 'off',
				'_uncode_product_content_block_after' => '',
				'_uncode_product_navigation_activate' => 'on',
				'_uncode_product_navigation_index' => '',
				'_uncode_product_navigation_index_label' => '',
				'_uncode_product_navigation_nextprev_title' => 'off',
				'_uncode_product_footer_block' => '',
				'_uncode_product_footer_width' => '',
				'_uncode_product_index_menu' => '',
				'_uncode_product_index_menu_width' => '',
				'_uncode_product_index_menu_opaque' => 'off',
				'_uncode_product_index_header' => 'header_basic',
				'_uncode_product_index_blocks' => '',
				'_uncode_product_index_header_width' => '',
				'_uncode_product_index_header_height' => array (
					0 => '60',
					1 => '%',
				),
				'_uncode_product_index_header_min_height' => '300',
				'_uncode_product_index_header_title' => 'on',
				'_uncode_product_index_header_style' => 'light',
				'_uncode_product_index_header_content_width' => 'off',
				'_uncode_product_index_header_custom_width' => '100',
				'_uncode_product_index_header_align' => 'center',
				'_uncode_product_index_header_position' => 'header-center header-middle',
				'_uncode_product_index_header_title_font' => 'font-555555',
				'_uncode_product_index_header_title_size' => 'h1',
				'_uncode_product_index_header_title_height' => '',
				'_uncode_product_index_header_title_spacing' => '',
				'_uncode_product_index_header_title_weight' => '',
				'_uncode_product_index_header_title_transform' => '',
				'_uncode_product_index_header_title_italic' => 'off',
				'_uncode_product_index_header_text_animation' => '',
				'_uncode_product_index_header_animation_speed' => '',
				'_uncode_product_index_header_animation_delay' => '',
				'_uncode_product_index_header_featured' => 'on',
				'_uncode_product_index_header_background' => array (
					'background-color' => 'color-gyho',
					'background-attachment' => '',
					'background-position' => '',
					'background-size' => '',
					'background-image' => '',
				),
				'_uncode_product_index_header_parallax' => 'off',
				'_uncode_product_index_header_kburns' => '',
				'_uncode_product_index_header_overlay_color' => '',
				'_uncode_product_index_header_overlay_color_alpha' => '100',
				'_uncode_product_index_header_scroll_opacity' => 'off',
				'_uncode_product_index_header_scrolldown' => 'off',
				'_uncode_product_index_menu_no_padding' => 'off',
				'_uncode_product_index_menu_no_padding_mobile' => 'off',
				'_uncode_product_index_custom_title_activate' => 'off',
				'_uncode_product_index_custom_title_text' => '',
				'_uncode_product_index_custom_subtitle_text' => '',
				'_uncode_product_index_breadcrumb' => 'off',
				'_uncode_product_index_breadcrumb_align' => '',
				'_uncode_product_index_content_block' => '',
				'_uncode_product_index_layout_width' => '',
				'_uncode_product_index_single_width' => '4',
				'_uncode_product_index_title' => 'off',
				'_uncode_product_index_remove_pagination' => 'off',
				'_uncode_product_index_ppp' => '0',
				'_uncode_product_index_activate_sidebar' => 'on',
				'_uncode_product_index_sidebar' => 'sidebar-1',
				'_uncode_product_index_sidebar_position' => 'sidebar_right',
				'_uncode_product_index_sidebar_size' => '4',
				'_uncode_product_index_sidebar_sticky' => 'off',
				'_uncode_product_index_sidebar_style' => '',
				'_uncode_product_index_sidebar_bgcolor' => '',
				'_uncode_product_index_sidebar_fill' => 'off',
				'_uncode_product_index_footer_block' => '',
				'_uncode_product_index_footer_width' => '',
				'_uncode_smooth_scroll' => 'on',
			);

			update_option( ot_options_id(), $default_theme_options );

			// Enable AJAX save by default
			update_option( 'uncode_ajax_theme_panel', 'yes', false );

			// New Lightbox
			update_option( 'uncode_core_settings_opt_lightbox_enhance', 'on', false );

			// New Top-Bar
			update_option( 'uncode_core_settings_opt_enhanced_top_bar', 'on', false );

		}
	}

	/**
	 * Regenerate dynamic CSS when activating WooCommerce
	 */
	public static function regenerate_dynamic_css_on_wc_activation() {
		if ( ! get_option( 'uncode_has_wc_dynamic_css' ) ) {
			uncode_create_dynamic_css();
		}
	}
}

endif;

Uncode_Install::init();
