<?php
/**
 * name             - Wireframe title
 * cat_name         - Comma separated list for multiple categories (cat display name)
 * custom_class     - Space separated list for multiple categories (cat ID)
 * dependency       - Array of dependencies
 * is_content_block - (optional) Best in a content block
 *
 * @version  1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$wireframe_categories = UNCDWF_Dynamic::get_wireframe_categories();
$data                 = array();

// Wireframe properties

$data[ 'name' ]             = esc_html__( 'Pricing List Tabs Textual', 'uncode-wireframes' );
$data[ 'cat_name' ]         = $wireframe_categories[ 'pricing_tables' ];
$data[ 'custom_class' ]     = 'pricing_tables';
$data[ 'image_path' ]       = UNCDWF_THUMBS_URL . 'pricing-tables/Pricing-List-Tabs-Textual.jpg';
$data[ 'dependency' ]       = array();
$data[ 'is_content_block' ] = false;

// Wireframe content

$data[ 'content' ]      = '
[vc_row row_height_percent="0" override_padding="yes" h_padding="2" top_padding="5" bottom_padding="5" overlay_alpha="50" gutter_size="3" column_width_use_pixel="yes" shift_y="0" z_index="0" uncode_shortcode_id="180869" column_width_pixel="1600"][vc_column column_width_percent="100" position_vertical="middle" align_horizontal="align_center" gutter_size="4"  overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" css_animation="alpha-anim" animation_speed="1000" width="1/1" uncode_shortcode_id="198925"][vc_custom_heading text_size="'. uncode_wf_print_font_size( 'h1' ) .'" uncode_shortcode_id="111188"]Medium headline[/vc_custom_heading][vc_tabs tab_no_fade="yes" animation_active="yes" typography="advanced" width_100="yes" titles_size="h3" titles_weight="600" gutter_simple="0" uncode_shortcode_id="101779"][vc_tab gutter_size="2" column_padding="4" title="Starters" tab_id="1671548483061-0-5167283140478516728331040301698674893862169997174201617065257079591715587857496" slug="starters"][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="4" shift_y="0" z_index="0" uncode_shortcode_id="362948" limit_content=""][vc_column_inner column_width_percent="100" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="129403"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Golden%20Beet%20Carpaccio%22%2C%22value%22%3A%22%2418%22%2C%22text%22%3A%22Thinly%20sliced%20golden%20beets%2C%20goat%20cheese%2C%20walnut%2C%20with%20a%20citrus%20vinaigrette%22%7D%2C%7B%22entry%22%3A%22Seared%20Scallops%22%2C%22value%22%3A%22%2424%22%2C%22text%22%3A%22Pan-seared%20scallops%20on%20a%20bed%20of%20cauliflower%20puree%20with%20a%20balsamic%20reduction%22%7D%2C%7B%22entry%22%3A%22Truffle%20Burrata%22%2C%22value%22%3A%22%2422%22%2C%22text%22%3A%22Creamy%20burrata%20with%20black%20truffle%2C%20arugula%2C%20light%20garlic%20sauce%20and%20extra%20virgin%20olive%20oil%22%7D%2C%7B%22entry%22%3A%22Lobster%20Bisque%22%2C%22value%22%3A%22%2420%22%2C%22text%22%3A%22Rich%20and%20creamy%20lobster%20bisque%2C%20sweet%20potato%20mash%2C%20flavored%20with%20cognac%20and%20fresh%20herbs%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_width_percent="0" border_style="dashed" border_color="color-gyho" heading_semantic="h6" text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="400" sub_lead="yes" uncode_shortcode_id="184333" border_color_type="uncode-palette"][/vc_column_inner][vc_column_inner column_width_percent="100" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="203943"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Duck%20Confit%20Crostini%22%2C%22value%22%3A%22%2419%22%2C%22text%22%3A%22Crisp%20crostini%20topped%20with%20tender%20duck%20confit%2C%20fig%20jam%2C%20italian%20tomato%2C%20brie%20and%20sweet%20potato%20mash%22%7D%2C%7B%22entry%22%3A%22Wild%20Mushroom%20Tartlet%22%2C%22value%22%3A%22%2417%22%2C%22text%22%3A%22Savory%20tartlet%20filled%20with%20wild%20mushrooms%2C%20thyme%2C%20and%20Gruy%C3%A8re%20cheese%22%7D%2C%7B%22entry%22%3A%22Crab%20Avocado%20Tower%22%2C%22value%22%3A%22%2423%22%2C%22text%22%3A%22Layered%20crab%20meat%2C%20avocado%2C%20mango%20salsa%2C%20light%20garlic%20sauce%20with%20a%20lime%20dressing%22%7D%2C%7B%22entry%22%3A%22Foie%20Gras%20Torchon%20%22%2C%22value%22%3A%22%2426%22%2C%22text%22%3A%22Smooth%20foie%20gras%20torchon%2C%20cherry%20compote%2C%20and%20toasted%20brioche%20with%20a%20traffle%20reduction%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_width_percent="0" border_style="dashed" border_color="color-gyho" heading_semantic="h6"  text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="400" sub_lead="yes" uncode_shortcode_id="167839" border_color_type="uncode-palette"][/vc_column_inner][vc_column_inner width="1/3"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Heirloom%20Tomato%20Salad%22%2C%22value%22%3A%22%2416%22%2C%22text%22%3A%22Heirloom%20tomatoes%2C%20burrata%2C%20basil%20pesto%2C%20sweet%20lime%20dressing%20and%20aged%20balsami%22%7D%2C%7B%22entry%22%3A%22Oysters%20on%20the%20Half%20Shell%22%2C%22value%22%3A%22%2425%22%2C%22text%22%3A%22Fresh%20oysters%20with%20a%20shallot%20vinegar%20mignonette%2C%20light%20garlic%20sauce%20and%20lemon%22%7D%2C%7B%22entry%22%3A%22Charred%20Octopus%22%2C%22value%22%3A%22%2421%22%2C%22text%22%3A%22Tender%20octopus%20with%20chorizo%2C%20potatoes%2C%20served%20with%20polenta%20and%20a%20smoked%20paprika%20aioli%22%7D%2C%7B%22entry%22%3A%22Beetroot%20Salmon%20Gravlax%22%2C%22value%22%3A%22%2420%22%2C%22text%22%3A%22House-cured%20salmon%20with%20beetroot%2C%20dill%20cream%20cheese%2C%20and%20fresh%20Italian%20capers%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_width_percent="0" border_style="dashed" border_color="color-gyho" heading_semantic="h6"  text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="400" sub_lead="yes" uncode_shortcode_id="717214" border_color_type="uncode-palette"][/vc_column_inner][/vc_row_inner][/vc_tab][vc_tab gutter_size="2" column_padding="4" title="Mains" tab_id="1671548483489-0-9167283140478516728331040301698674893862169997174201617065257079591715587857496" slug="mains"][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="4" shift_y="0" z_index="0" uncode_shortcode_id="362948" limit_content=""][vc_column_inner column_width_percent="100" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="129403"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Wagyu%20Beef%20Tenderloin%22%2C%22value%22%3A%22%2450%22%2C%22text%22%3A%22Pan-seared%20scallops%20on%20a%20bed%20of%20cauliflower%20puree%20with%20a%20balsamic%20reduction%22%7D%2C%7B%22entry%22%3A%22Pan-Roasted%20Duck%20Breast%22%2C%22value%22%3A%22%2435%22%2C%22text%22%3A%22Thinly%20sliced%20golden%20beets%2C%20goat%20cheese%2C%20walnut%2C%20with%20a%20citrus%20vinaigrette%22%7D%2C%7B%22entry%22%3A%22Wild%20Mushroom%20Risotto%22%2C%22value%22%3A%22%2430%22%2C%22text%22%3A%22Rich%20and%20creamy%20lobster%20bisque%2C%20sweet%20potato%20mash%2C%20flavored%20with%20cognac%20and%20fresh%20herbs%22%7D%2C%7B%22entry%22%3A%22Lobster%20Ravioli%22%2C%22value%22%3A%22%2442%22%2C%22text%22%3A%22Creamy%20burrata%20with%20black%20truffle%2C%20arugula%2C%20light%20garlic%20sauce%20and%20extra%20virgin%20olive%20oil%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_width_percent="0" border_style="dashed" border_color="color-gyho" heading_semantic="h6"  text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="400" sub_lead="yes" uncode_shortcode_id="916471" border_color_type="uncode-palette"][/vc_column_inner][vc_column_inner column_width_percent="100" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="203943"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Lamb%20Rack%20with%20Herb%20Crust%22%2C%22value%22%3A%22%2445%22%2C%22text%22%3A%22Savory%20tartlet%20filled%20with%20wild%20mushrooms%2C%20thyme%2C%20and%20Gruy%C3%A8re%20cheese%22%7D%2C%7B%22entry%22%3A%22Scallop%20and%20Shrimp%20Linguine%22%2C%22value%22%3A%22%2436%22%2C%22text%22%3A%22Smooth%20foie%20gras%20torchon%2C%20cherry%20compote%2C%20and%20toasted%20brioche%20with%20a%20traffle%20reduction%22%7D%2C%7B%22entry%22%3A%22Quail%20Stuffed%20with%20Foie%20Gras%22%2C%22value%22%3A%22%2440%22%2C%22text%22%3A%22Layered%20crab%20meat%2C%20avocado%2C%20mango%20salsa%2C%20light%20garlic%20sauce%20with%20a%20lime%20dressing%22%7D%2C%7B%22entry%22%3A%22Seabass%20en%20Papillote%22%2C%22value%22%3A%22%2438%22%2C%22text%22%3A%22Crisp%20crostini%20topped%20with%20tender%20duck%20confit%2C%20fig%20jam%2C%20italian%20tomato%2C%20brie%20and%20sweet%20potato%20mash%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_width_percent="0" border_style="dashed" border_color="color-gyho" heading_semantic="h6"  text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="400" sub_lead="yes" uncode_shortcode_id="186777" border_color_type="uncode-palette"][/vc_column_inner][vc_column_inner width="1/3"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Roasted%20Cauliflower%20Steak%22%2C%22value%22%3A%22%2428%22%2C%22text%22%3A%22Fresh%20oysters%20with%20a%20shallot%20vinegar%20mignonette%2C%20light%20garlic%20sauce%20and%20lemon%22%7D%2C%7B%22entry%22%3A%22Veal%20Osso%20Buco%22%2C%22value%22%3A%22%2444%22%2C%22text%22%3A%22Heirloom%20tomatoes%2C%20burrata%2C%20basil%20pesto%2C%20sweet%20lime%20dressing%20and%20aged%20balsami%22%7D%2C%7B%22entry%22%3A%22Truffle%20Chicken%20Breast%22%2C%22value%22%3A%22%2434%22%2C%22text%22%3A%22House-cured%20salmon%20with%20beetroot%2C%20dill%20cream%20cheese%2C%20and%20fresh%20Italian%20capers%22%7D%2C%7B%22entry%22%3A%22Black%20Cod%20with%20Miso%22%2C%22value%22%3A%22%2439%22%2C%22text%22%3A%22Tender%20octopus%20with%20chorizo%2C%20potatoes%2C%20served%20with%20polenta%20and%20a%20smoked%20paprika%20aioli%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_width_percent="0" border_style="dashed" border_color="color-gyho" heading_semantic="h6"  text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="400" sub_lead="yes" uncode_shortcode_id="962838" border_color_type="uncode-palette"][/vc_column_inner][/vc_row_inner][/vc_tab][vc_tab gutter_size="2" column_padding="4" title="Desserts" tab_id="1671548483266-0-3167283140478516728331040301698674893862169997174201617065257079591715587857496" slug="desserts"][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="4" shift_y="0" z_index="0" uncode_shortcode_id="362948" limit_content=""][vc_column_inner column_width_percent="100" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="129403"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Tiramisu%20Classico%22%2C%22value%22%3A%22%2414%22%2C%22text%22%3A%22Rich%20and%20creamy%20lobster%20bisque%2C%20sweet%20potato%20mash%2C%20flavored%20with%20cognac%20and%20fresh%20herbs%22%7D%2C%7B%22entry%22%3A%22Chocolate%20Lava%20Cake%22%2C%22value%22%3A%22%2445%22%2C%22text%22%3A%22Thinly%20sliced%20golden%20beets%2C%20goat%20cheese%2C%20walnut%2C%20with%20a%20citrus%20vinaigrette%22%7D%2C%7B%22entry%22%3A%22Lemon%20Tart%22%2C%22value%22%3A%22%2414%22%2C%22text%22%3A%22Pan-seared%20scallops%20on%20a%20bed%20of%20cauliflower%20puree%20with%20a%20balsamic%20reduction%22%7D%2C%7B%22entry%22%3A%22Raspberry%20Rose%20Pavlova%22%2C%22value%22%3A%22%2416%22%2C%22text%22%3A%22Creamy%20burrata%20with%20black%20truffle%2C%20arugula%2C%20light%20garlic%20sauce%20and%20extra%20virgin%20olive%20oil%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_width_percent="0" border_style="dashed" border_color="color-gyho" heading_semantic="h6"  text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="400" sub_lead="yes" uncode_shortcode_id="463777" border_color_type="uncode-palette"][/vc_column_inner][vc_column_inner column_width_percent="100" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/3" uncode_shortcode_id="203943"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Opera%20Cake%22%2C%22value%22%3A%22%2416%22%2C%22text%22%3A%22Layered%20crab%20meat%2C%20avocado%2C%20mango%20salsa%2C%20light%20garlic%20sauce%20with%20a%20lime%20dressing%22%7D%2C%7B%22entry%22%3A%22Cheese%20Selection%22%2C%22value%22%3A%22%2418%22%2C%22text%22%3A%22Crisp%20crostini%20topped%20with%20tender%20duck%20confit%2C%20fig%20jam%2C%20italian%20tomato%2C%20brie%20and%20sweet%20potato%20mash%22%7D%2C%7B%22entry%22%3A%22Peach%20Melba%22%2C%22value%22%3A%22%2415%22%2C%22text%22%3A%22Savory%20tartlet%20filled%20with%20wild%20mushrooms%2C%20thyme%2C%20and%20Gruy%C3%A8re%20cheese%22%7D%2C%7B%22entry%22%3A%22Saffron%20Panna%20Cotta%22%2C%22value%22%3A%22%2414%22%2C%22text%22%3A%22Smooth%20foie%20gras%20torchon%2C%20cherry%20compote%2C%20and%20toasted%20brioche%20with%20a%20traffle%20reduction%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_width_percent="0" border_style="dashed" border_color="color-gyho" heading_semantic="h6"  text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="400" sub_lead="yes" uncode_shortcode_id="872715" border_color_type="uncode-palette"][/vc_column_inner][vc_column_inner width="1/3"][uncode_pricing_list values="%5B%7B%22entry%22%3A%22Fig%20and%20Honey%20Sorbet%22%2C%22value%22%3A%22%2413%22%2C%22text%22%3A%22House-cured%20salmon%20with%20beetroot%2C%20dill%20cream%20cheese%2C%20and%20fresh%20Italian%20capers%22%7D%2C%7B%22entry%22%3A%22Apple%20Tarte%20Tatin%22%2C%22value%22%3A%22%2415%22%2C%22text%22%3A%22Heirloom%20tomatoes%2C%20burrata%2C%20basil%20pesto%2C%20sweet%20lime%20dressing%20and%20aged%20balsami%22%7D%2C%7B%22entry%22%3A%22Passion%20Fruit%20Mousse%22%2C%22value%22%3A%22%2414%22%2C%22text%22%3A%22Fresh%20oysters%20with%20a%20shallot%20vinegar%20mignonette%2C%20light%20garlic%20sauce%20and%20lemon%22%7D%2C%7B%22entry%22%3A%22Bourbon%20Vanilla%20Cr%C3%A8me%20Br%C3%BBl%C3%A9e%22%2C%22value%22%3A%22%2415%22%2C%22text%22%3A%22Tender%20octopus%20with%20chorizo%2C%20potatoes%2C%20served%20with%20polenta%20and%20a%20smoked%20paprika%20aioli%22%7D%5D" gutter_tab_h="2" tab_gap="2" media_width_percent="0" border_style="dashed" border_color="color-gyho" heading_semantic="h6"  text_size="'. uncode_wf_print_font_size( 'h4' ) .'" text_weight="400" sub_lead="yes" uncode_shortcode_id="132514" border_color_type="uncode-palette"][/vc_column_inner][/vc_row_inner][/vc_tab][/vc_tabs][/vc_column][/vc_row]
';

// Check if this wireframe is for a content block
if ( $data[ 'is_content_block' ] && ! $is_content_block ) {
	$data[ 'custom_class' ] .= ' for-content-blocks';
}

// Check if this wireframe requires a plugin
foreach ( $data[ 'dependency' ]  as $dependency ) {
	if ( ! UNCDWF_Dynamic::has_dependency( $dependency ) ) {
		$data[ 'custom_class' ] .= ' has-dependency needs-' . $dependency;
	}
}

vc_add_default_templates( $data );
