<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$profileUser = fup_get_user();

if ( ! $profileUser ) {
	return;
}

$form = new \FUP\FormBuilder();

$form
	->addSection(
		'',
		'theme',
		'',
		'' )
	->addSection(
		esc_html__( 'Profile page', 'front-user-profile' ),
		'profile',
		esc_html__( 'Customize your profile page', 'front-user-profile' ),
		'palette' );


// Dark mode
if ( fup_can( 'dark-mode' ) ) {
	$form
		->addRow(
			'theme',
			'row-1'
		);

	$form
		->addField(
			'row-1',
			'12',
			esc_html__( 'Enable dark mode', 'front-user-profile' ),
			esc_html__( 'Dark Mode puts the focus on the content areas of your interface, allowing that content to stand out while the surrounding chrome recedes into the background.', 'front-user-profile' ),
			'theme',
			'switch',
			'',
			isset( $_COOKIE['darktheme'] ) ? (int) htmlspecialchars( $_COOKIE['darktheme'] ) : 0,
			'',
			'moon-stars' );
}

$form
	->addRow(
		'profile',
		'row-2'
	)
	->addRow(
		'profile',
		'row-3'
	);

$cover_files = get_user_meta( $profileUser->data->ID, 'fup_cover', true );
$coverImage  = null;

if ( is_array( $cover_files ) && isset( $cover_files[ get_current_blog_id() ] ) ) {
	$upload_dir = wp_upload_dir();
	$coverImage = $upload_dir['baseurl'] . '/front-user-profile/' . $cover_files[ get_current_blog_id() ];
}

$form
	->addField(
		'row-2',
		'6',
		esc_html__( 'Avatar', 'front-user-profile' ),
		null,
		'avatar',
		'input',
		'file',
		get_avatar_url( $profileUser->data->ID ),
		'image/*' )
	->addField(
		'row-2',
		'6',
		esc_html__( 'Cover', 'front-user-profile' ),
		null,
		'cover',
		'input',
		'file',
		$coverImage ?: '',
		'image/*' );

if ( $coverImage ) {
	$form->addField(
		'row-3',
		'12',
		esc_html__( 'Cover overlay', 'front-user-profile' ),
		'',
		'overlay',
		'radio-colors',
		'radio',
		get_user_meta( $profileUser->data->ID, 'fup_cover_overlay', true ) );
}

$sections = $form->sections();


$error = [];

if ( count( $error ) > 0 ) {
	echo '<p class="error">' . implode( '<br />', $error ) . '</p>';
}

?>
<form action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" method="post" enctype="multipart/form-data">

	<?php fup_load_template( 'helpers/section', [
		'sections' => $sections,
		'form'     => $form
	] ) ?>

    <div class="svq-section-settings will-animate" data-cssanimate="fadeInUp">
        <div class="settings-item">
            <div class="form-action text-center">
                <input type="hidden" name="action" value="update_user_style">
                <input type="hidden" name="redirect"
                       value="<?php echo esc_url( $profileUser->pages['styles']['url'] ) ?>">
                <button type="submit" class="btn btn-dark btn-sm btn-glow btn-toggle-state button-ripple">
					<?php esc_html_e( 'Save styles', 'front-user-profile' ); ?>
                </button>
            </div>
        </div>
    </div>
</form>
