<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$profileUser = fup_get_user();

if ( ! $profileUser ) {
	return;
}

$form = new \FUP\FormBuilder();

$form
	->addSection(
		esc_html__( 'Your email', 'front-user-profile' ),
		'email',
		esc_html__( 'Change your email or your subscription preferences', 'front-user-profile' ),
		'envelope' )
	->addSection(
		esc_html__( 'Account', 'front-user-profile' ),
		'account',
		esc_html__( 'Change your account details', 'front-user-profile' ),
		'user-edit' )
	->addSection(
		esc_html__( 'Social', 'front-user-profile' ),
		'social',
		esc_html__( 'Change your social links', 'front-user-profile' ),
		'share' )
	->addSection(
		esc_html__( 'Security', 'front-user-profile' ),
		'security',
		esc_html__( 'Change your password', 'front-user-profile' ),
		'shield-check' );

$form
	->addRow(
		'email',
		'row-email'
	)
	->addField(
		'row-email',
		'12',
		esc_html__( 'Email', 'front-user-profile' ),
		'email@example.com',
		'email',
		'input',
		'email',
		$profileUser->data->user_email )
	->addRow(
		'email',
		'row-digest'
	)
	->addField(
		'row-digest',
		'12',
		esc_html__( 'Weekly digest', 'front-user-profile' ),
		esc_html__( 'We’ll email you weekly to share high-quality stories selected by our editors that we think you’ll enjoy.', 'front-user-profile' ),
		'digest',
		'switch',
		'',
		$profileUser->digest );

$form
	->addRow(
		'social',
		'row-facebook'
	)
	->addField(
		'row-facebook',
		'12',
		esc_html__( 'Facebook URL', 'front-user-profile' ),
		'https://facebook.com/USERNAME',
		'facebook',
		'input',
		'text',
		$profileUser->social['facebook'] )
	->addRow(
		'social',
		'row-instagram'
	)
	->addField(
		'row-instagram',
		'12',
		esc_html__( 'Instagram URL', 'front-user-profile' ),
		'https://instagram.com/USERNAME',
		'instagram',
		'input',
		'text',
		$profileUser->social['instagram'] )
	->addRow(
		'social',
		'row-twitter'
	)
	->addField(
		'row-twitter',
		'12',
		esc_html__( 'Twitter URL', 'front-user-profile' ),
		'https://twitter.com/USERNAME',
		'twitter',
		'input',
		'text',
		$profileUser->social['twitter'] )
	->addRow(
		'social',
		'row-linkedin'
	)
	->addField(
		'row-linkedin',
		'12',
		esc_html__( 'Linkedin URL', 'front-user-profile' ),
		'https://www.linkedin.com/in/USERNAME',
		'linkedin',
		'input',
		'text',
		$profileUser->social['linkedin'] );

$display_names                     = [];
$display_names['display_nickname'] = $profileUser->data->nickname;
$display_names['display_username'] = $profileUser->data->user_login;

if ( ! empty( $profileUser->data->first_name ) ) {
	$display_names['display_firstname'] = $profileUser->data->first_name;
}

if ( ! empty( $profileUser->data->last_name ) ) {
	$display_names['display_lastname'] = $profileUser->data->last_name;
}

if ( ! empty( $profileUser->data->first_name ) && ! empty( $profileUser->data->last_name ) ) {
	$display_names['display_firstlast'] = $profileUser->data->first_name . ' ' . $profileUser->data->last_name;
	$display_names['display_lastfirst'] = $profileUser->data->last_name . ' ' . $profileUser->data->first_name;
}

if ( ! in_array( $profileUser->data->display_name, $display_names, true ) ) { // Only add this if it isn't duplicated elsewhere.
	$display_names = array( 'display_displayname' => $profileUser->data->display_name ) + $display_names;
}

$display_names = array_map( 'trim', $display_names );
$display_names = array_unique( $display_names );

$form
	->addRow(
		'account',
		'row-name-display'
	)
	->addField(
		'row-name-display',
		'12',
		esc_html__( 'Display name as', 'front-user-profile' ),
		null,
		'display_name',
		'select',
		'text',
		$profileUser->data->display_name,
		'',
		'',
		$display_names )
	->addRow(
		'account',
		'row-account-name'
	)
	->addField(
		'row-account-name',
		'6',
		esc_html__( 'First Name', 'front-user-profile' ),
		esc_html__( 'Ex: John', 'front-user-profile' ),
		'firstname',
		'input',
		'text',
		$profileUser->data->user_firstname )
	->addField(
		'row-account-name',
		'6',
		esc_html__( 'Last Name', 'front-user-profile' ),
		esc_html__( 'Ex: Doe', 'front-user-profile' ),
		'lastname',
		'input',
		'text',
		$profileUser->data->user_lastname )
	->addRow(
		'account',
		'row-website'
	)
	->addField(
		'row-website',
		'12',
		esc_html__( 'Website', 'front-user-profile' ),
		'http(s)://your-website.com',
		'website',
		'input',
		'text',
		$profileUser->data->user_url )
	->addRow(
		'account',
		'row-bio'
	)
	->addField(
		'row-bio',
		'12',
		esc_html__( 'Bio', 'front-user-profile' ),
		esc_html__( 'Write something about you', 'front-user-profile' ),
		'bio',
		'textarea',
		'',
		$profileUser->data->description )
	->addRow(
		'account',
		'row-location'
	)
	->addField(
		'row-location',
		'6',
		esc_html__( 'Country', 'front-user-profile' ),
		esc_html__( 'What country are you from?', 'front-user-profile' ),
		'country',
		'input',
		'text',
		$profileUser->location['country'] )
	->addField(
		'row-location',
		'6',
		esc_html__( 'City', 'front-user-profile' ),
		esc_html__( 'In what city do you live?', 'front-user-profile' ),
		'city',
		'input',
		'text',
		$profileUser->location['city'] );

$form
	->addRow(
		'security',
		'row-password'
	)
	->addField(
		'row-password',
		'12',
		esc_html__( 'Password', 'front-user-profile' ),
		esc_html__( 'Your new password', 'front-user-profile' ),
		'password',
		'input',
		'password' )
	->addRow(
		'security',
		'row-password-confirmation'
	)
	->addField(
		'row-password-confirmation',
		'12',
		esc_html__( 'Confirm Password', 'front-user-profile' ),
		esc_html__( 'Enter the same password', 'front-user-profile' ),
		'confirm_password',
		'input',
		'password' );

$sections = $form->sections();


$error = [];

if ( count( $error ) > 0 ) {
	echo '<p class="error">' . implode( '<br />', $error ) . '</p>';
}

?>
<form action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" method="post" enctype="multipart/form-data">

	<?php if ( isset( $_GET['err'] ) && $_GET['err'] ) : ?>
		<?php
		$errors = explode( ',', $_GET['err'] );
		?>
        <div class="svq-errors">
            <h5><?php _e( 'Error', 'front-user-profile' ); ?></h5>
            <ul>
				<?php foreach ( $errors as $error ): ?>
                    <li>
						<?php echo fup_get_error_message( $error ); ?>
                    </li>
				<?php endforeach; ?>
            </ul>
        </div>
	<?php endif; ?>

	<?php fup_load_template( 'helpers/section', [
		'sections' => $sections,
		'form'     => $form
	] ) ?>

    <div class="svq-section-settings will-animate" data-cssanimate="fadeIn">
        <div class="settings-item">
            <div class="form-action text-center">
                <input type="hidden" name="action" value="update_user">
                <input type="hidden" name="redirect"
                       value="<?php echo esc_url( $profileUser->pages['settings']['url'] ) ?>">
                <button type="submit" class="btn btn-dark btn-sm btn-glow btn-toggle-state button-ripple">
					<?php esc_html_e( 'Save settings', 'front-user-profile' ); ?>
                </button>
            </div>
        </div>
    </div>
</form>
