<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$user       = fup_get_user();
$my_stories = fup_get_my_stories();
$stories    = $my_stories['articles'];

?>

<div class="section-reveal">
	<?php if ( $stories && $stories->have_posts() ) : ?>
        <div class="my-stories svq-article--list">
			<?php
			while ( $stories->have_posts() ) {
				$stories->the_post();
				fup_load_template( 'sections/article/default' );
			}
			?>
        </div>

		<?php

		$load_more   = false;
		$post_limits = fup_get_api_limit( 'posts' );

		if ( $stories->post_count >= $post_limits['initial'] ) {
			$load_more = true;
		}

		?>

		<?php if ( $load_more ) : ?>
            <div class="svq-load-more">
                <button type="button" class="btn btn-outline-dark btn-sm button-ripple svq-more btn-toggle-state"
                        data-more="stories" data-hash="<?php echo esc_attr( $my_stories['hash'] ) ?>"
                        data-user-id="<?php echo esc_attr( $user->data->ID ) ?>">
                    <span class="btn--loading-state">
                        <span class="svq-icon icon-loading icon-is-loading icon--x18"></span>
	                    <?php esc_html_e( 'Loading', 'front-user-profile' ) ?>
                    </span>
                    <span class="btn--default-state"><?php esc_html_e( 'Load more', 'front-user-profile' ) ?></span>
                </button>
            </div>
		<?php endif; ?>
	<?php else: ?>
		<?php if ( $user->data->ID === get_current_user_id() ) : ?>
            <div class="alert alert-warning will-animate" data-cssanimate="fadeIn">
				<?php esc_html_e( 'You have no published articles', 'front-user-profile' ) ?>
            </div>
		<?php else: ?>
            <div class="alert alert-warning">
				<?php esc_html_e( 'This author has not published articles yet!' , 'front-user-profile' ) ?>
            </div>
		<?php endif; ?>
	<?php endif; ?>

	<?php wp_reset_postdata(); ?>
</div>
