<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>

<?php foreach ( $following as $user ): ?>
    <div class="entry-meta will-animate" data-cssanimate="fadeIn">
        <div class="author-avatar">
            <a href="<?php echo esc_url( $user->profile_url ) ?>" class="avatar-link">
                <img src="<?php echo esc_url( $user->avatar_url ) ?>" alt="<?php echo esc_attr( $user->name ) ?>"
                     class="avatar-img">
            </a>
        </div>
        <div class="entry-meta__content">
            <span class="by-line">
                <span class="author">
                    <a href="<?php echo esc_url( $user->profile_url ) ?>">
                        <?php echo esc_html( $user->name ) ?>
                    </a>
                </span>
            </span>
            <span class="posted-on">
                <span class="entry-meta__text"><?php echo esc_html( $user->bio ) ?></span>
            </span>
        </div>
        <div class="entry-meta__action">
            <button type="button"
                    class="btn btn-light btn-sm btn-toggle-state button-ripple is-changed"
                    data-action="fup-author-unfollow" data-target="<?php echo esc_attr( $user->id ) ?>">
                <span class="btn--loading-state">
                    <span class="svq-icon icon-loading icon-is-loading icon--x18"></span>
	                <?php esc_html_e( 'Loading', 'front-user-profile' ) ?>
                </span>
                <span class="btn--default-state">
                    <?php esc_html_e( '+ Follow', 'front-user-profile' ) ?>
                </span>
                <span class="btn--active-state">
                    <?php esc_html_e( 'Following', 'front-user-profile' ) ?>
                </span>
            </button>
        </div>
    </div>
<?php endforeach; ?>
