<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>

<?php foreach ( $followers as $user ) : ?>
    <div class="entry-meta will-animate <?php echo esc_attr( $meta_classes ) ?>"
         data-cssanimate="fadeIn">
        <div class="author-avatar">
            <a href="<?php echo esc_url( $user->profile_url ) ?>" class="avatar-link">
                <img src="<?php echo esc_url( $user->avatar_url ) ?>" alt="<?php echo esc_attr( $user->name ) ?>"
                     class="avatar-img">
            </a>
        </div>
        <div class="entry-meta__content">
            <span class="by-line ">
                <span class="author">
                    <a href="<?php echo esc_url( $user->profile_url ) ?>">
                        <?php echo esc_html( $user->name ) ?>
                    </a>
                </span>
            </span>
            <span class="posted-on">
                <span class="entry-meta__text"><?php echo esc_html( $user->bio ) ?></span>
            </span>
        </div>
    </div>
<?php endforeach; ?>
