<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>

<?php foreach ( $categories as $category ): ?>
	<?php
	$following = in_array( (string) $category->cat_ID, $followingCategories, true );

	$btn_classes = [];
	$btn_action  = 'fup-category-follow';

	if ( $following ) {
		$btn_classes[] = 'is-changed';
		$btn_action    = 'fup-category-unfollow';
	}

	if ( ! is_user_logged_in() ) {
		$btn_classes[] = 'no-ajax';
	}

	$btn_classes = implode( ' ', $btn_classes );


	$image = ( new \Fup\CategoryImage() )->image_url( $category->term_id, null, false );

	if ( ! $image ) {
		$image = FUP_ASSETS_URL . 'img/cat-placeholder.png';
	}

	?>

    <span class="category-link will-animate has-thumbnail"
          data-cssanimate="fadeIn">
        <a href="#" rel="category tag"
           class="link-tag btn-toggle-state <?php echo esc_attr( $btn_classes ) ?>"
           data-action="<?php echo esc_attr( $btn_action ) ?>"
           data-target="<?php echo esc_attr( $category->cat_ID ) ?>" data-type="category">
            <span class="tag-action">
                <span class="btn--default-state">
                    <span class="svq-icon icon-circle icon--x18"></span>
                </span>
                <span class="btn--active-state">
                    <span class="svq-icon icon-check-circle icon--x18"></span>
                </span>
                <span class="btn--loading-state">
                    <span class="svq-icon icon-loading icon-is-loading icon--x18"></span>
                </span>
            </span>
            <span class="screen-reader-link"><?php echo esc_html( $category->cat_name ) ?></span>

	        <?php if ( $image ) : ?>
                <img class="svq-category-image lazy" src="<?php echo esc_url( $image ) ?>"
                     data-src="<?php echo esc_url( $image ) ?>"
                     alt="<?php echo esc_attr( $category->cat_name ) ?>">
	        <?php endif; ?>
        </a>
    </span>
<?php endforeach; ?>
