<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$stories = fup_get_categories_feed();

?>

<div class="section-reveal">
	<?php if ( ! empty( $stories ) && $stories->have_posts() ) : ?>
        <div class="feed-categories svq-article--list">
			<?php
			while ( $stories->have_posts() ) {
				$stories->the_post();
				fup_load_template( 'sections/article/default' );
			}
			?>
        </div>

		<?php

		$load_more   = false;
		$post_limits = fup_get_api_limit( 'posts' );

		if ( $stories->post_count >= $post_limits['initial'] ) {
			$load_more = true;
		}

		?>

		<?php if ( $load_more ) : ?>
            <div class="svq-load-more">
                <button type="button" class="btn btn-outline-dark btn-sm button-ripple svq-more btn-toggle-state"
                        data-more="feed-categories">
                    <span class="btn--loading-state">
                        <span class="svq-icon icon-loading icon-is-loading icon--x18"></span>
	                    <?php esc_html_e( 'Loading', 'front-user-profile' ) ?>
                    </span>
                    <span class="btn--default-state"><?php esc_html_e( 'Load more', 'front-user-profile' ) ?></span>
                </button>
            </div>
		<?php endif; ?>
	<?php else: ?>
        <div class="alert alert-warning will-animate" data-cssanimate="fadeIn">
			<?php esc_html_e( 'There is nothing in your feed at the moment. Make sure you are following any category.', 'front-user-profile' ) ?>
        </div>
	<?php endif; ?>

	<?php wp_reset_postdata(); ?>
</div>
