<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$drafts = fup_get_my_drafts();

?>

<div class="section-reveal">
	<?php if ( $drafts && $drafts->have_posts() ) : ?>
        <div class="my-drafts svq-article--list">
			<?php
			while ( $drafts->have_posts() ) {
				$drafts->the_post();
				fup_load_template( 'sections/article/default' );
			}
			?>
        </div>

		<?php

		$load_more   = false;
		$post_limits = fup_get_api_limit( 'posts' );

		if ( $drafts->post_count >= $post_limits['initial'] ) {
			$load_more = true;
		}

		?>

		<?php if ( $load_more ) : ?>
            <div class="svq-load-more">
                <button type="button" class="btn btn-outline-dark btn-sm button-ripple svq-more btn-toggle-state"
                        data-more="drafts">
                    <span class="btn--loading-state">
                        <span class="svq-icon icon-loading icon-is-loading icon--x18"></span>
	                    <?php esc_html_e( 'Loading', 'front-user-profile' ) ?>
                    </span>
                    <span class="btn--default-state"><?php esc_html_e( 'Load more', 'front-user-profile' ) ?></span>
                </button>
            </div>
		<?php endif; ?>
	<?php else: ?>
        <div class="alert alert-warning will-animate" data-cssanimate="fadeIn">
			<?php esc_html_e( 'You don\'t have any drafts.', 'front-user-profile' ) ?>
        </div>
	<?php endif; ?>
	<?php wp_reset_postdata(); ?>
</div>
