<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! isset( $post_id ) ) {
	$post_id = get_the_ID();
}

?>

<p class="comment-subscription">
    <span class="svq-icon icon-bullhorn icon--x16 mr-2"></span>
	<?php
	echo sprintf(
		wp_kses(
			__( '%s from notifications.', 'front-user-profile' ),
			[
				'a' => [
					'href'      => [],
					'class'     => [],
					'data-post' => []
				]
			]
		),
		'<a href="#" class="unsubscribe svq-unsubscribe" data-post="' . esc_attr( $post_id ) . '">' . esc_html__( 'Unsubscribe', 'front-user-profile' ) . '</a>'
	);
	?>
</p>
